// services/webnn/public/mojom/webnn_error.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_error.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_error.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_error.mojom-import-headers.h"
#include "services/webnn/public/mojom/webnn_error.mojom-test-utils.h"


namespace webnn::mojom {
Error::Error()
    : code(),
      message() {}

Error::Error(
    Error::Code code_in,
    const std::string& message_in)
    : code(std::move(code_in)),
      message(std::move(message_in)) {}

Error::~Error() = default;
size_t Error::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->code);
  seed = mojo::internal::Hash(seed, this->message);
  return seed;
}

void Error::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Error::Code>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Error::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // webnn::mojom


namespace mojo {


// static
bool StructTraits<::webnn::mojom::Error::DataView, ::webnn::mojom::ErrorPtr>::Read(
    ::webnn::mojom::Error::DataView input,
    ::webnn::mojom::ErrorPtr* output) {
  bool success = true;
  ::webnn::mojom::ErrorPtr result(::webnn::mojom::Error::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom {




}  // webnn::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif