// services/webnn/public/mojom/webnn_error.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_ERROR_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_ERROR_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/webnn/public/mojom/webnn_error.mojom-shared-internal.h"


namespace webnn::mojom {
class ErrorDataView;



}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::ErrorDataView> {
  using Data = ::webnn::mojom::internal::Error_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {


enum class Error_Code : int32_t {
  
  kUnknownError = 0,
  
  kNotSupportedError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Error_Code value);
inline bool IsKnownEnumValue(Error_Code value) {
  return internal::Error_Code_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ErrorDataView {
 public:
  ErrorDataView() = default;

  ErrorDataView(
      internal::Error_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::webnn::mojom::Error_Code>(
        data_value, output);
  }
  Error_Code code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Error_Code>(data_->code));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Error_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_ERROR_MOJOM_DATA_VIEW_H_