// services/webnn/public/mojom/webnn_context_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-params-data.h"
namespace webnn {
namespace mojom {

NOINLINE static const char* CreateContextOptions_PowerPreferenceToStringHelper(CreateContextOptions_PowerPreference value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateContextOptions_PowerPreference::kDefault:
      return "kDefault";
    case CreateContextOptions_PowerPreference::kHighPerformance:
      return "kHighPerformance";
    case CreateContextOptions_PowerPreference::kLowPower:
      return "kLowPower";
    default:
      return nullptr;
  }
}

std::string CreateContextOptions_PowerPreferenceToString(CreateContextOptions_PowerPreference value) {
  const char *str = CreateContextOptions_PowerPreferenceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateContextOptions_PowerPreference value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateContextOptions_PowerPreference value) {
  return os << CreateContextOptions_PowerPreferenceToString(value);
}

namespace internal {
// static
bool CreateContextResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateContextResult_Data* object = static_cast<const CreateContextResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateContextResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case CreateContextResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateContextResult");
      return false;
    }
  }
}


// static
bool CreateContextOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateContextOptions_Data* object =
      static_cast<const CreateContextOptions_Data*>(data);


  if (!::webnn::mojom::internal::Device_Data
        ::Validate(object->device, validation_context))
    return false;


  if (!::webnn::mojom::internal::CreateContextOptions_PowerPreference_Data
        ::Validate(object->power_preference, validation_context))
    return false;

  return true;
}

CreateContextOptions_Data::CreateContextOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CreateContextSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateContextSuccess_Data* object =
      static_cast<const CreateContextSuccess_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->context_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_properties, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_properties, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_handle, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_handle, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->write_tensor_producer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->read_tensor_consumer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CreateContextSuccess_Data::CreateContextSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContextProvider_CreateWebNNContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContextProvider_CreateWebNNContext_Params_Data* object =
      static_cast<const WebNNContextProvider_CreateWebNNContext_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebNNContextProvider_CreateWebNNContext_Params_Data::WebNNContextProvider_CreateWebNNContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContextProvider_CreateWebNNContext_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContextProvider_CreateWebNNContext_ResponseParams_Data* object =
      static_cast<const WebNNContextProvider_CreateWebNNContext_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNContextProvider_CreateWebNNContext_ResponseParams_Data::WebNNContextProvider_CreateWebNNContext_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::CreateContextOptions_PowerPreference>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::CreateContextOptions_PowerPreference value) {
  return std::move(context).WriteString(::webnn::mojom::CreateContextOptions_PowerPreferenceToString(value));
}

} // namespace perfetto