// services/webnn/public/mojom/webnn_context_provider.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_BLINK_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context_provider.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/features.mojom-blink-forward.h"
#include "services/webnn/public/mojom/webnn_context.mojom-blink-forward.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-blink.h"
#include "services/webnn/public/mojom/webnn_device.mojom-blink-forward.h"
#include "services/webnn/public/mojom/webnn_error.mojom-blink.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace webnn::mojom::blink {

class WebNNContextProviderProxy;

template <typename ImplRefTraits>
class WebNNContextProviderStub;

class WebNNContextProviderRequestValidator;
class WebNNContextProviderResponseValidator;


class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) WebNNContextProvider
    : public WebNNContextProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webnn.mojom.WebNNContextProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static bool RuntimeFeature_IsEnabled_(bool expected);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebNNContextProviderInterfaceBase;
  using Proxy_ = WebNNContextProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebNNContextProviderStub<ImplRefTraits>;

  using RequestValidator_ = WebNNContextProviderRequestValidator;
  using ResponseValidator_ = WebNNContextProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWebNNContextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWebNNContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebNNContextProvider() = default;

  using CreateWebNNContextCallback = base::OnceCallback<void(CreateContextResultPtr)>;
  using CreateWebNNContextMojoCallback = base::OnceCallback<void(CreateContextResultPtr)>;

  virtual void CreateWebNNContext(CreateContextOptionsPtr options, CreateWebNNContextCallback callback) = 0;
};



class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) WebNNContextProviderProxy
    : public WebNNContextProvider {
 public:
  using InterfaceType = WebNNContextProvider;

  explicit WebNNContextProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWebNNContext(CreateContextOptionsPtr options, CreateWebNNContextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) WebNNContextProviderStubDispatch {
 public:
  static bool Accept(WebNNContextProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebNNContextProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebNNContextProvider>>
class WebNNContextProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebNNContextProviderStub() = default;
  ~WebNNContextProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNContextProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNContextProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) WebNNContextProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) WebNNContextProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) CreateContextOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateContextOptions, T>::value>;
  using DataView = CreateContextOptionsDataView;
  using Data_ = internal::CreateContextOptions_Data;
  using PowerPreference = CreateContextOptions_PowerPreference;

  template <typename... Args>
  static CreateContextOptionsPtr New(Args&&... args) {
    return CreateContextOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateContextOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CreateContextOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateContextOptions>::Convert(*this);
  }


  CreateContextOptions();

  CreateContextOptions(
      ::webnn::mojom::blink::Device device,
      CreateContextOptions::PowerPreference power_preference);


  ~CreateContextOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateContextOptionsPtr>
  CreateContextOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateContextOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateContextOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateContextOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateContextOptions_UnserializedMessageContext<
            UserType, CreateContextOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateContextOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateContextOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateContextOptions_UnserializedMessageContext<
            UserType, CreateContextOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateContextOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::webnn::mojom::blink::Device device;
  
  CreateContextOptions::PowerPreference power_preference;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateContextOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) CreateContextResult {
 public:
  using DataView = CreateContextResultDataView;
  using Data_ = internal::CreateContextResult_Data;
  using Tag = Data_::CreateContextResult_Tag;

  template <typename... Args>
  static CreateContextResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CreateContextResultPtr NewSuccess(
      CreateContextSuccessPtr value);
  // Construct an instance holding |error|.
  static CreateContextResultPtr NewError(
      ::webnn::mojom::blink::ErrorPtr value);

  template <typename U>
  static CreateContextResultPtr From(const U& u) {
    return mojo::TypeConverter<CreateContextResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateContextResult>::Convert(*this);
  }
  ~CreateContextResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateContextResult(const CreateContextResult& other) = delete;
  CreateContextResult& operator=(const CreateContextResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateContextResultPtr>
  CreateContextResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateContextResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateContextResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const CreateContextSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  CreateContextSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(CreateContextSuccessPtr success);

  bool is_error() const { return tag_ == Tag::kError; }
  const ::webnn::mojom::blink::ErrorPtr& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  ::webnn::mojom::blink::ErrorPtr& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(::webnn::mojom::blink::ErrorPtr error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateContextResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateContextResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        CreateContextSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        ::webnn::mojom::blink::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreateContextSuccessPtr success;
    ::webnn::mojom::blink::ErrorPtr error;
  };

  CreateContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      CreateContextSuccessPtr value);
  CreateContextResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      ::webnn::mojom::blink::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) CreateContextSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateContextSuccess, T>::value>;
  using DataView = CreateContextSuccessDataView;
  using Data_ = internal::CreateContextSuccess_Data;

  template <typename... Args>
  static CreateContextSuccessPtr New(Args&&... args) {
    return CreateContextSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateContextSuccessPtr From(const U& u) {
    return mojo::TypeConverter<CreateContextSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateContextSuccess>::Convert(*this);
  }


  CreateContextSuccess();

  CreateContextSuccess(
      ::mojo::PendingRemote<::webnn::mojom::blink::WebNNContext> context_remote,
      const ::webnn::ContextProperties& context_properties,
      const ::blink::WebNNContextToken& context_handle,
      ::mojo::ScopedDataPipeProducerHandle write_tensor_producer,
      ::mojo::ScopedDataPipeConsumerHandle read_tensor_consumer);

CreateContextSuccess(const CreateContextSuccess&) = delete;
CreateContextSuccess& operator=(const CreateContextSuccess&) = delete;

  ~CreateContextSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateContextSuccessPtr>
  CreateContextSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateContextSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateContextSuccess_UnserializedMessageContext<
            UserType, CreateContextSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateContextSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateContextSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateContextSuccess_UnserializedMessageContext<
            UserType, CreateContextSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateContextSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::webnn::mojom::blink::WebNNContext> context_remote;
  
  ::webnn::ContextProperties context_properties;
  
  ::blink::WebNNContextToken context_handle;
  
  ::mojo::ScopedDataPipeProducerHandle write_tensor_producer;
  
  ::mojo::ScopedDataPipeConsumerHandle read_tensor_consumer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateContextSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CreateContextResultPtr CreateContextResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateContextResult>::value>::type*>
bool CreateContextResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
CreateContextOptionsPtr CreateContextOptions::Clone() const {
  return New(
      mojo::Clone(device),
      mojo::Clone(power_preference)
  );
}

template <typename T, CreateContextOptions::EnableIfSame<T>*>
bool CreateContextOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device, other_struct.device))
    return false;
  if (!mojo::Equals(this->power_preference, other_struct.power_preference))
    return false;
  return true;
}

template <typename T, CreateContextOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device < rhs.device)
    return true;
  if (rhs.device < lhs.device)
    return false;
  if (lhs.power_preference < rhs.power_preference)
    return true;
  if (rhs.power_preference < lhs.power_preference)
    return false;
  return false;
}
template <typename StructPtrType>
CreateContextSuccessPtr CreateContextSuccess::Clone() const {
  return New(
      mojo::Clone(context_remote),
      mojo::Clone(context_properties),
      mojo::Clone(context_handle),
      mojo::Clone(write_tensor_producer),
      mojo::Clone(read_tensor_consumer)
  );
}

template <typename T, CreateContextSuccess::EnableIfSame<T>*>
bool CreateContextSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->context_remote, other_struct.context_remote))
    return false;
  if (!mojo::Equals(this->context_properties, other_struct.context_properties))
    return false;
  if (!mojo::Equals(this->context_handle, other_struct.context_handle))
    return false;
  if (!mojo::Equals(this->write_tensor_producer, other_struct.write_tensor_producer))
    return false;
  if (!mojo::Equals(this->read_tensor_consumer, other_struct.read_tensor_consumer))
    return false;
  return true;
}

template <typename T, CreateContextSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.context_remote < rhs.context_remote)
    return true;
  if (rhs.context_remote < lhs.context_remote)
    return false;
  if (lhs.context_properties < rhs.context_properties)
    return true;
  if (rhs.context_properties < lhs.context_properties)
    return false;
  if (lhs.context_handle < rhs.context_handle)
    return true;
  if (rhs.context_handle < lhs.context_handle)
    return false;
  if (lhs.write_tensor_producer < rhs.write_tensor_producer)
    return true;
  if (rhs.write_tensor_producer < lhs.write_tensor_producer)
    return false;
  if (lhs.read_tensor_consumer < rhs.read_tensor_consumer)
    return true;
  if (rhs.read_tensor_consumer < lhs.read_tensor_consumer)
    return false;
  return false;
}


}  // webnn::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::CreateContextOptions::DataView,
                                         ::webnn::mojom::blink::CreateContextOptionsPtr> {
  static bool IsNull(const ::webnn::mojom::blink::CreateContextOptionsPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::CreateContextOptionsPtr* output) { output->reset(); }

  static decltype(::webnn::mojom::blink::CreateContextOptions::device) device(
      const ::webnn::mojom::blink::CreateContextOptionsPtr& input) {
    return input->device;
  }

  static decltype(::webnn::mojom::blink::CreateContextOptions::power_preference) power_preference(
      const ::webnn::mojom::blink::CreateContextOptionsPtr& input) {
    return input->power_preference;
  }

  static bool Read(::webnn::mojom::blink::CreateContextOptions::DataView input, ::webnn::mojom::blink::CreateContextOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) StructTraits<::webnn::mojom::blink::CreateContextSuccess::DataView,
                                         ::webnn::mojom::blink::CreateContextSuccessPtr> {
  static bool IsNull(const ::webnn::mojom::blink::CreateContextSuccessPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::CreateContextSuccessPtr* output) { output->reset(); }

  static  decltype(::webnn::mojom::blink::CreateContextSuccess::context_remote)& context_remote(
       ::webnn::mojom::blink::CreateContextSuccessPtr& input) {
    return input->context_remote;
  }

  static const decltype(::webnn::mojom::blink::CreateContextSuccess::context_properties)& context_properties(
      const ::webnn::mojom::blink::CreateContextSuccessPtr& input) {
    return input->context_properties;
  }

  static const decltype(::webnn::mojom::blink::CreateContextSuccess::context_handle)& context_handle(
      const ::webnn::mojom::blink::CreateContextSuccessPtr& input) {
    return input->context_handle;
  }

  static  decltype(::webnn::mojom::blink::CreateContextSuccess::write_tensor_producer)& write_tensor_producer(
       ::webnn::mojom::blink::CreateContextSuccessPtr& input) {
    return input->write_tensor_producer;
  }

  static  decltype(::webnn::mojom::blink::CreateContextSuccess::read_tensor_consumer)& read_tensor_consumer(
       ::webnn::mojom::blink::CreateContextSuccessPtr& input) {
    return input->read_tensor_consumer;
  }

  static bool Read(::webnn::mojom::blink::CreateContextSuccess::DataView input, ::webnn::mojom::blink::CreateContextSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM_BLINK) UnionTraits<::webnn::mojom::blink::CreateContextResult::DataView,
                                        ::webnn::mojom::blink::CreateContextResultPtr> {
  static bool IsNull(const ::webnn::mojom::blink::CreateContextResultPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::blink::CreateContextResultPtr* output) { output->reset(); }

  static ::webnn::mojom::blink::CreateContextResult::Tag GetTag(const ::webnn::mojom::blink::CreateContextResultPtr& input) {
    return input->which();
  }

  static  ::webnn::mojom::blink::CreateContextSuccessPtr& success( ::webnn::mojom::blink::CreateContextResultPtr& input) {
    return input->get_success();
  }

  static const ::webnn::mojom::blink::ErrorPtr& error(const ::webnn::mojom::blink::CreateContextResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::webnn::mojom::blink::CreateContextResult::DataView input, ::webnn::mojom::blink::CreateContextResultPtr* output);
};
namespace internal {
template <>
inline bool GetRuntimeFeature_IsEnabled<::webnn::mojom::blink::WebNNContextProvider>() {
  return ::webnn::mojom::blink::WebNNContextProvider::RuntimeFeature_IsEnabled_(false);
}
template <>
inline bool GetRuntimeFeature_ExpectEnabled<::webnn::mojom::blink::WebNNContextProvider>() {
  return ::webnn::mojom::blink::WebNNContextProvider::RuntimeFeature_IsEnabled_(true);
}template <>
inline constexpr bool kIsRuntimeFeatureGuarded<::webnn::mojom::blink::WebNNContextProvider> = true;
}  // namespace internal

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROVIDER_MOJOM_BLINK_H_