// services/webnn/public/mojom/webnn_context_properties.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared-internal.h"


namespace webnn::mojom {
class SupportedDataTypesDataView;

class SupportedRanksDataView;

class SupportedTensorsDataView;

class DataTypeLimitsDataView;

class ContextPropertiesDataView;



}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::SupportedDataTypesDataView> {
  using Data = ::webnn::mojom::internal::SupportedDataTypes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SupportedRanksDataView> {
  using Data = ::webnn::mojom::internal::SupportedRanks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::SupportedTensorsDataView> {
  using Data = ::webnn::mojom::internal::SupportedTensors_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::DataTypeLimitsDataView> {
  using Data = ::webnn::mojom::internal::DataTypeLimits_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::ContextPropertiesDataView> {
  using Data = ::webnn::mojom::internal::ContextProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {


enum class InputOperandLayout : int32_t {
  
  kChannelsFirst = 0,
  
  kChannelsLast = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InputOperandLayout value);
inline bool IsKnownEnumValue(InputOperandLayout value) {
  return internal::InputOperandLayout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Resample2DAxes : int32_t {
  
  kAny = 0,
  
  kChannelsFirst = 1,
  
  kChannelsLast = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Resample2DAxes value);
inline bool IsKnownEnumValue(Resample2DAxes value) {
  return internal::Resample2DAxes_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BatchNormalizationAxis : int32_t {
  
  kAny = 0,
  
  kChannelsFirst = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(WEBNN_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BatchNormalizationAxis value);
inline bool IsKnownEnumValue(BatchNormalizationAxis value) {
  return internal::BatchNormalizationAxis_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SupportedDataTypesDataView {
 public:
  SupportedDataTypesDataView() = default;

  SupportedDataTypesDataView(
      internal::SupportedDataTypes_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool float32() const {
    return data_->float32;
  }
  bool float16() const {
    return data_->float16;
  }
  bool int32() const {
    return data_->int32;
  }
  bool uint32() const {
    return data_->uint32;
  }
  bool int64() const {
    return data_->int64;
  }
  bool uint64() const {
    return data_->uint64;
  }
  bool int8() const {
    return data_->int8;
  }
  bool uint8() const {
    return data_->uint8;
  }
  bool int4() const {
    return data_->int4;
  }
  bool uint4() const {
    return data_->uint4;
  }
 private:
  internal::SupportedDataTypes_Data* data_ = nullptr;
};


class SupportedRanksDataView {
 public:
  SupportedRanksDataView() = default;

  SupportedRanksDataView(
      internal::SupportedRanks_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t min() const {
    return data_->min;
  }
  uint32_t max() const {
    return data_->max;
  }
 private:
  internal::SupportedRanks_Data* data_ = nullptr;
};


class SupportedTensorsDataView {
 public:
  SupportedTensorsDataView() = default;

  SupportedTensorsDataView(
      internal::SupportedTensors_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataTypesDataView(
      SupportedDataTypesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataTypes(UserType* output) {
    
    auto* pointer = data_->data_types.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedDataTypesDataView>(
        pointer, output, message_);
  }
  inline void GetRanksDataView(
      SupportedRanksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRanks(UserType* output) {
    
    auto* pointer = data_->ranks.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedRanksDataView>(
        pointer, output, message_);
  }
 private:
  internal::SupportedTensors_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataTypeLimitsDataView {
 public:
  DataTypeLimitsDataView() = default;

  DataTypeLimitsDataView(
      internal::DataTypeLimits_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInput(UserType* output) {
    
    auto* pointer = data_->input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConstantDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstant(UserType* output) {
    
    auto* pointer = data_->constant.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetArgMinMaxInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArgMinMaxInput(UserType* output) {
    
    auto* pointer = data_->arg_min_max_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetArgMinMaxOutputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArgMinMaxOutput(UserType* output) {
    
    auto* pointer = data_->arg_min_max_output.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetBatchNormalizationInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBatchNormalizationInput(UserType* output) {
    
    auto* pointer = data_->batch_normalization_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetBatchNormalizationMeanDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBatchNormalizationMean(UserType* output) {
    
    auto* pointer = data_->batch_normalization_mean.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetCastInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCastInput(UserType* output) {
    
    auto* pointer = data_->cast_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetClampInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClampInput(UserType* output) {
    
    auto* pointer = data_->clamp_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConcatInputsDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConcatInputs(UserType* output) {
    
    auto* pointer = data_->concat_inputs.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConv2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConv2dInput(UserType* output) {
    
    auto* pointer = data_->conv2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConv2dBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConv2dBias(UserType* output) {
    
    auto* pointer = data_->conv2d_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConvTranspose2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConvTranspose2dInput(UserType* output) {
    
    auto* pointer = data_->conv_transpose2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetConvTranspose2dBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConvTranspose2dBias(UserType* output) {
    
    auto* pointer = data_->conv_transpose2d_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetCumulativeSumInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCumulativeSumInput(UserType* output) {
    
    auto* pointer = data_->cumulative_sum_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetDequantizeLinearInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDequantizeLinearInput(UserType* output) {
    
    auto* pointer = data_->dequantize_linear_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetDequantizeLinearScaleDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDequantizeLinearScale(UserType* output) {
    
    auto* pointer = data_->dequantize_linear_scale.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetDequantizeLinearZeroPointDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDequantizeLinearZeroPoint(UserType* output) {
    
    auto* pointer = data_->dequantize_linear_zero_point.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetAddInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAddInput(UserType* output) {
    
    auto* pointer = data_->add_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSubInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubInput(UserType* output) {
    
    auto* pointer = data_->sub_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetMulInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMulInput(UserType* output) {
    
    auto* pointer = data_->mul_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetDivInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDivInput(UserType* output) {
    
    auto* pointer = data_->div_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetMaxInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxInput(UserType* output) {
    
    auto* pointer = data_->max_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetMinInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinInput(UserType* output) {
    
    auto* pointer = data_->min_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetPowInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPowInput(UserType* output) {
    
    auto* pointer = data_->pow_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetEqualInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEqualInput(UserType* output) {
    
    auto* pointer = data_->equal_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGreaterInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGreaterInput(UserType* output) {
    
    auto* pointer = data_->greater_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGreaterOrEqualInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGreaterOrEqualInput(UserType* output) {
    
    auto* pointer = data_->greater_or_equal_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLesserInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLesserInput(UserType* output) {
    
    auto* pointer = data_->lesser_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLesserOrEqualInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLesserOrEqualInput(UserType* output) {
    
    auto* pointer = data_->lesser_or_equal_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetNotEqualInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotEqualInput(UserType* output) {
    
    auto* pointer = data_->not_equal_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogicalAndInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogicalAndInput(UserType* output) {
    
    auto* pointer = data_->logical_and_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogicalOrInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogicalOrInput(UserType* output) {
    
    auto* pointer = data_->logical_or_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogicalXorInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogicalXorInput(UserType* output) {
    
    auto* pointer = data_->logical_xor_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogicalNotInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogicalNotInput(UserType* output) {
    
    auto* pointer = data_->logical_not_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetIsNanInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsNanInput(UserType* output) {
    
    auto* pointer = data_->is_nan_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetIsInfiniteInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsInfiniteInput(UserType* output) {
    
    auto* pointer = data_->is_infinite_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogicalOutputDataView(
      SupportedDataTypesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogicalOutput(UserType* output) {
    
    auto* pointer = data_->logical_output.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedDataTypesDataView>(
        pointer, output, message_);
  }
  inline void GetAbsInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAbsInput(UserType* output) {
    
    auto* pointer = data_->abs_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetCeilInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCeilInput(UserType* output) {
    
    auto* pointer = data_->ceil_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetCosInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCosInput(UserType* output) {
    
    auto* pointer = data_->cos_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetErfInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErfInput(UserType* output) {
    
    auto* pointer = data_->erf_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetExpInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpInput(UserType* output) {
    
    auto* pointer = data_->exp_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetFloorInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFloorInput(UserType* output) {
    
    auto* pointer = data_->floor_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetIdentityInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentityInput(UserType* output) {
    
    auto* pointer = data_->identity_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLogInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogInput(UserType* output) {
    
    auto* pointer = data_->log_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetNegInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegInput(UserType* output) {
    
    auto* pointer = data_->neg_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReciprocalInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReciprocalInput(UserType* output) {
    
    auto* pointer = data_->reciprocal_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetRoundEvenInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoundEvenInput(UserType* output) {
    
    auto* pointer = data_->round_even_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSignInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignInput(UserType* output) {
    
    auto* pointer = data_->sign_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSinInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinInput(UserType* output) {
    
    auto* pointer = data_->sin_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSqrtInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSqrtInput(UserType* output) {
    
    auto* pointer = data_->sqrt_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetTanInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTanInput(UserType* output) {
    
    auto* pointer = data_->tan_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetEluInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEluInput(UserType* output) {
    
    auto* pointer = data_->elu_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetExpandInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpandInput(UserType* output) {
    
    auto* pointer = data_->expand_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherInput(UserType* output) {
    
    auto* pointer = data_->gather_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherIndicesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherIndices(UserType* output) {
    
    auto* pointer = data_->gather_indices.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherElementsInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherElementsInput(UserType* output) {
    
    auto* pointer = data_->gather_elements_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherElementsIndicesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherElementsIndices(UserType* output) {
    
    auto* pointer = data_->gather_elements_indices.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherNdInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherNdInput(UserType* output) {
    
    auto* pointer = data_->gather_nd_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGatherNdIndicesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGatherNdIndices(UserType* output) {
    
    auto* pointer = data_->gather_nd_indices.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGeluInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeluInput(UserType* output) {
    
    auto* pointer = data_->gelu_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGemmADataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGemmA(UserType* output) {
    
    auto* pointer = data_->gemm_a.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGemmCDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGemmC(UserType* output) {
    
    auto* pointer = data_->gemm_c.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGruInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGruInput(UserType* output) {
    
    auto* pointer = data_->gru_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGruBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGruBias(UserType* output) {
    
    auto* pointer = data_->gru_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGruOutputSequenceDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGruOutputSequence(UserType* output) {
    
    auto* pointer = data_->gru_output_sequence.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGruCellInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGruCellInput(UserType* output) {
    
    auto* pointer = data_->gru_cell_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetGruCellBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGruCellBias(UserType* output) {
    
    auto* pointer = data_->gru_cell_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetHardSigmoidInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHardSigmoidInput(UserType* output) {
    
    auto* pointer = data_->hard_sigmoid_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetHardSwishInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHardSwishInput(UserType* output) {
    
    auto* pointer = data_->hard_swish_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceNormalizationInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceNormalizationInput(UserType* output) {
    
    auto* pointer = data_->instance_normalization_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetInstanceNormalizationScaleDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInstanceNormalizationScale(UserType* output) {
    
    auto* pointer = data_->instance_normalization_scale.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLayerNormalizationInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerNormalizationInput(UserType* output) {
    
    auto* pointer = data_->layer_normalization_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLeakyReluInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLeakyReluInput(UserType* output) {
    
    auto* pointer = data_->leaky_relu_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLinearInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinearInput(UserType* output) {
    
    auto* pointer = data_->linear_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLstmInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLstmInput(UserType* output) {
    
    auto* pointer = data_->lstm_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLstmBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLstmBias(UserType* output) {
    
    auto* pointer = data_->lstm_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLstmOutputSequenceDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLstmOutputSequence(UserType* output) {
    
    auto* pointer = data_->lstm_output_sequence.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLstmCellInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLstmCellInput(UserType* output) {
    
    auto* pointer = data_->lstm_cell_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetLstmCellBiasDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLstmCellBias(UserType* output) {
    
    auto* pointer = data_->lstm_cell_bias.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetMatmulInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatmulInput(UserType* output) {
    
    auto* pointer = data_->matmul_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetPadInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPadInput(UserType* output) {
    
    auto* pointer = data_->pad_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetAveragePool2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAveragePool2dInput(UserType* output) {
    
    auto* pointer = data_->average_pool2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetL2Pool2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadL2Pool2dInput(UserType* output) {
    
    auto* pointer = data_->l2_pool2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetMaxPool2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxPool2dInput(UserType* output) {
    
    auto* pointer = data_->max_pool2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetPreluInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreluInput(UserType* output) {
    
    auto* pointer = data_->prelu_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetQuantizeLinearInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuantizeLinearInput(UserType* output) {
    
    auto* pointer = data_->quantize_linear_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetQuantizeLinearZeroPointDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuantizeLinearZeroPoint(UserType* output) {
    
    auto* pointer = data_->quantize_linear_zero_point.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceL1InputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceL1Input(UserType* output) {
    
    auto* pointer = data_->reduce_l1_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceL2InputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceL2Input(UserType* output) {
    
    auto* pointer = data_->reduce_l2_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceLogSumInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceLogSumInput(UserType* output) {
    
    auto* pointer = data_->reduce_log_sum_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceLogSumExpInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceLogSumExpInput(UserType* output) {
    
    auto* pointer = data_->reduce_log_sum_exp_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceMaxInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceMaxInput(UserType* output) {
    
    auto* pointer = data_->reduce_max_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceMeanInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceMeanInput(UserType* output) {
    
    auto* pointer = data_->reduce_mean_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceMinInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceMinInput(UserType* output) {
    
    auto* pointer = data_->reduce_min_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceProductInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceProductInput(UserType* output) {
    
    auto* pointer = data_->reduce_product_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceSumInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceSumInput(UserType* output) {
    
    auto* pointer = data_->reduce_sum_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReduceSumSquareInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReduceSumSquareInput(UserType* output) {
    
    auto* pointer = data_->reduce_sum_square_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReluInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReluInput(UserType* output) {
    
    auto* pointer = data_->relu_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetResample2dInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResample2dInput(UserType* output) {
    
    auto* pointer = data_->resample2d_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReshapeInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReshapeInput(UserType* output) {
    
    auto* pointer = data_->reshape_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetReverseInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReverseInput(UserType* output) {
    
    auto* pointer = data_->reverse_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetScatterElementsInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScatterElementsInput(UserType* output) {
    
    auto* pointer = data_->scatter_elements_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetScatterElementsIndicesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScatterElementsIndices(UserType* output) {
    
    auto* pointer = data_->scatter_elements_indices.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetScatterNdInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScatterNdInput(UserType* output) {
    
    auto* pointer = data_->scatter_nd_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetScatterNdIndicesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScatterNdIndices(UserType* output) {
    
    auto* pointer = data_->scatter_nd_indices.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetScatterNdUpdatesDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScatterNdUpdates(UserType* output) {
    
    auto* pointer = data_->scatter_nd_updates.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSigmoidInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSigmoidInput(UserType* output) {
    
    auto* pointer = data_->sigmoid_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSliceInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSliceInput(UserType* output) {
    
    auto* pointer = data_->slice_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSoftmaxInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftmaxInput(UserType* output) {
    
    auto* pointer = data_->softmax_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSoftplusInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftplusInput(UserType* output) {
    
    auto* pointer = data_->softplus_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSoftsignInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSoftsignInput(UserType* output) {
    
    auto* pointer = data_->softsign_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetSplitInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSplitInput(UserType* output) {
    
    auto* pointer = data_->split_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetTanhInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTanhInput(UserType* output) {
    
    auto* pointer = data_->tanh_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetTileInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTileInput(UserType* output) {
    
    auto* pointer = data_->tile_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetTransposeInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransposeInput(UserType* output) {
    
    auto* pointer = data_->transpose_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetTriangularInputDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTriangularInput(UserType* output) {
    
    auto* pointer = data_->triangular_input.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetWhereConditionDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWhereCondition(UserType* output) {
    
    auto* pointer = data_->where_condition.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
  inline void GetWhereValueDataView(
      SupportedTensorsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWhereValue(UserType* output) {
    
    auto* pointer = data_->where_value.Get();
    return mojo::internal::Deserialize<::webnn::mojom::SupportedTensorsDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataTypeLimits_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContextPropertiesDataView {
 public:
  ContextPropertiesDataView() = default;

  ContextPropertiesDataView(
      internal::ContextProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadInputOperandLayout(UserType* output) const {
    auto data_value = data_->input_operand_layout;
    return mojo::internal::Deserialize<::webnn::mojom::InputOperandLayout>(
        data_value, output);
  }
  InputOperandLayout input_operand_layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::InputOperandLayout>(data_->input_operand_layout));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResample2dAxes(UserType* output) const {
    auto data_value = data_->resample_2d_axes;
    return mojo::internal::Deserialize<::webnn::mojom::Resample2DAxes>(
        data_value, output);
  }
  Resample2DAxes resample_2d_axes() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::Resample2DAxes>(data_->resample_2d_axes));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBatchNormalizationAxis(UserType* output) const {
    auto data_value = data_->batch_normalization_axis;
    return mojo::internal::Deserialize<::webnn::mojom::BatchNormalizationAxis>(
        data_value, output);
  }
  BatchNormalizationAxis batch_normalization_axis() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::webnn::mojom::BatchNormalizationAxis>(data_->batch_normalization_axis));
  }
  uint64_t tensor_byte_length_limit() const {
    return data_->tensor_byte_length_limit;
  }
  inline void GetDataTypeLimitsDataView(
      DataTypeLimitsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataTypeLimits(UserType* output) {
    
    auto* pointer = data_->data_type_limits.Get();
    return mojo::internal::Deserialize<::webnn::mojom::DataTypeLimitsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContextProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_PROPERTIES_MOJOM_DATA_VIEW_H_