// services/webnn/public/mojom/webnn_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SHARED_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_context.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/webnn/public/mojom/webnn_context.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateTensorSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::webnn::mojom::CreateTensorSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::webnn::mojom::internal::CreateTensorSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tensor_remote(input)) in_tensor_remote = Traits::tensor_remote(input);

    
    mojo::internal::Serialize<::webnn::mojom::WebNNTensorAssociatedPtrInfoDataView>(
      in_tensor_remote,
      &fragment->tensor_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->tensor_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid tensor_remote in CreateTensorSuccess struct");

    decltype(Traits::tensor_handle(input)) in_tensor_handle = Traits::tensor_handle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tensor_handle)::BaseType> tensor_handle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::WebNNTensorTokenDataView>(
      in_tensor_handle,
      tensor_handle_fragment);

    fragment->tensor_handle.Set(
        tensor_handle_fragment.is_null() ? nullptr : tensor_handle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tensor_handle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tensor_handle in CreateTensorSuccess struct");
  }

  static bool Deserialize(::webnn::mojom::internal::CreateTensorSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateTensorSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::webnn::mojom::CreateTensorResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::webnn::mojom::CreateTensorResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::webnn::mojom::internal::CreateTensorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::webnn::mojom::CreateTensorResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::CreateTensorSuccessDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in CreateTensorResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::webnn::mojom::CreateTensorResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::webnn::mojom::ErrorDataView>(
  in_error,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error in CreateTensorResult union");
    fragment->data.f_error.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::webnn::mojom::internal::CreateTensorResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::webnn::mojom::CreateTensorResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace webnn::mojom {

inline void CreateTensorSuccessDataView::GetTensorHandleDataView(
    ::blink::mojom::WebNNTensorTokenDataView* output) {
  auto pointer = data_->tensor_handle.Get();
  *output = ::blink::mojom::WebNNTensorTokenDataView(pointer, message_);
}


inline void CreateTensorResultDataView::GetSuccessDataView(
    CreateTensorSuccessDataView* output) const {
  CHECK(is_success());
  *output = CreateTensorSuccessDataView(data_->data.f_success.Get(), message_);
}
inline void CreateTensorResultDataView::GetErrorDataView(
    ::webnn::mojom::ErrorDataView* output) const {
  CHECK(is_error());
  *output = ::webnn::mojom::ErrorDataView(data_->data.f_error.Get(), message_);
}


}  // webnn::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_SHARED_H_