// services/webnn/public/mojom/webnn_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context.mojom-params-data.h"
namespace webnn {
namespace mojom {

namespace internal {
// static
bool CreateTensorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreateTensorResult_Data* object = static_cast<const CreateTensorResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreateTensorResult_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case CreateTensorResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreateTensorResult");
      return false;
    }
  }
}


// static
bool CreateTensorSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateTensorSuccess_Data* object =
      static_cast<const CreateTensorSuccess_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->tensor_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->tensor_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tensor_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tensor_handle, validation_context))
    return false;

  return true;
}

CreateTensorSuccess_Data::CreateTensorSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContext_CreateGraphBuilder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContext_CreateGraphBuilder_Params_Data* object =
      static_cast<const WebNNContext_CreateGraphBuilder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebNNContext_CreateGraphBuilder_Params_Data::WebNNContext_CreateGraphBuilder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContext_CreateTensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContext_CreateTensor_Params_Data* object =
      static_cast<const WebNNContext_CreateTensor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tensor_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tensor_info, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tensor_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tensor_data, validation_context))
    return false;

  return true;
}

WebNNContext_CreateTensor_Params_Data::WebNNContext_CreateTensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContext_CreateTensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContext_CreateTensor_ResponseParams_Data* object =
      static_cast<const WebNNContext_CreateTensor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNContext_CreateTensor_ResponseParams_Data::WebNNContext_CreateTensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContext_CreateTensorFromMailbox_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContext_CreateTensorFromMailbox_Params_Data* object =
      static_cast<const WebNNContext_CreateTensorFromMailbox_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tensor_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tensor_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fence, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fence, validation_context))
    return false;

  return true;
}

WebNNContext_CreateTensorFromMailbox_Params_Data::WebNNContext_CreateTensorFromMailbox_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNContext_CreateTensorFromMailbox_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNContext_CreateTensorFromMailbox_ResponseParams_Data* object =
      static_cast<const WebNNContext_CreateTensorFromMailbox_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNContext_CreateTensorFromMailbox_ResponseParams_Data::WebNNContext_CreateTensorFromMailbox_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn