// services/webnn/public/mojom/webnn_context.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_DATA_VIEW_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/webnn/public/mojom/webnn_context.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/webnn/public/mojom/features.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_error.mojom-shared.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace webnn::mojom {
class CreateTensorSuccessDataView;

class CreateTensorResultDataView;


}  // webnn::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::webnn::mojom::CreateTensorSuccessDataView> {
  using Data = ::webnn::mojom::internal::CreateTensorSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::webnn::mojom::CreateTensorResultDataView> {
  using Data = ::webnn::mojom::internal::CreateTensorResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace webnn::mojom {
// Interface base classes. They are used for type safety check.
class WebNNContextInterfaceBase {};

using WebNNContextPtrDataView =
    mojo::InterfacePtrDataView<WebNNContextInterfaceBase>;
using WebNNContextRequestDataView =
    mojo::InterfaceRequestDataView<WebNNContextInterfaceBase>;
using WebNNContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebNNContextInterfaceBase>;
using WebNNContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebNNContextInterfaceBase>;


class CreateTensorSuccessDataView {
 public:
  CreateTensorSuccessDataView() = default;

  CreateTensorSuccessDataView(
      internal::CreateTensorSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeTensorRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::webnn::mojom::WebNNTensorAssociatedPtrInfoDataView>(
            &data_->tensor_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetTensorHandleDataView(
      ::blink::mojom::WebNNTensorTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTensorHandle(UserType* output) {
    
    auto* pointer = data_->tensor_handle.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebNNTensorTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateTensorSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateTensorResultDataView {
 public:
  using Tag = internal::CreateTensorResult_Data::CreateTensorResult_Tag;

  CreateTensorResultDataView() = default;

  CreateTensorResultDataView(
      internal::CreateTensorResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      CreateTensorSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::webnn::mojom::CreateTensorSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      ::webnn::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::webnn::mojom::ErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::CreateTensorResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // webnn::mojom

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_DATA_VIEW_H_