// services/viz/public/mojom/hit_test/input_target_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  FrameSinkId as viz_mojom_FrameSinkId,
  FrameSinkIdSpec as viz_mojom_FrameSinkIdSpec
} from '../compositing/frame_sink_id.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputTargetClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.InputTargetClient', scope);
  }
}

/** @interface */
export class InputTargetClientInterface {
  
  /**
   * @param { !gfx_mojom_PointF } point
   * @param { !bigint } traceId
   * @return {!Promise<{
        id: !viz_mojom_FrameSinkId,
        localPoint: !gfx_mojom_PointF,
   *  }>}
   */

  frameSinkIdAt(point, traceId) {}
}

/**
 * @implements { InputTargetClientInterface }
 */
export class InputTargetClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputTargetClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputTargetClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputTargetClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx_mojom_PointF } point
   * @param { !bigint } traceId
   * @return {!Promise<{
        id: !viz_mojom_FrameSinkId,
        localPoint: !gfx_mojom_PointF,
   *  }>}
   */

  frameSinkIdAt(
      point,
      traceId) {
    return this.proxy.sendMessage(
        0,
        InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        [
          point,
          traceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputTargetClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputTargetClientReceiver {
  /**
   * @param {!InputTargetClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputTargetClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputTargetClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputTargetClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        impl.frameSinkIdAt.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputTargetClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.InputTargetClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputTargetClientRemote}
   */
  static getRemote() {
    let remote = new InputTargetClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputTargetClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputTargetClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputTargetClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputTargetClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.frameSinkIdAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
        InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
        this.frameSinkIdAt.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputTargetClient_FrameSinkIdAt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputTargetClient_FrameSinkIdAt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InputTargetClient_FrameSinkIdAt_ParamsSpec.$,
    'InputTargetClient_FrameSinkIdAt_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'traceId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputTargetClient_FrameSinkIdAt_Params {
  constructor() {
    /** @type { !gfx_mojom_PointF } */
    this.point;
    /** @type { !bigint } */
    this.traceId;
  }
}



mojo.internal.Struct(
    InputTargetClient_FrameSinkIdAt_ResponseParamsSpec.$,
    'InputTargetClient_FrameSinkIdAt_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        viz_mojom_FrameSinkIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localPoint', 8,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputTargetClient_FrameSinkIdAt_ResponseParams {
  constructor() {
    /** @type { !viz_mojom_FrameSinkId } */
    this.id;
    /** @type { !gfx_mojom_PointF } */
    this.localPoint;
  }
}

