// services/viz/public/mojom/hit_test/input_target_client.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/hit_test/input_target_client.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/input_target_client.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {

class InputTargetClientProxy;

template <typename ImplRefTraits>
class InputTargetClientStub;

class InputTargetClientRequestValidator;
class InputTargetClientResponseValidator;


class BLINK_PLATFORM_EXPORT InputTargetClient
    : public InputTargetClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.InputTargetClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = InputTargetClientInterfaceBase;
  using Proxy_ = InputTargetClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = InputTargetClientStub<ImplRefTraits>;

  using RequestValidator_ = InputTargetClientRequestValidator;
  using ResponseValidator_ = InputTargetClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFrameSinkIdAtMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FrameSinkIdAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~InputTargetClient() = default;

  using FrameSinkIdAtCallback = base::OnceCallback<void(const ::viz::FrameSinkId&, const ::gfx::PointF&)>;
  using FrameSinkIdAtMojoCallback = base::OnceCallback<void(const ::viz::FrameSinkId&, const ::gfx::PointF&)>;

  virtual void FrameSinkIdAt(const ::gfx::PointF& point, uint64_t trace_id, FrameSinkIdAtCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT InputTargetClientProxy
    : public InputTargetClient {
 public:
  using InterfaceType = InputTargetClient;

  explicit InputTargetClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FrameSinkIdAt(const ::gfx::PointF& point, uint64_t trace_id, FrameSinkIdAtCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT InputTargetClientStubDispatch {
 public:
  static bool Accept(InputTargetClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      InputTargetClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<InputTargetClient>>
class InputTargetClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  InputTargetClientStub() = default;
  ~InputTargetClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputTargetClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return InputTargetClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT InputTargetClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT InputTargetClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_INPUT_TARGET_CLIENT_MOJOM_BLINK_H_