// services/viz/public/mojom/hit_test/hit_test_region_list.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/hit_test/hit_test_region_list_mojom_traits.h"




namespace viz::mojom {









class  HitTestRegion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HitTestRegion, T>::value>;
  using DataView = HitTestRegionDataView;
  using Data_ = internal::HitTestRegion_Data;

  template <typename... Args>
  static HitTestRegionPtr New(Args&&... args) {
    return HitTestRegionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HitTestRegionPtr From(const U& u) {
    return mojo::TypeConverter<HitTestRegionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HitTestRegion>::Convert(*this);
  }


  HitTestRegion();

  HitTestRegion(
      uint32_t flags,
      uint32_t async_hit_test_reasons,
      const ::viz::FrameSinkId& frame_sink_id,
      const ::gfx::Rect& rect,
      const ::gfx::Transform& transform);


  ~HitTestRegion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HitTestRegionPtr>
  HitTestRegionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestRegion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestRegion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HitTestRegion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HitTestRegion_UnserializedMessageContext<
            UserType, HitTestRegion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HitTestRegion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HitTestRegion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HitTestRegion_UnserializedMessageContext<
            UserType, HitTestRegion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HitTestRegion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t flags;
  
  uint32_t async_hit_test_reasons;
  
  ::viz::FrameSinkId frame_sink_id;
  
  ::gfx::Rect rect;
  
  ::gfx::Transform transform;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HitTestRegion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HitTestRegionList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HitTestRegionList, T>::value>;
  using DataView = HitTestRegionListDataView;
  using Data_ = internal::HitTestRegionList_Data;

  template <typename... Args>
  static HitTestRegionListPtr New(Args&&... args) {
    return HitTestRegionListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HitTestRegionListPtr From(const U& u) {
    return mojo::TypeConverter<HitTestRegionListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HitTestRegionList>::Convert(*this);
  }


  HitTestRegionList();

  HitTestRegionList(
      uint32_t flags,
      uint32_t async_hit_test_reasons,
      const ::gfx::Rect& bounds,
      const ::gfx::Transform& transform,
      std::vector<::viz::HitTestRegion> regions);


  ~HitTestRegionList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HitTestRegionListPtr>
  HitTestRegionListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestRegionList::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestRegionList::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HitTestRegionList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HitTestRegionList_UnserializedMessageContext<
            UserType, HitTestRegionList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HitTestRegionList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HitTestRegionList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HitTestRegionList_UnserializedMessageContext<
            UserType, HitTestRegionList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HitTestRegionList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t flags;
  
  uint32_t async_hit_test_reasons;
  
  ::gfx::Rect bounds;
  
  ::gfx::Transform transform;
  
  std::vector<::viz::HitTestRegion> regions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HitTestRegionList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HitTestRegionPtr HitTestRegion::Clone() const {
  return New(
      mojo::Clone(flags),
      mojo::Clone(async_hit_test_reasons),
      mojo::Clone(frame_sink_id),
      mojo::Clone(rect),
      mojo::Clone(transform)
  );
}

template <typename T, HitTestRegion::EnableIfSame<T>*>
bool HitTestRegion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->async_hit_test_reasons, other_struct.async_hit_test_reasons))
    return false;
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  return true;
}

template <typename T, HitTestRegion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.async_hit_test_reasons < rhs.async_hit_test_reasons)
    return true;
  if (rhs.async_hit_test_reasons < lhs.async_hit_test_reasons)
    return false;
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.rect < rhs.rect)
    return true;
  if (rhs.rect < lhs.rect)
    return false;
  if (lhs.transform < rhs.transform)
    return true;
  if (rhs.transform < lhs.transform)
    return false;
  return false;
}
template <typename StructPtrType>
HitTestRegionListPtr HitTestRegionList::Clone() const {
  return New(
      mojo::Clone(flags),
      mojo::Clone(async_hit_test_reasons),
      mojo::Clone(bounds),
      mojo::Clone(transform),
      mojo::Clone(regions)
  );
}

template <typename T, HitTestRegionList::EnableIfSame<T>*>
bool HitTestRegionList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->async_hit_test_reasons, other_struct.async_hit_test_reasons))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  if (!mojo::Equals(this->regions, other_struct.regions))
    return false;
  return true;
}

template <typename T, HitTestRegionList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.async_hit_test_reasons < rhs.async_hit_test_reasons)
    return true;
  if (rhs.async_hit_test_reasons < lhs.async_hit_test_reasons)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.transform < rhs.transform)
    return true;
  if (rhs.transform < lhs.transform)
    return false;
  if (lhs.regions < rhs.regions)
    return true;
  if (rhs.regions < lhs.regions)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::HitTestRegion::DataView,
                                         ::viz::mojom::HitTestRegionPtr> {
  static bool IsNull(const ::viz::mojom::HitTestRegionPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::HitTestRegionPtr* output) { output->reset(); }

  static decltype(::viz::mojom::HitTestRegion::flags) flags(
      const ::viz::mojom::HitTestRegionPtr& input) {
    return input->flags;
  }

  static decltype(::viz::mojom::HitTestRegion::async_hit_test_reasons) async_hit_test_reasons(
      const ::viz::mojom::HitTestRegionPtr& input) {
    return input->async_hit_test_reasons;
  }

  static const decltype(::viz::mojom::HitTestRegion::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::HitTestRegionPtr& input) {
    return input->frame_sink_id;
  }

  static const decltype(::viz::mojom::HitTestRegion::rect)& rect(
      const ::viz::mojom::HitTestRegionPtr& input) {
    return input->rect;
  }

  static const decltype(::viz::mojom::HitTestRegion::transform)& transform(
      const ::viz::mojom::HitTestRegionPtr& input) {
    return input->transform;
  }

  static bool Read(::viz::mojom::HitTestRegion::DataView input, ::viz::mojom::HitTestRegionPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::HitTestRegionList::DataView,
                                         ::viz::mojom::HitTestRegionListPtr> {
  static bool IsNull(const ::viz::mojom::HitTestRegionListPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::HitTestRegionListPtr* output) { output->reset(); }

  static decltype(::viz::mojom::HitTestRegionList::flags) flags(
      const ::viz::mojom::HitTestRegionListPtr& input) {
    return input->flags;
  }

  static decltype(::viz::mojom::HitTestRegionList::async_hit_test_reasons) async_hit_test_reasons(
      const ::viz::mojom::HitTestRegionListPtr& input) {
    return input->async_hit_test_reasons;
  }

  static const decltype(::viz::mojom::HitTestRegionList::bounds)& bounds(
      const ::viz::mojom::HitTestRegionListPtr& input) {
    return input->bounds;
  }

  static const decltype(::viz::mojom::HitTestRegionList::transform)& transform(
      const ::viz::mojom::HitTestRegionListPtr& input) {
    return input->transform;
  }

  static const decltype(::viz::mojom::HitTestRegionList::regions)& regions(
      const ::viz::mojom::HitTestRegionListPtr& input) {
    return input->regions;
  }

  static bool Read(::viz::mojom::HitTestRegionList::DataView input, ::viz::mojom::HitTestRegionListPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_H_