// services/viz/public/mojom/hit_test/hit_test_region_list.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace viz::mojom {
class HitTestRegionDataView;

class HitTestRegionListDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::HitTestRegionDataView> {
  using Data = ::viz::mojom::internal::HitTestRegion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::HitTestRegionListDataView> {
  using Data = ::viz::mojom::internal::HitTestRegionList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class HitTestRegionDataView {
 public:
  HitTestRegionDataView() = default;

  HitTestRegionDataView(
      internal::HitTestRegion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t flags() const {
    return data_->flags;
  }
  uint32_t async_hit_test_reasons() const {
    return data_->async_hit_test_reasons;
  }
  inline void GetFrameSinkIdDataView(
      ::viz::mojom::FrameSinkIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameSinkId(UserType* output) {
    
    auto* pointer = data_->frame_sink_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::FrameSinkIdDataView>(
        pointer, output, message_);
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
 private:
  internal::HitTestRegion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HitTestRegionListDataView {
 public:
  HitTestRegionListDataView() = default;

  HitTestRegionListDataView(
      internal::HitTestRegionList_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t flags() const {
    return data_->flags;
  }
  uint32_t async_hit_test_reasons() const {
    return data_->async_hit_test_reasons;
  }
  inline void GetBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounds(UserType* output) {
    
    auto* pointer = data_->bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetRegionsDataView(
      mojo::ArrayDataView<HitTestRegionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegions(UserType* output) {
    
    auto* pointer = data_->regions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::HitTestRegionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HitTestRegionList_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_HIT_TEST_HIT_TEST_REGION_LIST_MOJOM_DATA_VIEW_H_