// services/viz/public/mojom/compositing/view_transition_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/view_transition_request.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace viz::mojom {
class ViewTransitionRequestDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::ViewTransitionRequestDataView> {
  using Data = ::viz::mojom::internal::ViewTransitionRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class ViewTransitionRequestDataView {
 public:
  ViewTransitionRequestDataView() = default;

  ViewTransitionRequestDataView(
      internal::ViewTransitionRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        data_value, output);
  }
  ::viz::mojom::CompositorFrameTransitionDirectiveType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CompositorFrameTransitionDirectiveType>(data_->type));
  }
  inline void GetTransitionTokenDataView(
      ::blink::mojom::ViewTransitionTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransitionToken(UserType* output) {
    
    auto* pointer = data_->transition_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionTokenDataView>(
        pointer, output, message_);
  }
  bool maybe_cross_frame_sink() const {
    return data_->maybe_cross_frame_sink;
  }
  uint32_t sequence_id() const {
    return data_->sequence_id;
  }
  inline void GetCaptureResourceIdsDataView(
      mojo::ArrayDataView<::viz::mojom::ViewTransitionElementResourceIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCaptureResourceIds(UserType* output) {
    
    auto* pointer = data_->capture_resource_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ViewTransitionElementResourceIdDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ViewTransitionRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_DATA_VIEW_H_