// services/viz/public/mojom/compositing/view_transition_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/view_transition_request.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/view_transition_request.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/view_transition_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT ViewTransitionRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionRequest, T>::value>;
  using DataView = ViewTransitionRequestDataView;
  using Data_ = internal::ViewTransitionRequest_Data;

  template <typename... Args>
  static ViewTransitionRequestPtr New(Args&&... args) {
    return ViewTransitionRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionRequestPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionRequest>::Convert(*this);
  }


  ViewTransitionRequest();

  ViewTransitionRequest(
      ::viz::mojom::blink::CompositorFrameTransitionDirectiveType type,
      const ::blink::ViewTransitionToken& transition_token,
      bool maybe_cross_frame_sink,
      uint32_t sequence_id,
      ::blink::Vector<::viz::mojom::blink::ViewTransitionElementResourceIdPtr> capture_resource_ids);

ViewTransitionRequest(const ViewTransitionRequest&) = delete;
ViewTransitionRequest& operator=(const ViewTransitionRequest&) = delete;

  ~ViewTransitionRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionRequestPtr>
  ViewTransitionRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionRequest_UnserializedMessageContext<
            UserType, ViewTransitionRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionRequest_UnserializedMessageContext<
            UserType, ViewTransitionRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::mojom::blink::CompositorFrameTransitionDirectiveType type;
  
  ::blink::ViewTransitionToken transition_token;
  
  bool maybe_cross_frame_sink;
  
  uint32_t sequence_id;
  
  ::blink::Vector<::viz::mojom::blink::ViewTransitionElementResourceIdPtr> capture_resource_ids;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ViewTransitionRequestPtr ViewTransitionRequest::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(transition_token),
      mojo::Clone(maybe_cross_frame_sink),
      mojo::Clone(sequence_id),
      mojo::Clone(capture_resource_ids)
  );
}

template <typename T, ViewTransitionRequest::EnableIfSame<T>*>
bool ViewTransitionRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->transition_token, other_struct.transition_token))
    return false;
  if (!mojo::Equals(this->maybe_cross_frame_sink, other_struct.maybe_cross_frame_sink))
    return false;
  if (!mojo::Equals(this->sequence_id, other_struct.sequence_id))
    return false;
  if (!mojo::Equals(this->capture_resource_ids, other_struct.capture_resource_ids))
    return false;
  return true;
}

template <typename T, ViewTransitionRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.transition_token < rhs.transition_token)
    return true;
  if (rhs.transition_token < lhs.transition_token)
    return false;
  if (lhs.maybe_cross_frame_sink < rhs.maybe_cross_frame_sink)
    return true;
  if (rhs.maybe_cross_frame_sink < lhs.maybe_cross_frame_sink)
    return false;
  if (lhs.sequence_id < rhs.sequence_id)
    return true;
  if (rhs.sequence_id < lhs.sequence_id)
    return false;
  if (lhs.capture_resource_ids < rhs.capture_resource_ids)
    return true;
  if (rhs.capture_resource_ids < lhs.capture_resource_ids)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ViewTransitionRequest::DataView,
                                         ::viz::mojom::blink::ViewTransitionRequestPtr> {
  static bool IsNull(const ::viz::mojom::blink::ViewTransitionRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ViewTransitionRequestPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ViewTransitionRequest::type) type(
      const ::viz::mojom::blink::ViewTransitionRequestPtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::blink::ViewTransitionRequest::transition_token)& transition_token(
      const ::viz::mojom::blink::ViewTransitionRequestPtr& input) {
    return input->transition_token;
  }

  static decltype(::viz::mojom::blink::ViewTransitionRequest::maybe_cross_frame_sink) maybe_cross_frame_sink(
      const ::viz::mojom::blink::ViewTransitionRequestPtr& input) {
    return input->maybe_cross_frame_sink;
  }

  static decltype(::viz::mojom::blink::ViewTransitionRequest::sequence_id) sequence_id(
      const ::viz::mojom::blink::ViewTransitionRequestPtr& input) {
    return input->sequence_id;
  }

  static const decltype(::viz::mojom::blink::ViewTransitionRequest::capture_resource_ids)& capture_resource_ids(
      const ::viz::mojom::blink::ViewTransitionRequestPtr& input) {
    return input->capture_resource_ids;
  }

  static bool Read(::viz::mojom::blink::ViewTransitionRequest::DataView input, ::viz::mojom::blink::ViewTransitionRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_REQUEST_MOJOM_BLINK_H_