// services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_ELEMENT_RESOURCE_ID_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_ELEMENT_RESOURCE_ID_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT ViewTransitionElementResourceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionElementResourceId, T>::value>;
  using DataView = ViewTransitionElementResourceIdDataView;
  using Data_ = internal::ViewTransitionElementResourceId_Data;

  template <typename... Args>
  static ViewTransitionElementResourceIdPtr New(Args&&... args) {
    return ViewTransitionElementResourceIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionElementResourceIdPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionElementResourceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionElementResourceId>::Convert(*this);
  }


  ViewTransitionElementResourceId();

  ViewTransitionElementResourceId(
      const std::optional<::blink::ViewTransitionToken>& transition_token,
      uint32_t local_id,
      bool for_scope_snapshot);


  ~ViewTransitionElementResourceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionElementResourceIdPtr>
  ViewTransitionElementResourceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElementResourceId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElementResourceId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionElementResourceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionElementResourceId_UnserializedMessageContext<
            UserType, ViewTransitionElementResourceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionElementResourceId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionElementResourceId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionElementResourceId_UnserializedMessageContext<
            UserType, ViewTransitionElementResourceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionElementResourceId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::ViewTransitionToken> transition_token;
  
  uint32_t local_id;
  
  bool for_scope_snapshot;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ViewTransitionElementResourceIdPtr ViewTransitionElementResourceId::Clone() const {
  return New(
      mojo::Clone(transition_token),
      mojo::Clone(local_id),
      mojo::Clone(for_scope_snapshot)
  );
}

template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>*>
bool ViewTransitionElementResourceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transition_token, other_struct.transition_token))
    return false;
  if (!mojo::Equals(this->local_id, other_struct.local_id))
    return false;
  if (!mojo::Equals(this->for_scope_snapshot, other_struct.for_scope_snapshot))
    return false;
  return true;
}

template <typename T, ViewTransitionElementResourceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transition_token < rhs.transition_token)
    return true;
  if (rhs.transition_token < lhs.transition_token)
    return false;
  if (lhs.local_id < rhs.local_id)
    return true;
  if (rhs.local_id < lhs.local_id)
    return false;
  if (lhs.for_scope_snapshot < rhs.for_scope_snapshot)
    return true;
  if (rhs.for_scope_snapshot < lhs.for_scope_snapshot)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ViewTransitionElementResourceId::DataView,
                                         ::viz::mojom::blink::ViewTransitionElementResourceIdPtr> {
  static bool IsNull(const ::viz::mojom::blink::ViewTransitionElementResourceIdPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ViewTransitionElementResourceIdPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::ViewTransitionElementResourceId::transition_token)& transition_token(
      const ::viz::mojom::blink::ViewTransitionElementResourceIdPtr& input) {
    return input->transition_token;
  }

  static decltype(::viz::mojom::blink::ViewTransitionElementResourceId::local_id) local_id(
      const ::viz::mojom::blink::ViewTransitionElementResourceIdPtr& input) {
    return input->local_id;
  }

  static decltype(::viz::mojom::blink::ViewTransitionElementResourceId::for_scope_snapshot) for_scope_snapshot(
      const ::viz::mojom::blink::ViewTransitionElementResourceIdPtr& input) {
    return input->for_scope_snapshot;
  }

  static bool Read(::viz::mojom::blink::ViewTransitionElementResourceId::DataView input, ::viz::mojom::blink::ViewTransitionElementResourceIdPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_VIEW_TRANSITION_ELEMENT_RESOURCE_ID_MOJOM_BLINK_H_