// services/viz/public/mojom/compositing/transferable_resource.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-forward.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/hdr_metadata.mojom.h"
#include "skia/public/mojom/image_info.mojom.h"
#include "skia/public/mojom/surface_origin.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/transferable_resource_mojom_traits.h"




namespace viz::mojom {








class  TransferableResource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferableResource, T>::value>;
  using DataView = TransferableResourceDataView;
  using Data_ = internal::TransferableResource_Data;

  template <typename... Args>
  static TransferableResourcePtr New(Args&&... args) {
    return TransferableResourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferableResourcePtr From(const U& u) {
    return mojo::TypeConverter<TransferableResourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableResource>::Convert(*this);
  }


  TransferableResource();

  TransferableResource(
      const ::viz::ResourceId& id,
      const ::viz::SharedImageFormat& format,
      const ::gfx::Size& size,
      const ::gpu::Mailbox& memory_buffer_id,
      const ::gpu::SyncToken& sync_token,
      uint32_t texture_target,
      SynchronizationType synchronization_type,
      bool is_software,
      bool is_overlay_candidate,
      bool is_low_latency_rendering,
      const ::gfx::ColorSpace& color_space,
      const ::gfx::HDRMetadata& hdr_metadata,
      bool needs_detiling,
      ::GrSurfaceOrigin origin,
      ::SkAlphaType alpha_type,
      ResourceSource resource_source);


  ~TransferableResource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferableResourcePtr>
  TransferableResourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransferableResource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransferableResource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableResource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferableResource_UnserializedMessageContext<
            UserType, TransferableResource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransferableResource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransferableResource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferableResource_UnserializedMessageContext<
            UserType, TransferableResource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferableResource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::ResourceId id;
  
  ::viz::SharedImageFormat format;
  
  ::gfx::Size size;
  
  ::gpu::Mailbox memory_buffer_id;
  
  ::gpu::SyncToken sync_token;
  
  uint32_t texture_target;
  
  SynchronizationType synchronization_type;
  
  bool is_software;
  
  bool is_overlay_candidate;
  
  bool is_low_latency_rendering;
  
  ::gfx::ColorSpace color_space;
  
  ::gfx::HDRMetadata hdr_metadata;
  
  bool needs_detiling;
  
  ::GrSurfaceOrigin origin;
  
  ::SkAlphaType alpha_type;
  
  ResourceSource resource_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferableResource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferableResourcePtr TransferableResource::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(format),
      mojo::Clone(size),
      mojo::Clone(memory_buffer_id),
      mojo::Clone(sync_token),
      mojo::Clone(texture_target),
      mojo::Clone(synchronization_type),
      mojo::Clone(is_software),
      mojo::Clone(is_overlay_candidate),
      mojo::Clone(is_low_latency_rendering),
      mojo::Clone(color_space),
      mojo::Clone(hdr_metadata),
      mojo::Clone(needs_detiling),
      mojo::Clone(origin),
      mojo::Clone(alpha_type),
      mojo::Clone(resource_source)
  );
}

template <typename T, TransferableResource::EnableIfSame<T>*>
bool TransferableResource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->memory_buffer_id, other_struct.memory_buffer_id))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->texture_target, other_struct.texture_target))
    return false;
  if (!mojo::Equals(this->synchronization_type, other_struct.synchronization_type))
    return false;
  if (!mojo::Equals(this->is_software, other_struct.is_software))
    return false;
  if (!mojo::Equals(this->is_overlay_candidate, other_struct.is_overlay_candidate))
    return false;
  if (!mojo::Equals(this->is_low_latency_rendering, other_struct.is_low_latency_rendering))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  if (!mojo::Equals(this->needs_detiling, other_struct.needs_detiling))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->resource_source, other_struct.resource_source))
    return false;
  return true;
}

template <typename T, TransferableResource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.memory_buffer_id < rhs.memory_buffer_id)
    return true;
  if (rhs.memory_buffer_id < lhs.memory_buffer_id)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.texture_target < rhs.texture_target)
    return true;
  if (rhs.texture_target < lhs.texture_target)
    return false;
  if (lhs.synchronization_type < rhs.synchronization_type)
    return true;
  if (rhs.synchronization_type < lhs.synchronization_type)
    return false;
  if (lhs.is_software < rhs.is_software)
    return true;
  if (rhs.is_software < lhs.is_software)
    return false;
  if (lhs.is_overlay_candidate < rhs.is_overlay_candidate)
    return true;
  if (rhs.is_overlay_candidate < lhs.is_overlay_candidate)
    return false;
  if (lhs.is_low_latency_rendering < rhs.is_low_latency_rendering)
    return true;
  if (rhs.is_low_latency_rendering < lhs.is_low_latency_rendering)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  if (lhs.needs_detiling < rhs.needs_detiling)
    return true;
  if (rhs.needs_detiling < lhs.needs_detiling)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.alpha_type < rhs.alpha_type)
    return true;
  if (rhs.alpha_type < lhs.alpha_type)
    return false;
  if (lhs.resource_source < rhs.resource_source)
    return true;
  if (rhs.resource_source < lhs.resource_source)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::TransferableResource::DataView,
                                         ::viz::mojom::TransferableResourcePtr> {
  static bool IsNull(const ::viz::mojom::TransferableResourcePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::TransferableResourcePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::TransferableResource::id)& id(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->id;
  }

  static const decltype(::viz::mojom::TransferableResource::format)& format(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->format;
  }

  static const decltype(::viz::mojom::TransferableResource::size)& size(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->size;
  }

  static const decltype(::viz::mojom::TransferableResource::memory_buffer_id)& memory_buffer_id(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->memory_buffer_id;
  }

  static const decltype(::viz::mojom::TransferableResource::sync_token)& sync_token(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->sync_token;
  }

  static decltype(::viz::mojom::TransferableResource::texture_target) texture_target(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->texture_target;
  }

  static decltype(::viz::mojom::TransferableResource::synchronization_type) synchronization_type(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->synchronization_type;
  }

  static decltype(::viz::mojom::TransferableResource::is_software) is_software(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->is_software;
  }

  static decltype(::viz::mojom::TransferableResource::is_overlay_candidate) is_overlay_candidate(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->is_overlay_candidate;
  }

  static decltype(::viz::mojom::TransferableResource::is_low_latency_rendering) is_low_latency_rendering(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->is_low_latency_rendering;
  }

  static const decltype(::viz::mojom::TransferableResource::color_space)& color_space(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->color_space;
  }

  static const decltype(::viz::mojom::TransferableResource::hdr_metadata)& hdr_metadata(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->hdr_metadata;
  }

  static decltype(::viz::mojom::TransferableResource::needs_detiling) needs_detiling(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->needs_detiling;
  }

  static decltype(::viz::mojom::TransferableResource::origin) origin(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->origin;
  }

  static decltype(::viz::mojom::TransferableResource::alpha_type) alpha_type(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->alpha_type;
  }

  static decltype(::viz::mojom::TransferableResource::resource_source) resource_source(
      const ::viz::mojom::TransferableResourcePtr& input) {
    return input->resource_source;
  }

  static bool Read(::viz::mojom::TransferableResource::DataView input, ::viz::mojom::TransferableResourcePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_H_