// services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "skia/public/mojom/surface_origin.mojom-shared.h"




#include "services/viz/public/mojom/compositing/transferable_resource.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::SynchronizationType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::SynchronizationType> {};

template <>
struct hash<::viz::mojom::ResourceSource>
    : public mojo::internal::EnumHashImpl<::viz::mojom::ResourceSource> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SynchronizationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::SynchronizationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::SynchronizationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ResourceSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::ResourceSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::ResourceSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TransferableResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransferableResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransferableResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ResourceIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TransferableResource struct");

    decltype(Traits::format(input)) in_format = Traits::format(input);
    mojo::internal::MessageFragment<decltype(fragment->format)>
        format_fragment(fragment.message());
    format_fragment.Claim(&fragment->format);
    
    mojo::internal::Serialize<::viz::mojom::SharedImageFormatDataView>(
      in_format,
      format_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->format.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null format in TransferableResource struct");

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in TransferableResource struct");

    decltype(Traits::memory_buffer_id(input)) in_memory_buffer_id = Traits::memory_buffer_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory_buffer_id)::BaseType> memory_buffer_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_memory_buffer_id,
      memory_buffer_id_fragment);

    fragment->memory_buffer_id.Set(
        memory_buffer_id_fragment.is_null() ? nullptr : memory_buffer_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->memory_buffer_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory_buffer_id in TransferableResource struct");

    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token,
      sync_token_fragment);

    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in TransferableResource struct");

    fragment->texture_target = Traits::texture_target(input);

    
    mojo::internal::Serialize<::viz::mojom::SynchronizationType>(
      Traits::synchronization_type(input),
      &fragment->synchronization_type);

    fragment->is_software = Traits::is_software(input);

    fragment->is_overlay_candidate = Traits::is_overlay_candidate(input);

    fragment->is_low_latency_rendering = Traits::is_low_latency_rendering(input);

    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
      in_color_space,
      color_space_fragment);

    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_space.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_space in TransferableResource struct");

    decltype(Traits::hdr_metadata(input)) in_hdr_metadata = Traits::hdr_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hdr_metadata)::BaseType> hdr_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HDRMetadataDataView>(
      in_hdr_metadata,
      hdr_metadata_fragment);

    fragment->hdr_metadata.Set(
        hdr_metadata_fragment.is_null() ? nullptr : hdr_metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hdr_metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hdr_metadata in TransferableResource struct");

    fragment->needs_detiling = Traits::needs_detiling(input);

    
    mojo::internal::Serialize<::skia::mojom::SurfaceOrigin>(
      Traits::origin(input),
      &fragment->origin);

    
    mojo::internal::Serialize<::skia::mojom::AlphaType>(
      Traits::alpha_type(input),
      &fragment->alpha_type);

    
    mojo::internal::Serialize<::viz::mojom::ResourceSource>(
      Traits::resource_source(input),
      &fragment->resource_source);
  }

  static bool Deserialize(::viz::mojom::internal::TransferableResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TransferableResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void TransferableResourceDataView::GetIdDataView(
    ::viz::mojom::ResourceIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::ResourceIdDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetFormatDataView(
    ::viz::mojom::SharedImageFormatDataView* output) {
  auto pointer = &data_->format;
  *output = ::viz::mojom::SharedImageFormatDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetMemoryBufferIdDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->memory_buffer_id.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}
inline void TransferableResourceDataView::GetHdrMetadataDataView(
    ::gfx::mojom::HDRMetadataDataView* output) {
  auto pointer = data_->hdr_metadata.Get();
  *output = ::gfx::mojom::HDRMetadataDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::SynchronizationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::SynchronizationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::ResourceSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::ResourceSource value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TRANSFERABLE_RESOURCE_MOJOM_SHARED_H_