// services/viz/public/mojom/compositing/tiling.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/tiling.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "cc/mojom/missing_tile_reason.mojom-shared.h"




#include "services/viz/public/mojom/compositing/tiling.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileResourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileResourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TileResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::resource(input)) in_resource = Traits::resource(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resource)::BaseType> resource_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::TransferableResourceDataView>(
      in_resource,
      resource_fragment);

    fragment->resource.Set(
        resource_fragment.is_null() ? nullptr : resource_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resource.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource in TileResource struct");

    fragment->is_checkered = Traits::is_checkered(input);
  }

  static bool Deserialize(::viz::mojom::internal::TileResource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileResourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->column_index = Traits::column_index(input);

    fragment->row_index = Traits::row_index(input);

    decltype(Traits::contents(input)) in_contents = Traits::contents(input);
    mojo::internal::MessageFragment<decltype(fragment->contents)>
        contents_fragment(fragment.message());
    contents_fragment.Claim(&fragment->contents);
    
    mojo::internal::Serialize<::viz::mojom::TileContentsDataView>(
      in_contents,
      contents_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contents.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents in Tile struct");
  }

  static bool Deserialize(::viz::mojom::internal::Tile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TilingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TilingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Tiling_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->layer_id = Traits::layer_id(input);

    decltype(Traits::raster_translation(input)) in_raster_translation = Traits::raster_translation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raster_translation)::BaseType> raster_translation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
      in_raster_translation,
      raster_translation_fragment);

    fragment->raster_translation.Set(
        raster_translation_fragment.is_null() ? nullptr : raster_translation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raster_translation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raster_translation in Tiling struct");

    decltype(Traits::raster_scale(input)) in_raster_scale = Traits::raster_scale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raster_scale)::BaseType> raster_scale_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
      in_raster_scale,
      raster_scale_fragment);

    fragment->raster_scale.Set(
        raster_scale_fragment.is_null() ? nullptr : raster_scale_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raster_scale.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raster_scale in Tiling struct");

    decltype(Traits::tile_size(input)) in_tile_size = Traits::tile_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tile_size)::BaseType> tile_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_tile_size,
      tile_size_fragment);

    fragment->tile_size.Set(
        tile_size_fragment.is_null() ? nullptr : tile_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tile_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tile_size in Tiling struct");

    decltype(Traits::tiling_rect(input)) in_tiling_rect = Traits::tiling_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tiling_rect)::BaseType> tiling_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_tiling_rect,
      tiling_rect_fragment);

    fragment->tiling_rect.Set(
        tiling_rect_fragment.is_null() ? nullptr : tiling_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tiling_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tiling_rect in Tiling struct");

    decltype(Traits::tiles(input)) in_tiles = Traits::tiles(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tiles)::BaseType>
        tiles_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tiles_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::TileDataView>>(
      in_tiles,
      tiles_fragment,
      &tiles_validate_params);

    fragment->tiles.Set(
        tiles_fragment.is_null() ? nullptr : tiles_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tiles.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tiles in Tiling struct");

    fragment->scale_key = Traits::scale_key(input);

    fragment->is_deleted = Traits::is_deleted(input);
  }

  static bool Deserialize(::viz::mojom::internal::Tiling_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TilingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileContentsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::TileContentsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::TileContents_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::TileContentsDataView::Tag::kMissingReason: {
    decltype(Traits::missing_reason(input))
    in_missing_reason = Traits::missing_reason(input);
        
mojo::internal::Serialize<::cc::mojom::MissingTileReason>(
  in_missing_reason,
  &fragment->data.f_missing_reason);
    break;
  }
  case ::viz::mojom::TileContentsDataView::Tag::kResource: {
    decltype(Traits::resource(input))
    in_resource = Traits::resource(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_resource)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TileResourceDataView>(
  in_resource,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null resource in TileContents union");
    fragment->data.f_resource.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::TileContentsDataView::Tag::kSolidColor: {
    decltype(Traits::solid_color(input))
    in_solid_color = Traits::solid_color(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_solid_color)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
  in_solid_color,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null solid_color in TileContents union");
    fragment->data.f_solid_color.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::viz::mojom::internal::TileContents_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileContentsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void TileResourceDataView::GetResourceDataView(
    ::viz::mojom::TransferableResourceDataView* output) {
  auto pointer = data_->resource.Get();
  *output = ::viz::mojom::TransferableResourceDataView(pointer, message_);
}


inline void TileDataView::GetContentsDataView(
    TileContentsDataView* output) {
  auto pointer = &data_->contents;
  *output = TileContentsDataView(pointer, message_);
}


inline void TilingDataView::GetRasterTranslationDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->raster_translation.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void TilingDataView::GetRasterScaleDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->raster_scale.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void TilingDataView::GetTileSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->tile_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void TilingDataView::GetTilingRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->tiling_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void TilingDataView::GetTilesDataView(
    mojo::ArrayDataView<TileDataView>* output) {
  auto pointer = data_->tiles.Get();
  *output = mojo::ArrayDataView<TileDataView>(pointer, message_);
}


inline void TileContentsDataView::GetResourceDataView(
    TileResourceDataView* output) const {
  CHECK(is_resource());
  *output = TileResourceDataView(data_->data.f_resource.Get(), message_);
}
inline void TileContentsDataView::GetSolidColorDataView(
    ::skia::mojom::SkColor4fDataView* output) const {
  CHECK(is_solid_color());
  *output = ::skia::mojom::SkColor4fDataView(data_->data.f_solid_color.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TILING_MOJOM_SHARED_H_