// services/viz/public/mojom/compositing/surface_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/surface_info.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/viz/public/mojom/compositing/surface_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::SurfaceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::surface_id(input)) in_surface_id = Traits::surface_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->surface_id)::BaseType> surface_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView, send_validation>(
        in_surface_id,
        surface_id_fragment);

      fragment->surface_id.Set(
          surface_id_fragment.is_null() ? nullptr : surface_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->surface_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null surface_id in SurfaceInfo struct");

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size_in_pixels,
        size_in_pixels_fragment);

      fragment->size_in_pixels.Set(
          size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size_in_pixels.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size_in_pixels in SurfaceInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SEND_VALIDATION_H_