// services/viz/public/mojom/compositing/surface_id.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_id.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"




#include "services/viz/public/mojom/compositing/surface_id.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SurfaceIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
      in_frame_sink_id,
      frame_sink_id_fragment);

    fragment->frame_sink_id.Set(
        frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_sink_id in SurfaceId struct");

    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id,
      local_surface_id_fragment);

    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_surface_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in SurfaceId struct");
  }

  static bool Deserialize(::viz::mojom::internal::SurfaceId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SurfaceIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SurfaceIdDataView::GetFrameSinkIdDataView(
    ::viz::mojom::FrameSinkIdDataView* output) {
  auto pointer = data_->frame_sink_id.Get();
  *output = ::viz::mojom::FrameSinkIdDataView(pointer, message_);
}
inline void SurfaceIdDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_ID_MOJOM_SHARED_H_