// services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"




#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SubtreeCaptureIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SubtreeCaptureIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SubtreeCaptureId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::subtree_id(input)) in_subtree_id = Traits::subtree_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subtree_id)::BaseType> subtree_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
      in_subtree_id,
      subtree_id_fragment);

    fragment->subtree_id.Set(
        subtree_id_fragment.is_null() ? nullptr : subtree_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subtree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subtree_id in SubtreeCaptureId struct");
  }

  static bool Deserialize(::viz::mojom::internal::SubtreeCaptureId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SubtreeCaptureIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SubtreeCaptureIdDataView::GetSubtreeIdDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->subtree_id.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SUBTREE_CAPTURE_ID_MOJOM_SHARED_H_