// services/viz/public/mojom/compositing/shared_quad_state.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::SharedQuadStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SharedQuadStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SharedQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::quad_to_target_transform(input)) in_quad_to_target_transform = Traits::quad_to_target_transform(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quad_to_target_transform)::BaseType> quad_to_target_transform_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_quad_to_target_transform,
        quad_to_target_transform_fragment);

      fragment->quad_to_target_transform.Set(
          quad_to_target_transform_fragment.is_null() ? nullptr : quad_to_target_transform_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quad_to_target_transform.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_to_target_transform in SharedQuadState struct");

      decltype(Traits::quad_layer_rect(input)) in_quad_layer_rect = Traits::quad_layer_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quad_layer_rect)::BaseType> quad_layer_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_quad_layer_rect,
        quad_layer_rect_fragment);

      fragment->quad_layer_rect.Set(
          quad_layer_rect_fragment.is_null() ? nullptr : quad_layer_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quad_layer_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quad_layer_rect in SharedQuadState struct");

      decltype(Traits::visible_quad_layer_rect(input)) in_visible_quad_layer_rect = Traits::visible_quad_layer_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_quad_layer_rect)::BaseType> visible_quad_layer_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_visible_quad_layer_rect,
        visible_quad_layer_rect_fragment);

      fragment->visible_quad_layer_rect.Set(
          visible_quad_layer_rect_fragment.is_null() ? nullptr : visible_quad_layer_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_quad_layer_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_quad_layer_rect in SharedQuadState struct");

      decltype(Traits::mask_filter_info(input)) in_mask_filter_info = Traits::mask_filter_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mask_filter_info)::BaseType> mask_filter_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::MaskFilterInfoDataView, send_validation>(
        in_mask_filter_info,
        mask_filter_info_fragment);

      fragment->mask_filter_info.Set(
          mask_filter_info_fragment.is_null() ? nullptr : mask_filter_info_fragment.data());

      decltype(Traits::clip_rect(input)) in_clip_rect = Traits::clip_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->clip_rect)::BaseType> clip_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_clip_rect,
        clip_rect_fragment);

      fragment->clip_rect.Set(
          clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

      fragment->are_contents_opaque = Traits::are_contents_opaque(input);

      fragment->opacity = Traits::opacity(input);

      fragment->blend_mode = Traits::blend_mode(input);

      fragment->sorting_context_id = Traits::sorting_context_id(input);

      fragment->layer_id = Traits::layer_id(input);

      fragment->is_fast_rounded_corner = Traits::is_fast_rounded_corner(input);

      decltype(Traits::offset_tag(input)) in_offset_tag = Traits::offset_tag(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->offset_tag)::BaseType> offset_tag_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::OffsetTagDataView, send_validation>(
        in_offset_tag,
        offset_tag_fragment);

      fragment->offset_tag.Set(
          offset_tag_fragment.is_null() ? nullptr : offset_tag_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->offset_tag.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset_tag in SharedQuadState struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_QUAD_STATE_MOJOM_SEND_VALIDATION_H_