// services/viz/public/mojom/compositing/shared_image_format.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/internal/singleplanar_format.mojom-shared.h"

#include "services/viz/public/mojom/compositing/shared_image_format.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::PlaneConfig, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::Subsampling, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::ChannelFormat, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::MultiplanarFormatDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::MultiplanarFormatDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::MultiplanarFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::viz::mojom::PlaneConfig>(
        Traits::plane_config(input),
        &fragment->plane_config);

      
      mojo::internal::Serialize<::viz::mojom::Subsampling>(
        Traits::subsampling(input),
        &fragment->subsampling);

      
      mojo::internal::Serialize<::viz::mojom::ChannelFormat>(
        Traits::channel_format(input),
        &fragment->channel_format);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::SharedImageFormatDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::SharedImageFormatDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::SharedImageFormat_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::SharedImageFormatDataView::Tag::kSingleplanarFormat: {
    decltype(Traits::singleplanar_format(input))
    in_singleplanar_format = Traits::singleplanar_format(input);
        
mojo::internal::Serialize<::viz::mojom::SingleplanarFormat, send_validation>(
  in_singleplanar_format,
  &fragment->data.f_singleplanar_format);
    break;
  }
  case ::viz::mojom::SharedImageFormatDataView::Tag::kMultiplanarFormat: {
    decltype(Traits::multiplanar_format(input))
    in_multiplanar_format = Traits::multiplanar_format(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_multiplanar_format)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::MultiplanarFormatDataView, send_validation>(
  in_multiplanar_format,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null multiplanar_format in SharedImageFormat union");
    fragment->data.f_multiplanar_format.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SHARED_IMAGE_FORMAT_MOJOM_SEND_VALIDATION_H_