// services/viz/public/mojom/compositing/selection.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/selection.mojom-shared-internal.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared.h"




#include "services/viz/public/mojom/compositing/selection.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SelectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SelectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Selection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::start(input)) in_start = Traits::start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start)::BaseType> start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundDataView>(
      in_start,
      start_fragment);

    fragment->start.Set(
        start_fragment.is_null() ? nullptr : start_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start in Selection struct");

    decltype(Traits::end(input)) in_end = Traits::end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end)::BaseType> end_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundDataView>(
      in_end,
      end_fragment);

    fragment->end.Set(
        end_fragment.is_null() ? nullptr : end_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->end.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end in Selection struct");
  }

  static bool Deserialize(::viz::mojom::internal::Selection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SelectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SelectionDataView::GetStartDataView(
    ::gfx::mojom::SelectionBoundDataView* output) {
  auto pointer = data_->start.Get();
  *output = ::gfx::mojom::SelectionBoundDataView(pointer, message_);
}
inline void SelectionDataView::GetEndDataView(
    ::gfx::mojom::SelectionBoundDataView* output) {
  auto pointer = data_->end.Get();
  *output = ::gfx::mojom::SelectionBoundDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SELECTION_MOJOM_SHARED_H_