// services/viz/public/mojom/compositing/returned_resource.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom-shared.h"

#include "services/viz/public/mojom/compositing/returned_resource.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ReturnedResourceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ReturnedResourceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ReturnedResource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ResourceIdDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ReturnedResource struct");

      decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView, send_validation>(
        in_sync_token,
        sync_token_fragment);

      fragment->sync_token.Set(
          sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sync_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in ReturnedResource struct");

      decltype(Traits::release_fence(input)) in_release_fence = Traits::release_fence(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->release_fence)::BaseType> release_fence_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::GpuFenceHandleDataView, send_validation>(
        in_release_fence,
        release_fence_fragment);

      fragment->release_fence.Set(
          release_fence_fragment.is_null() ? nullptr : release_fence_fragment.data());

      fragment->count = Traits::count(input);

      fragment->lost = Traits::lost(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_RETURNED_RESOURCE_MOJOM_SEND_VALIDATION_H_