// services/viz/public/mojom/compositing/quads.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/quads.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var paint_flags$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/paint_flags.mojom', '../../../../../cc/mojom/paint_flags.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var compositor_render_pass_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_render_pass_id.mojom', 'compositor_render_pass_id.mojom.js');
  }
  var resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/resource_id.mojom', 'resource_id.mojom.js');
  }
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', 'view_transition_element_resource_id.mojom.js');
  }
  var shared_quad_state$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/shared_quad_state.mojom', 'shared_quad_state.mojom.js');
  }
  var surface_range$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_range.mojom', 'surface_range.mojom.js');
  }
  var skcolor4f$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor4f.mojom', '../../../../../skia/public/mojom/skcolor4f.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../../../../ui/gfx/mojom/color_space.mojom.js');
  }
  var hdr_metadata$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/hdr_metadata.mojom', '../../../../../ui/gfx/mojom/hdr_metadata.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }


  var ProtectedVideoState = {};
  ProtectedVideoState.kClear = 0;
  ProtectedVideoState.kSoftwareProtected = 1;
  ProtectedVideoState.kHardwareProtected = 2;
  ProtectedVideoState.MIN_VALUE = 0;
  ProtectedVideoState.MAX_VALUE = 2;

  ProtectedVideoState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ProtectedVideoState.toKnownEnumValue = function(value) {
    return value;
  };

  ProtectedVideoState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var OverlayPriority = {};
  OverlayPriority.kLow = 0;
  OverlayPriority.kRegular = 1;
  OverlayPriority.kRequired = 2;
  OverlayPriority.MIN_VALUE = 0;
  OverlayPriority.MAX_VALUE = 2;

  OverlayPriority.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  OverlayPriority.toKnownEnumValue = function(value) {
    return value;
  };

  OverlayPriority.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function RoundedDisplayMasksInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RoundedDisplayMasksInfo.prototype.initDefaults_ = function() {
    this.isHorizontallyPositioned = false;
    this.radii = null;
  };
  RoundedDisplayMasksInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RoundedDisplayMasksInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate RoundedDisplayMasksInfo.radii
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [2], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RoundedDisplayMasksInfo.encodedSize = codec.kStructHeaderSize + 16;

  RoundedDisplayMasksInfo.decode = function(decoder) {
    var packed;
    var val = new RoundedDisplayMasksInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isHorizontallyPositioned = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.radii =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  RoundedDisplayMasksInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RoundedDisplayMasksInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isHorizontallyPositioned & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.radii);
  };
  function DebugBorderQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DebugBorderQuadState.prototype.initDefaults_ = function() {
    this.color = null;
    this.width = 0;
  };
  DebugBorderQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DebugBorderQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DebugBorderQuadState.color
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DebugBorderQuadState.encodedSize = codec.kStructHeaderSize + 16;

  DebugBorderQuadState.decode = function(decoder) {
    var packed;
    var val = new DebugBorderQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.color =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.width =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DebugBorderQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DebugBorderQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.color);
    encoder.encodeStruct(codec.Int32, val.width);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CompositorRenderPassQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorRenderPassQuadState.prototype.initDefaults_ = function() {
    this.renderPassId = null;
    this.maskResourceId = null;
    this.maskUvRect = null;
    this.maskTextureSize = null;
    this.filtersScale = null;
    this.filtersOrigin = null;
    this.texCoordRect = null;
    this.forceAntiAliasingOff = false;
    this.intersectsDamageUnder = false;
    this.backdropFilterQuality = 0;
  };
  CompositorRenderPassQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorRenderPassQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.renderPassId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, compositor_render_pass_id$.CompositorRenderPassId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.maskResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, resource_id$.ResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.maskUvRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.maskTextureSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.filtersScale
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.filtersOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorRenderPassQuadState.texCoordRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  CompositorRenderPassQuadState.encodedSize = codec.kStructHeaderSize + 64;

  CompositorRenderPassQuadState.decode = function(decoder) {
    var packed;
    var val = new CompositorRenderPassQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.renderPassId =
        decoder.decodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId);
    val.maskResourceId =
        decoder.decodeStructPointer(resource_id$.ResourceId);
    val.maskUvRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.maskTextureSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.filtersScale =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.filtersOrigin =
        decoder.decodeStructPointer(geometry$.PointF);
    val.texCoordRect =
        decoder.decodeStructPointer(geometry$.RectF);
    packed = decoder.readUint8();
    val.forceAntiAliasingOff = (packed >> 0) & 1 ? true : false;
    val.intersectsDamageUnder = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.backdropFilterQuality =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  CompositorRenderPassQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorRenderPassQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(compositor_render_pass_id$.CompositorRenderPassId, val.renderPassId);
    encoder.encodeStructPointer(resource_id$.ResourceId, val.maskResourceId);
    encoder.encodeStructPointer(geometry$.RectF, val.maskUvRect);
    encoder.encodeStructPointer(geometry$.Size, val.maskTextureSize);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.filtersScale);
    encoder.encodeStructPointer(geometry$.PointF, val.filtersOrigin);
    encoder.encodeStructPointer(geometry$.RectF, val.texCoordRect);
    packed = 0;
    packed |= (val.forceAntiAliasingOff & 1) << 0
    packed |= (val.intersectsDamageUnder & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.backdropFilterQuality);
  };
  function SolidColorQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SolidColorQuadState.prototype.initDefaults_ = function() {
    this.color = null;
    this.forceAntiAliasingOff = false;
  };
  SolidColorQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SolidColorQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SolidColorQuadState.color
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SolidColorQuadState.encodedSize = codec.kStructHeaderSize + 16;

  SolidColorQuadState.decode = function(decoder) {
    var packed;
    var val = new SolidColorQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.color =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    packed = decoder.readUint8();
    val.forceAntiAliasingOff = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SolidColorQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SolidColorQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.color);
    packed = 0;
    packed |= (val.forceAntiAliasingOff & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SurfaceQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SurfaceQuadState.prototype.initDefaults_ = function() {
    this.surfaceRange = null;
    this.defaultBackgroundColor = null;
    this.stretchContentToFillBounds = false;
    this.isReflection = false;
    this.allowMerge = false;
    this.override_child_filter_quality_$flag = false;
    this.override_child_filter_quality_$value = 0;
    this.overrideChildDynamicRangeLimit = null;
  };
  SurfaceQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SurfaceQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurfaceQuadState.surfaceRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, surface_range$.SurfaceRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurfaceQuadState.defaultBackgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate SurfaceQuadState.override_child_filter_quality_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, paint_flags$.FilterQuality);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurfaceQuadState.overrideChildDynamicRangeLimit
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, paint_flags$.DynamicRangeLimit, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SurfaceQuadState.encodedSize = codec.kStructHeaderSize + 32;

  SurfaceQuadState.decode = function(decoder) {
    var packed;
    var val = new SurfaceQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.surfaceRange =
        decoder.decodeStructPointer(surface_range$.SurfaceRange);
    val.defaultBackgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    packed = decoder.readUint8();
    val.stretchContentToFillBounds = (packed >> 0) & 1 ? true : false;
    val.isReflection = (packed >> 1) & 1 ? true : false;
    val.allowMerge = (packed >> 2) & 1 ? true : false;
    val.override_child_filter_quality_$flag = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.override_child_filter_quality_$value =
        decoder.decodeStruct(new codec.Enum(paint_flags$.FilterQuality));
    val.overrideChildDynamicRangeLimit =
        decoder.decodeStructPointer(paint_flags$.DynamicRangeLimit);
    return val;
  };

  SurfaceQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SurfaceQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(surface_range$.SurfaceRange, val.surfaceRange);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.defaultBackgroundColor);
    packed = 0;
    packed |= (val.stretchContentToFillBounds & 1) << 0
    packed |= (val.isReflection & 1) << 1
    packed |= (val.allowMerge & 1) << 2
    packed |= (val.override_child_filter_quality_$flag & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.override_child_filter_quality_$value);
    encoder.encodeStructPointer(paint_flags$.DynamicRangeLimit, val.overrideChildDynamicRangeLimit);
  };
  function TextureQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextureQuadState.prototype.initDefaults_ = function() {
    this.resourceId = null;
    this.texCoordRect = null;
    this.backgroundColor = null;
    this.dynamicRangeLimit = null;
    this.nearestNeighbor = false;
    this.secureOutputOnly = false;
    this.isVideoFrame = false;
    this.forceRgbx = false;
    this.protectedVideoType = 0;
    this.damageRect = null;
    this.overlayPriorityHint = 0;
    this.roundedDisplayMasksInfo = null;
  };
  TextureQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextureQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.resourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, resource_id$.ResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.texCoordRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.backgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.dynamicRangeLimit
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, paint_flags$.DynamicRangeLimit, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate TextureQuadState.protectedVideoType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, ProtectedVideoState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.damageRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Rect, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.overlayPriorityHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, OverlayPriority);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextureQuadState.roundedDisplayMasksInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, RoundedDisplayMasksInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextureQuadState.encodedSize = codec.kStructHeaderSize + 64;

  TextureQuadState.decode = function(decoder) {
    var packed;
    var val = new TextureQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resourceId =
        decoder.decodeStructPointer(resource_id$.ResourceId);
    val.texCoordRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.backgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.dynamicRangeLimit =
        decoder.decodeStructPointer(paint_flags$.DynamicRangeLimit);
    packed = decoder.readUint8();
    val.nearestNeighbor = (packed >> 0) & 1 ? true : false;
    val.secureOutputOnly = (packed >> 1) & 1 ? true : false;
    val.isVideoFrame = (packed >> 2) & 1 ? true : false;
    val.forceRgbx = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.protectedVideoType =
        decoder.decodeStruct(new codec.Enum(ProtectedVideoState));
    val.damageRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.overlayPriorityHint =
        decoder.decodeStruct(new codec.Enum(OverlayPriority));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.roundedDisplayMasksInfo =
        decoder.decodeStructPointer(RoundedDisplayMasksInfo);
    return val;
  };

  TextureQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextureQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(resource_id$.ResourceId, val.resourceId);
    encoder.encodeStructPointer(geometry$.RectF, val.texCoordRect);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.backgroundColor);
    encoder.encodeStructPointer(paint_flags$.DynamicRangeLimit, val.dynamicRangeLimit);
    packed = 0;
    packed |= (val.nearestNeighbor & 1) << 0
    packed |= (val.secureOutputOnly & 1) << 1
    packed |= (val.isVideoFrame & 1) << 2
    packed |= (val.forceRgbx & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.protectedVideoType);
    encoder.encodeStructPointer(geometry$.Rect, val.damageRect);
    encoder.encodeStruct(codec.Int32, val.overlayPriorityHint);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(RoundedDisplayMasksInfo, val.roundedDisplayMasksInfo);
  };
  function TileQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TileQuadState.prototype.initDefaults_ = function() {
    this.texCoordRect = null;
    this.resourceId = null;
    this.nearestNeighbor = false;
    this.forceAntiAliasingOff = false;
  };
  TileQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TileQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TileQuadState.texCoordRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TileQuadState.resourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, resource_id$.ResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TileQuadState.encodedSize = codec.kStructHeaderSize + 24;

  TileQuadState.decode = function(decoder) {
    var packed;
    var val = new TileQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.texCoordRect =
        decoder.decodeStructPointer(geometry$.RectF);
    val.resourceId =
        decoder.decodeStructPointer(resource_id$.ResourceId);
    packed = decoder.readUint8();
    val.nearestNeighbor = (packed >> 0) & 1 ? true : false;
    val.forceAntiAliasingOff = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TileQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TileQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.RectF, val.texCoordRect);
    encoder.encodeStructPointer(resource_id$.ResourceId, val.resourceId);
    packed = 0;
    packed |= (val.nearestNeighbor & 1) << 0
    packed |= (val.forceAntiAliasingOff & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VideoHoleQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VideoHoleQuadState.prototype.initDefaults_ = function() {
    this.overlayPlaneId = null;
  };
  VideoHoleQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VideoHoleQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate VideoHoleQuadState.overlayPlaneId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  VideoHoleQuadState.encodedSize = codec.kStructHeaderSize + 8;

  VideoHoleQuadState.decode = function(decoder) {
    var packed;
    var val = new VideoHoleQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.overlayPlaneId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  VideoHoleQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VideoHoleQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.overlayPlaneId);
  };
  function SharedElementQuadState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedElementQuadState.prototype.initDefaults_ = function() {
    this.elementResourceId = null;
  };
  SharedElementQuadState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedElementQuadState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedElementQuadState.elementResourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedElementQuadState.encodedSize = codec.kStructHeaderSize + 8;

  SharedElementQuadState.decode = function(decoder) {
    var packed;
    var val = new SharedElementQuadState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elementResourceId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    return val;
  };

  SharedElementQuadState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedElementQuadState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.elementResourceId);
  };
  function DrawQuad(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DrawQuad.prototype.initDefaults_ = function() {
    this.rect = null;
    this.visibleRect = null;
    this.needsBlending = false;
    this.sqs = null;
    this.drawQuadState = null;
  };
  DrawQuad.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DrawQuad.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DrawQuad.rect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DrawQuad.visibleRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DrawQuad.sqs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, shared_quad_state$.SharedQuadState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DrawQuad.drawQuadState
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 32, DrawQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DrawQuad.encodedSize = codec.kStructHeaderSize + 48;

  DrawQuad.decode = function(decoder) {
    var packed;
    var val = new DrawQuad();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.visibleRect =
        decoder.decodeStructPointer(geometry$.Rect);
    packed = decoder.readUint8();
    val.needsBlending = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sqs =
        decoder.decodeStructPointer(shared_quad_state$.SharedQuadState);
    val.drawQuadState =
        decoder.decodeStruct(DrawQuadState);
    return val;
  };

  DrawQuad.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DrawQuad.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.rect);
    encoder.encodeStructPointer(geometry$.Rect, val.visibleRect);
    packed = 0;
    packed |= (val.needsBlending & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(shared_quad_state$.SharedQuadState, val.sqs);
    encoder.encodeStruct(DrawQuadState, val.drawQuadState);
  };

  function DrawQuadState(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DrawQuadState.Tags = {
    debugBorderQuadState: 0,
    renderPassQuadState: 1,
    solidColorQuadState: 2,
    surfaceQuadState: 3,
    textureQuadState: 4,
    tileQuadState: 5,
    videoHoleQuadState: 6,
    sharedElementQuadState: 7,
  };

  DrawQuadState.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DrawQuadState.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "debugBorderQuadState",
        "renderPassQuadState",
        "solidColorQuadState",
        "surfaceQuadState",
        "textureQuadState",
        "tileQuadState",
        "videoHoleQuadState",
        "sharedElementQuadState",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DrawQuadState member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DrawQuadState.prototype, "debugBorderQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.debugBorderQuadState) {
        throw new ReferenceError(
            "DrawQuadState.debugBorderQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.debugBorderQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "renderPassQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.renderPassQuadState) {
        throw new ReferenceError(
            "DrawQuadState.renderPassQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.renderPassQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "solidColorQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.solidColorQuadState) {
        throw new ReferenceError(
            "DrawQuadState.solidColorQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.solidColorQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "surfaceQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.surfaceQuadState) {
        throw new ReferenceError(
            "DrawQuadState.surfaceQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.surfaceQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "textureQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.textureQuadState) {
        throw new ReferenceError(
            "DrawQuadState.textureQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.textureQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "tileQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.tileQuadState) {
        throw new ReferenceError(
            "DrawQuadState.tileQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.tileQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "videoHoleQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.videoHoleQuadState) {
        throw new ReferenceError(
            "DrawQuadState.videoHoleQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.videoHoleQuadState;
      this.$data = value;
    }
  });
  Object.defineProperty(DrawQuadState.prototype, "sharedElementQuadState", {
    get: function() {
      if (this.$tag != DrawQuadState.Tags.sharedElementQuadState) {
        throw new ReferenceError(
            "DrawQuadState.sharedElementQuadState is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DrawQuadState.Tags.sharedElementQuadState;
      this.$data = value;
    }
  });


    DrawQuadState.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DrawQuadState.Tags.debugBorderQuadState:
          encoder.encodeStructPointer(DebugBorderQuadState, val.debugBorderQuadState);
          break;
        case DrawQuadState.Tags.renderPassQuadState:
          encoder.encodeStructPointer(CompositorRenderPassQuadState, val.renderPassQuadState);
          break;
        case DrawQuadState.Tags.solidColorQuadState:
          encoder.encodeStructPointer(SolidColorQuadState, val.solidColorQuadState);
          break;
        case DrawQuadState.Tags.surfaceQuadState:
          encoder.encodeStructPointer(SurfaceQuadState, val.surfaceQuadState);
          break;
        case DrawQuadState.Tags.textureQuadState:
          encoder.encodeStructPointer(TextureQuadState, val.textureQuadState);
          break;
        case DrawQuadState.Tags.tileQuadState:
          encoder.encodeStructPointer(TileQuadState, val.tileQuadState);
          break;
        case DrawQuadState.Tags.videoHoleQuadState:
          encoder.encodeStructPointer(VideoHoleQuadState, val.videoHoleQuadState);
          break;
        case DrawQuadState.Tags.sharedElementQuadState:
          encoder.encodeStructPointer(SharedElementQuadState, val.sharedElementQuadState);
          break;
      }
      encoder.align();
    };


    DrawQuadState.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DrawQuadState();
      var tag = decoder.readUint32();
      switch (tag) {
        case DrawQuadState.Tags.debugBorderQuadState:
          result.debugBorderQuadState = decoder.decodeStructPointer(DebugBorderQuadState);
          break;
        case DrawQuadState.Tags.renderPassQuadState:
          result.renderPassQuadState = decoder.decodeStructPointer(CompositorRenderPassQuadState);
          break;
        case DrawQuadState.Tags.solidColorQuadState:
          result.solidColorQuadState = decoder.decodeStructPointer(SolidColorQuadState);
          break;
        case DrawQuadState.Tags.surfaceQuadState:
          result.surfaceQuadState = decoder.decodeStructPointer(SurfaceQuadState);
          break;
        case DrawQuadState.Tags.textureQuadState:
          result.textureQuadState = decoder.decodeStructPointer(TextureQuadState);
          break;
        case DrawQuadState.Tags.tileQuadState:
          result.tileQuadState = decoder.decodeStructPointer(TileQuadState);
          break;
        case DrawQuadState.Tags.videoHoleQuadState:
          result.videoHoleQuadState = decoder.decodeStructPointer(VideoHoleQuadState);
          break;
        case DrawQuadState.Tags.sharedElementQuadState:
          result.sharedElementQuadState = decoder.decodeStructPointer(SharedElementQuadState);
          break;
      }
      decoder.align();

      return result;
    };


    DrawQuadState.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DrawQuadState.Tags.debugBorderQuadState:
          

    // validate DrawQuadState.debugBorderQuadState
    err = messageValidator.validateStructPointer(data_offset, DebugBorderQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.renderPassQuadState:
          

    // validate DrawQuadState.renderPassQuadState
    err = messageValidator.validateStructPointer(data_offset, CompositorRenderPassQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.solidColorQuadState:
          

    // validate DrawQuadState.solidColorQuadState
    err = messageValidator.validateStructPointer(data_offset, SolidColorQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.surfaceQuadState:
          

    // validate DrawQuadState.surfaceQuadState
    err = messageValidator.validateStructPointer(data_offset, SurfaceQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.textureQuadState:
          

    // validate DrawQuadState.textureQuadState
    err = messageValidator.validateStructPointer(data_offset, TextureQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.tileQuadState:
          

    // validate DrawQuadState.tileQuadState
    err = messageValidator.validateStructPointer(data_offset, TileQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.videoHoleQuadState:
          

    // validate DrawQuadState.videoHoleQuadState
    err = messageValidator.validateStructPointer(data_offset, VideoHoleQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DrawQuadState.Tags.sharedElementQuadState:
          

    // validate DrawQuadState.sharedElementQuadState
    err = messageValidator.validateStructPointer(data_offset, SharedElementQuadState, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  DrawQuadState.encodedSize = 16;
  exports.ProtectedVideoState = ProtectedVideoState;
  exports.OverlayPriority = OverlayPriority;
  exports.RoundedDisplayMasksInfo = RoundedDisplayMasksInfo;
  exports.DebugBorderQuadState = DebugBorderQuadState;
  exports.CompositorRenderPassQuadState = CompositorRenderPassQuadState;
  exports.SolidColorQuadState = SolidColorQuadState;
  exports.SurfaceQuadState = SurfaceQuadState;
  exports.TextureQuadState = TextureQuadState;
  exports.TileQuadState = TileQuadState;
  exports.VideoHoleQuadState = VideoHoleQuadState;
  exports.SharedElementQuadState = SharedElementQuadState;
  exports.DrawQuad = DrawQuad;
  exports.DrawQuadState = DrawQuadState;
})();