// services/viz/public/mojom/compositing/quads.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/quads.mojom-shared-internal.h"
#include "cc/mojom/paint_flags.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"




#include "services/viz/public/mojom/compositing/quads.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::ProtectedVideoState>
    : public mojo::internal::EnumHashImpl<::viz::mojom::ProtectedVideoState> {};

template <>
struct hash<::viz::mojom::OverlayPriority>
    : public mojo::internal::EnumHashImpl<::viz::mojom::OverlayPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ProtectedVideoState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::ProtectedVideoState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::ProtectedVideoState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OverlayPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::OverlayPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::OverlayPriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::RoundedDisplayMasksInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RoundedDisplayMasksInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::RoundedDisplayMasksInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_horizontally_positioned = Traits::is_horizontally_positioned(input);

    decltype(Traits::radii(input)) in_radii = Traits::radii(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->radii)::BaseType>
        radii_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& radii_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_radii,
      radii_fragment,
      &radii_validate_params);

    fragment->radii.Set(
        radii_fragment.is_null() ? nullptr : radii_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->radii.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null radii in RoundedDisplayMasksInfo struct");
  }

  static bool Deserialize(::viz::mojom::internal::RoundedDisplayMasksInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::RoundedDisplayMasksInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DebugBorderQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::DebugBorderQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::DebugBorderQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::color(input)) in_color = Traits::color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color)::BaseType> color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_color,
      color_fragment);

    fragment->color.Set(
        color_fragment.is_null() ? nullptr : color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color in DebugBorderQuadState struct");

    fragment->width = Traits::width(input);
  }

  static bool Deserialize(::viz::mojom::internal::DebugBorderQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DebugBorderQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorRenderPassQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorRenderPassQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorRenderPassQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::render_pass_id(input)) in_render_pass_id = Traits::render_pass_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->render_pass_id)::BaseType> render_pass_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView>(
      in_render_pass_id,
      render_pass_id_fragment);

    fragment->render_pass_id.Set(
        render_pass_id_fragment.is_null() ? nullptr : render_pass_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->render_pass_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null render_pass_id in CompositorRenderPassQuadState struct");

    decltype(Traits::mask_resource_id(input)) in_mask_resource_id = Traits::mask_resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mask_resource_id)::BaseType> mask_resource_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ResourceIdDataView>(
      in_mask_resource_id,
      mask_resource_id_fragment);

    fragment->mask_resource_id.Set(
        mask_resource_id_fragment.is_null() ? nullptr : mask_resource_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mask_resource_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mask_resource_id in CompositorRenderPassQuadState struct");

    decltype(Traits::mask_uv_rect(input)) in_mask_uv_rect = Traits::mask_uv_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mask_uv_rect)::BaseType> mask_uv_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_mask_uv_rect,
      mask_uv_rect_fragment);

    fragment->mask_uv_rect.Set(
        mask_uv_rect_fragment.is_null() ? nullptr : mask_uv_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mask_uv_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mask_uv_rect in CompositorRenderPassQuadState struct");

    decltype(Traits::mask_texture_size(input)) in_mask_texture_size = Traits::mask_texture_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mask_texture_size)::BaseType> mask_texture_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_mask_texture_size,
      mask_texture_size_fragment);

    fragment->mask_texture_size.Set(
        mask_texture_size_fragment.is_null() ? nullptr : mask_texture_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mask_texture_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mask_texture_size in CompositorRenderPassQuadState struct");

    decltype(Traits::filters_scale(input)) in_filters_scale = Traits::filters_scale(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters_scale)::BaseType> filters_scale_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
      in_filters_scale,
      filters_scale_fragment);

    fragment->filters_scale.Set(
        filters_scale_fragment.is_null() ? nullptr : filters_scale_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filters_scale.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters_scale in CompositorRenderPassQuadState struct");

    decltype(Traits::filters_origin(input)) in_filters_origin = Traits::filters_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters_origin)::BaseType> filters_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_filters_origin,
      filters_origin_fragment);

    fragment->filters_origin.Set(
        filters_origin_fragment.is_null() ? nullptr : filters_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filters_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters_origin in CompositorRenderPassQuadState struct");

    decltype(Traits::tex_coord_rect(input)) in_tex_coord_rect = Traits::tex_coord_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tex_coord_rect)::BaseType> tex_coord_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_tex_coord_rect,
      tex_coord_rect_fragment);

    fragment->tex_coord_rect.Set(
        tex_coord_rect_fragment.is_null() ? nullptr : tex_coord_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tex_coord_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tex_coord_rect in CompositorRenderPassQuadState struct");

    fragment->force_anti_aliasing_off = Traits::force_anti_aliasing_off(input);

    fragment->backdrop_filter_quality = Traits::backdrop_filter_quality(input);

    fragment->intersects_damage_under = Traits::intersects_damage_under(input);
  }

  static bool Deserialize(::viz::mojom::internal::CompositorRenderPassQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorRenderPassQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SolidColorQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SolidColorQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SolidColorQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::color(input)) in_color = Traits::color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color)::BaseType> color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_color,
      color_fragment);

    fragment->color.Set(
        color_fragment.is_null() ? nullptr : color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color in SolidColorQuadState struct");

    fragment->force_anti_aliasing_off = Traits::force_anti_aliasing_off(input);
  }

  static bool Deserialize(::viz::mojom::internal::SolidColorQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SolidColorQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SurfaceQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::surface_range(input)) in_surface_range = Traits::surface_range(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_range)::BaseType> surface_range_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SurfaceRangeDataView>(
      in_surface_range,
      surface_range_fragment);

    fragment->surface_range.Set(
        surface_range_fragment.is_null() ? nullptr : surface_range_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->surface_range.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_range in SurfaceQuadState struct");

    decltype(Traits::default_background_color(input)) in_default_background_color = Traits::default_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_background_color)::BaseType> default_background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_default_background_color,
      default_background_color_fragment);

    fragment->default_background_color.Set(
        default_background_color_fragment.is_null() ? nullptr : default_background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_background_color in SurfaceQuadState struct");

    fragment->stretch_content_to_fill_bounds = Traits::stretch_content_to_fill_bounds(input);

    fragment->is_reflection = Traits::is_reflection(input);

    fragment->allow_merge = Traits::allow_merge(input);
    fragment->override_child_filter_quality_$flag = Traits::override_child_filter_quality(input).has_value();
    if (Traits::override_child_filter_quality(input).has_value()) {
      
      mojo::internal::Serialize<::cc::mojom::FilterQuality>(
        Traits::override_child_filter_quality(input).value(),
        &fragment->override_child_filter_quality_$value);
    } else {
      fragment->override_child_filter_quality_$value =
          static_cast<int32_t>(::cc::mojom::FilterQuality::kMinValue);
    }

    decltype(Traits::override_child_dynamic_range_limit(input)) in_override_child_dynamic_range_limit = Traits::override_child_dynamic_range_limit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->override_child_dynamic_range_limit)::BaseType> override_child_dynamic_range_limit_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::DynamicRangeLimitDataView>(
      in_override_child_dynamic_range_limit,
      override_child_dynamic_range_limit_fragment);

    fragment->override_child_dynamic_range_limit.Set(
        override_child_dynamic_range_limit_fragment.is_null() ? nullptr : override_child_dynamic_range_limit_fragment.data());
  }

  static bool Deserialize(::viz::mojom::internal::SurfaceQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SurfaceQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TextureQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TextureQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TextureQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::resource_id(input)) in_resource_id = Traits::resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resource_id)::BaseType> resource_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ResourceIdDataView>(
      in_resource_id,
      resource_id_fragment);

    fragment->resource_id.Set(
        resource_id_fragment.is_null() ? nullptr : resource_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resource_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_id in TextureQuadState struct");

    decltype(Traits::tex_coord_rect(input)) in_tex_coord_rect = Traits::tex_coord_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tex_coord_rect)::BaseType> tex_coord_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_tex_coord_rect,
      tex_coord_rect_fragment);

    fragment->tex_coord_rect.Set(
        tex_coord_rect_fragment.is_null() ? nullptr : tex_coord_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tex_coord_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tex_coord_rect in TextureQuadState struct");

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in TextureQuadState struct");

    decltype(Traits::dynamic_range_limit(input)) in_dynamic_range_limit = Traits::dynamic_range_limit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dynamic_range_limit)::BaseType> dynamic_range_limit_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::cc::mojom::DynamicRangeLimitDataView>(
      in_dynamic_range_limit,
      dynamic_range_limit_fragment);

    fragment->dynamic_range_limit.Set(
        dynamic_range_limit_fragment.is_null() ? nullptr : dynamic_range_limit_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dynamic_range_limit.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dynamic_range_limit in TextureQuadState struct");

    fragment->nearest_neighbor = Traits::nearest_neighbor(input);

    fragment->secure_output_only = Traits::secure_output_only(input);

    fragment->is_video_frame = Traits::is_video_frame(input);

    fragment->force_rgbx = Traits::force_rgbx(input);

    
    mojo::internal::Serialize<::viz::mojom::ProtectedVideoState>(
      Traits::protected_video_type(input),
      &fragment->protected_video_type);

    decltype(Traits::damage_rect(input)) in_damage_rect = Traits::damage_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->damage_rect)::BaseType> damage_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_damage_rect,
      damage_rect_fragment);

    fragment->damage_rect.Set(
        damage_rect_fragment.is_null() ? nullptr : damage_rect_fragment.data());

    
    mojo::internal::Serialize<::viz::mojom::OverlayPriority>(
      Traits::overlay_priority_hint(input),
      &fragment->overlay_priority_hint);

    decltype(Traits::rounded_display_masks_info(input)) in_rounded_display_masks_info = Traits::rounded_display_masks_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rounded_display_masks_info)::BaseType> rounded_display_masks_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::RoundedDisplayMasksInfoDataView>(
      in_rounded_display_masks_info,
      rounded_display_masks_info_fragment);

    fragment->rounded_display_masks_info.Set(
        rounded_display_masks_info_fragment.is_null() ? nullptr : rounded_display_masks_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rounded_display_masks_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rounded_display_masks_info in TextureQuadState struct");
  }

  static bool Deserialize(::viz::mojom::internal::TextureQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TextureQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::TileQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TileQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tex_coord_rect(input)) in_tex_coord_rect = Traits::tex_coord_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tex_coord_rect)::BaseType> tex_coord_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_tex_coord_rect,
      tex_coord_rect_fragment);

    fragment->tex_coord_rect.Set(
        tex_coord_rect_fragment.is_null() ? nullptr : tex_coord_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tex_coord_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tex_coord_rect in TileQuadState struct");

    decltype(Traits::resource_id(input)) in_resource_id = Traits::resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resource_id)::BaseType> resource_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ResourceIdDataView>(
      in_resource_id,
      resource_id_fragment);

    fragment->resource_id.Set(
        resource_id_fragment.is_null() ? nullptr : resource_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resource_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_id in TileQuadState struct");

    fragment->nearest_neighbor = Traits::nearest_neighbor(input);

    fragment->force_anti_aliasing_off = Traits::force_anti_aliasing_off(input);
  }

  static bool Deserialize(::viz::mojom::internal::TileQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::TileQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::VideoHoleQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::VideoHoleQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::VideoHoleQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::overlay_plane_id(input)) in_overlay_plane_id = Traits::overlay_plane_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->overlay_plane_id)::BaseType> overlay_plane_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_overlay_plane_id,
      overlay_plane_id_fragment);

    fragment->overlay_plane_id.Set(
        overlay_plane_id_fragment.is_null() ? nullptr : overlay_plane_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->overlay_plane_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null overlay_plane_id in VideoHoleQuadState struct");
  }

  static bool Deserialize(::viz::mojom::internal::VideoHoleQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::VideoHoleQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SharedElementQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SharedElementQuadStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SharedElementQuadState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::element_resource_id(input)) in_element_resource_id = Traits::element_resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->element_resource_id)::BaseType> element_resource_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
      in_element_resource_id,
      element_resource_id_fragment);

    fragment->element_resource_id.Set(
        element_resource_id_fragment.is_null() ? nullptr : element_resource_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->element_resource_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null element_resource_id in SharedElementQuadState struct");
  }

  static bool Deserialize(::viz::mojom::internal::SharedElementQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SharedElementQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DrawQuadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::DrawQuadDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::DrawQuad_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect,
      rect_fragment);

    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in DrawQuad struct");

    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_visible_rect,
      visible_rect_fragment);

    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_rect in DrawQuad struct");

    fragment->needs_blending = Traits::needs_blending(input);

    decltype(Traits::sqs(input)) in_sqs = Traits::sqs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sqs)::BaseType> sqs_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SharedQuadStateDataView>(
      in_sqs,
      sqs_fragment);

    fragment->sqs.Set(
        sqs_fragment.is_null() ? nullptr : sqs_fragment.data());

    decltype(Traits::draw_quad_state(input)) in_draw_quad_state = Traits::draw_quad_state(input);
    mojo::internal::MessageFragment<decltype(fragment->draw_quad_state)>
        draw_quad_state_fragment(fragment.message());
    draw_quad_state_fragment.Claim(&fragment->draw_quad_state);
    
    mojo::internal::Serialize<::viz::mojom::DrawQuadStateDataView>(
      in_draw_quad_state,
      draw_quad_state_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->draw_quad_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_quad_state in DrawQuad struct");
  }

  static bool Deserialize(::viz::mojom::internal::DrawQuad_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DrawQuadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::DrawQuadStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::DrawQuadStateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::DrawQuadState_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::DrawQuadStateDataView::Tag::kDebugBorderQuadState: {
    decltype(Traits::debug_border_quad_state(input))
    in_debug_border_quad_state = Traits::debug_border_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_debug_border_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::DebugBorderQuadStateDataView>(
  in_debug_border_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null debug_border_quad_state in DrawQuadState union");
    fragment->data.f_debug_border_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kRenderPassQuadState: {
    decltype(Traits::render_pass_quad_state(input))
    in_render_pass_quad_state = Traits::render_pass_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_render_pass_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::CompositorRenderPassQuadStateDataView>(
  in_render_pass_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null render_pass_quad_state in DrawQuadState union");
    fragment->data.f_render_pass_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kSolidColorQuadState: {
    decltype(Traits::solid_color_quad_state(input))
    in_solid_color_quad_state = Traits::solid_color_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_solid_color_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SolidColorQuadStateDataView>(
  in_solid_color_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null solid_color_quad_state in DrawQuadState union");
    fragment->data.f_solid_color_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kSurfaceQuadState: {
    decltype(Traits::surface_quad_state(input))
    in_surface_quad_state = Traits::surface_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_surface_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SurfaceQuadStateDataView>(
  in_surface_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null surface_quad_state in DrawQuadState union");
    fragment->data.f_surface_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kTextureQuadState: {
    decltype(Traits::texture_quad_state(input))
    in_texture_quad_state = Traits::texture_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_texture_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TextureQuadStateDataView>(
  in_texture_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null texture_quad_state in DrawQuadState union");
    fragment->data.f_texture_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kTileQuadState: {
    decltype(Traits::tile_quad_state(input))
    in_tile_quad_state = Traits::tile_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tile_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TileQuadStateDataView>(
  in_tile_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tile_quad_state in DrawQuadState union");
    fragment->data.f_tile_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kVideoHoleQuadState: {
    decltype(Traits::video_hole_quad_state(input))
    in_video_hole_quad_state = Traits::video_hole_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_video_hole_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::VideoHoleQuadStateDataView>(
  in_video_hole_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null video_hole_quad_state in DrawQuadState union");
    fragment->data.f_video_hole_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::DrawQuadStateDataView::Tag::kSharedElementQuadState: {
    decltype(Traits::shared_element_quad_state(input))
    in_shared_element_quad_state = Traits::shared_element_quad_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_shared_element_quad_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SharedElementQuadStateDataView>(
  in_shared_element_quad_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null shared_element_quad_state in DrawQuadState union");
    fragment->data.f_shared_element_quad_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::viz::mojom::internal::DrawQuadState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::DrawQuadStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void RoundedDisplayMasksInfoDataView::GetRadiiDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->radii.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void DebugBorderQuadStateDataView::GetColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}


inline void CompositorRenderPassQuadStateDataView::GetRenderPassIdDataView(
    ::viz::mojom::CompositorRenderPassIdDataView* output) {
  auto pointer = data_->render_pass_id.Get();
  *output = ::viz::mojom::CompositorRenderPassIdDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetMaskResourceIdDataView(
    ::viz::mojom::ResourceIdDataView* output) {
  auto pointer = data_->mask_resource_id.Get();
  *output = ::viz::mojom::ResourceIdDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetMaskUvRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->mask_uv_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetMaskTextureSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->mask_texture_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetFiltersScaleDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->filters_scale.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetFiltersOriginDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->filters_origin.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void CompositorRenderPassQuadStateDataView::GetTexCoordRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->tex_coord_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void SolidColorQuadStateDataView::GetColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}


inline void SurfaceQuadStateDataView::GetSurfaceRangeDataView(
    ::viz::mojom::SurfaceRangeDataView* output) {
  auto pointer = data_->surface_range.Get();
  *output = ::viz::mojom::SurfaceRangeDataView(pointer, message_);
}
inline void SurfaceQuadStateDataView::GetDefaultBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->default_background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void SurfaceQuadStateDataView::GetOverrideChildDynamicRangeLimitDataView(
    ::cc::mojom::DynamicRangeLimitDataView* output) {
  auto pointer = data_->override_child_dynamic_range_limit.Get();
  *output = ::cc::mojom::DynamicRangeLimitDataView(pointer, message_);
}


inline void TextureQuadStateDataView::GetResourceIdDataView(
    ::viz::mojom::ResourceIdDataView* output) {
  auto pointer = data_->resource_id.Get();
  *output = ::viz::mojom::ResourceIdDataView(pointer, message_);
}
inline void TextureQuadStateDataView::GetTexCoordRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->tex_coord_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void TextureQuadStateDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void TextureQuadStateDataView::GetDynamicRangeLimitDataView(
    ::cc::mojom::DynamicRangeLimitDataView* output) {
  auto pointer = data_->dynamic_range_limit.Get();
  *output = ::cc::mojom::DynamicRangeLimitDataView(pointer, message_);
}
inline void TextureQuadStateDataView::GetDamageRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->damage_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void TextureQuadStateDataView::GetRoundedDisplayMasksInfoDataView(
    RoundedDisplayMasksInfoDataView* output) {
  auto pointer = data_->rounded_display_masks_info.Get();
  *output = RoundedDisplayMasksInfoDataView(pointer, message_);
}


inline void TileQuadStateDataView::GetTexCoordRectDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->tex_coord_rect.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void TileQuadStateDataView::GetResourceIdDataView(
    ::viz::mojom::ResourceIdDataView* output) {
  auto pointer = data_->resource_id.Get();
  *output = ::viz::mojom::ResourceIdDataView(pointer, message_);
}


inline void VideoHoleQuadStateDataView::GetOverlayPlaneIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->overlay_plane_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void SharedElementQuadStateDataView::GetElementResourceIdDataView(
    ::viz::mojom::ViewTransitionElementResourceIdDataView* output) {
  auto pointer = data_->element_resource_id.Get();
  *output = ::viz::mojom::ViewTransitionElementResourceIdDataView(pointer, message_);
}


inline void DrawQuadDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DrawQuadDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DrawQuadDataView::GetSqsDataView(
    ::viz::mojom::SharedQuadStateDataView* output) {
  auto pointer = data_->sqs.Get();
  *output = ::viz::mojom::SharedQuadStateDataView(pointer, message_);
}
inline void DrawQuadDataView::GetDrawQuadStateDataView(
    DrawQuadStateDataView* output) {
  auto pointer = &data_->draw_quad_state;
  *output = DrawQuadStateDataView(pointer, message_);
}


inline void DrawQuadStateDataView::GetDebugBorderQuadStateDataView(
    DebugBorderQuadStateDataView* output) const {
  CHECK(is_debug_border_quad_state());
  *output = DebugBorderQuadStateDataView(data_->data.f_debug_border_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetRenderPassQuadStateDataView(
    CompositorRenderPassQuadStateDataView* output) const {
  CHECK(is_render_pass_quad_state());
  *output = CompositorRenderPassQuadStateDataView(data_->data.f_render_pass_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetSolidColorQuadStateDataView(
    SolidColorQuadStateDataView* output) const {
  CHECK(is_solid_color_quad_state());
  *output = SolidColorQuadStateDataView(data_->data.f_solid_color_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetSurfaceQuadStateDataView(
    SurfaceQuadStateDataView* output) const {
  CHECK(is_surface_quad_state());
  *output = SurfaceQuadStateDataView(data_->data.f_surface_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetTextureQuadStateDataView(
    TextureQuadStateDataView* output) const {
  CHECK(is_texture_quad_state());
  *output = TextureQuadStateDataView(data_->data.f_texture_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetTileQuadStateDataView(
    TileQuadStateDataView* output) const {
  CHECK(is_tile_quad_state());
  *output = TileQuadStateDataView(data_->data.f_tile_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetVideoHoleQuadStateDataView(
    VideoHoleQuadStateDataView* output) const {
  CHECK(is_video_hole_quad_state());
  *output = VideoHoleQuadStateDataView(data_->data.f_video_hole_quad_state.Get(), message_);
}
inline void DrawQuadStateDataView::GetSharedElementQuadStateDataView(
    SharedElementQuadStateDataView* output) const {
  CHECK(is_shared_element_quad_state());
  *output = SharedElementQuadStateDataView(data_->data.f_shared_element_quad_state.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::ProtectedVideoState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::ProtectedVideoState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::OverlayPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::OverlayPriority value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_SHARED_H_