// services/viz/public/mojom/compositing/quads.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/quads.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* ProtectedVideoStateToStringHelper(ProtectedVideoState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProtectedVideoState::kClear:
      return "kClear";
    case ProtectedVideoState::kSoftwareProtected:
      return "kSoftwareProtected";
    case ProtectedVideoState::kHardwareProtected:
      return "kHardwareProtected";
    default:
      return nullptr;
  }
}

std::string ProtectedVideoStateToString(ProtectedVideoState value) {
  const char *str = ProtectedVideoStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProtectedVideoState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProtectedVideoState value) {
  return os << ProtectedVideoStateToString(value);
}

NOINLINE static const char* OverlayPriorityToStringHelper(OverlayPriority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OverlayPriority::kLow:
      return "kLow";
    case OverlayPriority::kRegular:
      return "kRegular";
    case OverlayPriority::kRequired:
      return "kRequired";
    default:
      return nullptr;
  }
}

std::string OverlayPriorityToString(OverlayPriority value) {
  const char *str = OverlayPriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OverlayPriority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OverlayPriority value) {
  return os << OverlayPriorityToString(value);
}

namespace internal {
// static
bool DrawQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const DrawQuadState_Data* object = static_cast<const DrawQuadState_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case DrawQuadState_Tag::kDebugBorderQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_debug_border_quad_state, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_debug_border_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kRenderPassQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_render_pass_quad_state, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_render_pass_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kSolidColorQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_solid_color_quad_state, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_solid_color_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kSurfaceQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_surface_quad_state, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_surface_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kTextureQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_texture_quad_state, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_texture_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kTileQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_tile_quad_state, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_tile_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kVideoHoleQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_video_hole_quad_state, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_video_hole_quad_state, validation_context))
        return false;
      return true;
    }
    case DrawQuadState_Tag::kSharedElementQuadState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_element_quad_state, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_element_quad_state, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in DrawQuadState");
      return false;
    }
  }
}


// static
bool RoundedDisplayMasksInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RoundedDisplayMasksInfo_Data* object =
      static_cast<const RoundedDisplayMasksInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->radii, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& radii_validate_params =
      mojo::internal::GetArrayValidator<2, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->radii, validation_context,
                                         &radii_validate_params)) {
    return false;
  }

  return true;
}

RoundedDisplayMasksInfo_Data::RoundedDisplayMasksInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DebugBorderQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DebugBorderQuadState_Data* object =
      static_cast<const DebugBorderQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;

  return true;
}

DebugBorderQuadState_Data::DebugBorderQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CompositorRenderPassQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CompositorRenderPassQuadState_Data* object =
      static_cast<const CompositorRenderPassQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_pass_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->render_pass_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mask_resource_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mask_resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mask_uv_rect, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mask_uv_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mask_texture_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mask_texture_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters_scale, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters_scale, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filters_origin, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->filters_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tex_coord_rect, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tex_coord_rect, validation_context))
    return false;

  return true;
}

CompositorRenderPassQuadState_Data::CompositorRenderPassQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SolidColorQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SolidColorQuadState_Data* object =
      static_cast<const SolidColorQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;

  return true;
}

SolidColorQuadState_Data::SolidColorQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SurfaceQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SurfaceQuadState_Data* object =
      static_cast<const SurfaceQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->surface_range, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->surface_range, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_background_color, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_background_color, validation_context))
    return false;


  if (!::cc::mojom::internal::FilterQuality_Data
        ::Validate(object->override_child_filter_quality_$value, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->override_child_dynamic_range_limit, validation_context))
    return false;

  return true;
}

SurfaceQuadState_Data::SurfaceQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextureQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextureQuadState_Data* object =
      static_cast<const TextureQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tex_coord_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tex_coord_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dynamic_range_limit, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dynamic_range_limit, validation_context))
    return false;


  if (!::viz::mojom::internal::ProtectedVideoState_Data
        ::Validate(object->protected_video_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->damage_rect, validation_context))
    return false;


  if (!::viz::mojom::internal::OverlayPriority_Data
        ::Validate(object->overlay_priority_hint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rounded_display_masks_info, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rounded_display_masks_info, validation_context))
    return false;

  return true;
}

TextureQuadState_Data::TextureQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TileQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TileQuadState_Data* object =
      static_cast<const TileQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tex_coord_rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tex_coord_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resource_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resource_id, validation_context))
    return false;

  return true;
}

TileQuadState_Data::TileQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoHoleQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoHoleQuadState_Data* object =
      static_cast<const VideoHoleQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->overlay_plane_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->overlay_plane_id, validation_context))
    return false;

  return true;
}

VideoHoleQuadState_Data::VideoHoleQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedElementQuadState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedElementQuadState_Data* object =
      static_cast<const SharedElementQuadState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->element_resource_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->element_resource_id, validation_context))
    return false;

  return true;
}

SharedElementQuadState_Data::SharedElementQuadState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DrawQuad_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DrawQuad_Data* object =
      static_cast<const DrawQuad_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sqs, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->draw_quad_state, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->draw_quad_state, validation_context))
    return false;

  return true;
}

DrawQuad_Data::DrawQuad_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::ProtectedVideoState>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::ProtectedVideoState value) {
  return std::move(context).WriteString(::viz::mojom::ProtectedVideoStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::OverlayPriority>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::OverlayPriority value) {
  return std::move(context).WriteString(::viz::mojom::OverlayPriorityToString(value));
}

} // namespace perfetto