// services/viz/public/mojom/compositing/quads.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/quads.mojom-shared-internal.h"
#include "cc/mojom/paint_flags.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace viz::mojom {
class RoundedDisplayMasksInfoDataView;

class DebugBorderQuadStateDataView;

class CompositorRenderPassQuadStateDataView;

class SolidColorQuadStateDataView;

class SurfaceQuadStateDataView;

class TextureQuadStateDataView;

class TileQuadStateDataView;

class VideoHoleQuadStateDataView;

class SharedElementQuadStateDataView;

class DrawQuadDataView;

class DrawQuadStateDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::RoundedDisplayMasksInfoDataView> {
  using Data = ::viz::mojom::internal::RoundedDisplayMasksInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DebugBorderQuadStateDataView> {
  using Data = ::viz::mojom::internal::DebugBorderQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::CompositorRenderPassQuadStateDataView> {
  using Data = ::viz::mojom::internal::CompositorRenderPassQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SolidColorQuadStateDataView> {
  using Data = ::viz::mojom::internal::SolidColorQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SurfaceQuadStateDataView> {
  using Data = ::viz::mojom::internal::SurfaceQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TextureQuadStateDataView> {
  using Data = ::viz::mojom::internal::TextureQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::TileQuadStateDataView> {
  using Data = ::viz::mojom::internal::TileQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::VideoHoleQuadStateDataView> {
  using Data = ::viz::mojom::internal::VideoHoleQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::SharedElementQuadStateDataView> {
  using Data = ::viz::mojom::internal::SharedElementQuadState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DrawQuadDataView> {
  using Data = ::viz::mojom::internal::DrawQuad_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::DrawQuadStateDataView> {
  using Data = ::viz::mojom::internal::DrawQuadState_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class ProtectedVideoState : int32_t {
  
  kClear = 0,
  
  kSoftwareProtected = 1,
  
  kHardwareProtected = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ProtectedVideoState value);
inline bool IsKnownEnumValue(ProtectedVideoState value) {
  return internal::ProtectedVideoState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class OverlayPriority : int32_t {
  
  kLow = 0,
  
  kRegular = 1,
  
  kRequired = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, OverlayPriority value);
inline bool IsKnownEnumValue(OverlayPriority value) {
  return internal::OverlayPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class RoundedDisplayMasksInfoDataView {
 public:
  RoundedDisplayMasksInfoDataView() = default;

  RoundedDisplayMasksInfoDataView(
      internal::RoundedDisplayMasksInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_horizontally_positioned() const {
    return data_->is_horizontally_positioned;
  }
  inline void GetRadiiDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRadii(UserType* output) {
    
    auto* pointer = data_->radii.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::RoundedDisplayMasksInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DebugBorderQuadStateDataView {
 public:
  DebugBorderQuadStateDataView() = default;

  DebugBorderQuadStateDataView(
      internal::DebugBorderQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  int32_t width() const {
    return data_->width;
  }
 private:
  internal::DebugBorderQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CompositorRenderPassQuadStateDataView {
 public:
  CompositorRenderPassQuadStateDataView() = default;

  CompositorRenderPassQuadStateDataView(
      internal::CompositorRenderPassQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderPassIdDataView(
      ::viz::mojom::CompositorRenderPassIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderPassId(UserType* output) {
    
    auto* pointer = data_->render_pass_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorRenderPassIdDataView>(
        pointer, output, message_);
  }
  inline void GetMaskResourceIdDataView(
      ::viz::mojom::ResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskResourceId(UserType* output) {
    
    auto* pointer = data_->mask_resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetMaskUvRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskUvRect(UserType* output) {
    
    auto* pointer = data_->mask_uv_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetMaskTextureSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaskTextureSize(UserType* output) {
    
    auto* pointer = data_->mask_texture_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetFiltersScaleDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiltersScale(UserType* output) {
    
    auto* pointer = data_->filters_scale.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetFiltersOriginDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiltersOrigin(UserType* output) {
    
    auto* pointer = data_->filters_origin.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetTexCoordRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTexCoordRect(UserType* output) {
    
    auto* pointer = data_->tex_coord_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  bool force_anti_aliasing_off() const {
    return data_->force_anti_aliasing_off;
  }
  float backdrop_filter_quality() const {
    return data_->backdrop_filter_quality;
  }
  bool intersects_damage_under() const {
    return data_->intersects_damage_under;
  }
 private:
  internal::CompositorRenderPassQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SolidColorQuadStateDataView {
 public:
  SolidColorQuadStateDataView() = default;

  SolidColorQuadStateDataView(
      internal::SolidColorQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  bool force_anti_aliasing_off() const {
    return data_->force_anti_aliasing_off;
  }
 private:
  internal::SolidColorQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SurfaceQuadStateDataView {
 public:
  SurfaceQuadStateDataView() = default;

  SurfaceQuadStateDataView(
      internal::SurfaceQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSurfaceRangeDataView(
      ::viz::mojom::SurfaceRangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceRange(UserType* output) {
    
    auto* pointer = data_->surface_range.Get();
    return mojo::internal::Deserialize<::viz::mojom::SurfaceRangeDataView>(
        pointer, output, message_);
  }
  inline void GetDefaultBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultBackgroundColor(UserType* output) {
    
    auto* pointer = data_->default_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  bool stretch_content_to_fill_bounds() const {
    return data_->stretch_content_to_fill_bounds;
  }
  bool is_reflection() const {
    return data_->is_reflection;
  }
  bool allow_merge() const {
    return data_->allow_merge;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOverrideChildFilterQuality(UserType* output) const {
    if (!data_->override_child_filter_quality_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::cc::mojom::FilterQuality>(
        data_->override_child_filter_quality_$value, &output->emplace());
  }
  std::optional<::cc::mojom::FilterQuality> override_child_filter_quality() const {
    if (!data_->override_child_filter_quality_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cc::mojom::FilterQuality>(data_->override_child_filter_quality_$value));
  }
  inline void GetOverrideChildDynamicRangeLimitDataView(
      ::cc::mojom::DynamicRangeLimitDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverrideChildDynamicRangeLimit(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cc::mojom::DynamicRangeLimitDataView, UserType>(),
    "Attempting to read the optional `override_child_dynamic_range_limit` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOverrideChildDynamicRangeLimit` instead "
    "of `ReadOverrideChildDynamicRangeLimit if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->override_child_dynamic_range_limit.Get();
    return mojo::internal::Deserialize<::cc::mojom::DynamicRangeLimitDataView>(
        pointer, output, message_);
  }
 private:
  internal::SurfaceQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextureQuadStateDataView {
 public:
  TextureQuadStateDataView() = default;

  TextureQuadStateDataView(
      internal::TextureQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceIdDataView(
      ::viz::mojom::ResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceId(UserType* output) {
    
    auto* pointer = data_->resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetTexCoordRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTexCoordRect(UserType* output) {
    
    auto* pointer = data_->tex_coord_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  inline void GetDynamicRangeLimitDataView(
      ::cc::mojom::DynamicRangeLimitDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDynamicRangeLimit(UserType* output) {
    
    auto* pointer = data_->dynamic_range_limit.Get();
    return mojo::internal::Deserialize<::cc::mojom::DynamicRangeLimitDataView>(
        pointer, output, message_);
  }
  bool nearest_neighbor() const {
    return data_->nearest_neighbor;
  }
  bool secure_output_only() const {
    return data_->secure_output_only;
  }
  bool is_video_frame() const {
    return data_->is_video_frame;
  }
  bool force_rgbx() const {
    return data_->force_rgbx;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProtectedVideoType(UserType* output) const {
    auto data_value = data_->protected_video_type;
    return mojo::internal::Deserialize<::viz::mojom::ProtectedVideoState>(
        data_value, output);
  }
  ProtectedVideoState protected_video_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::ProtectedVideoState>(data_->protected_video_type));
  }
  inline void GetDamageRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDamageRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `damage_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDamageRect` instead "
    "of `ReadDamageRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->damage_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOverlayPriorityHint(UserType* output) const {
    auto data_value = data_->overlay_priority_hint;
    return mojo::internal::Deserialize<::viz::mojom::OverlayPriority>(
        data_value, output);
  }
  OverlayPriority overlay_priority_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::OverlayPriority>(data_->overlay_priority_hint));
  }
  inline void GetRoundedDisplayMasksInfoDataView(
      RoundedDisplayMasksInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoundedDisplayMasksInfo(UserType* output) {
    
    auto* pointer = data_->rounded_display_masks_info.Get();
    return mojo::internal::Deserialize<::viz::mojom::RoundedDisplayMasksInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextureQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TileQuadStateDataView {
 public:
  TileQuadStateDataView() = default;

  TileQuadStateDataView(
      internal::TileQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTexCoordRectDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTexCoordRect(UserType* output) {
    
    auto* pointer = data_->tex_coord_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetResourceIdDataView(
      ::viz::mojom::ResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceId(UserType* output) {
    
    auto* pointer = data_->resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ResourceIdDataView>(
        pointer, output, message_);
  }
  bool nearest_neighbor() const {
    return data_->nearest_neighbor;
  }
  bool force_anti_aliasing_off() const {
    return data_->force_anti_aliasing_off;
  }
 private:
  internal::TileQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoHoleQuadStateDataView {
 public:
  VideoHoleQuadStateDataView() = default;

  VideoHoleQuadStateDataView(
      internal::VideoHoleQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOverlayPlaneIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayPlaneId(UserType* output) {
    
    auto* pointer = data_->overlay_plane_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoHoleQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedElementQuadStateDataView {
 public:
  SharedElementQuadStateDataView() = default;

  SharedElementQuadStateDataView(
      internal::SharedElementQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementResourceIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElementResourceId(UserType* output) {
    
    auto* pointer = data_->element_resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedElementQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DrawQuadDataView {
 public:
  DrawQuadDataView() = default;

  DrawQuadDataView(
      internal::DrawQuad_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool needs_blending() const {
    return data_->needs_blending;
  }
  inline void GetSqsDataView(
      ::viz::mojom::SharedQuadStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSqs(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::SharedQuadStateDataView, UserType>(),
    "Attempting to read the optional `sqs` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSqs` instead "
    "of `ReadSqs if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sqs.Get();
    return mojo::internal::Deserialize<::viz::mojom::SharedQuadStateDataView>(
        pointer, output, message_);
  }
  inline void GetDrawQuadStateDataView(
      DrawQuadStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDrawQuadState(UserType* output) {
    
    auto* pointer = !data_->draw_quad_state.is_null() ? &data_->draw_quad_state : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::DrawQuadStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::DrawQuad_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DrawQuadStateDataView {
 public:
  using Tag = internal::DrawQuadState_Data::DrawQuadState_Tag;

  DrawQuadStateDataView() = default;

  DrawQuadStateDataView(
      internal::DrawQuadState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_debug_border_quad_state() const { return data_->tag == Tag::kDebugBorderQuadState; }
  inline void GetDebugBorderQuadStateDataView(
      DebugBorderQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDebugBorderQuadState(UserType* output) const {
    
    CHECK(is_debug_border_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::DebugBorderQuadStateDataView>(
        data_->data.f_debug_border_quad_state.Get(), output, message_);
  }
  bool is_render_pass_quad_state() const { return data_->tag == Tag::kRenderPassQuadState; }
  inline void GetRenderPassQuadStateDataView(
      CompositorRenderPassQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRenderPassQuadState(UserType* output) const {
    
    CHECK(is_render_pass_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::CompositorRenderPassQuadStateDataView>(
        data_->data.f_render_pass_quad_state.Get(), output, message_);
  }
  bool is_solid_color_quad_state() const { return data_->tag == Tag::kSolidColorQuadState; }
  inline void GetSolidColorQuadStateDataView(
      SolidColorQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSolidColorQuadState(UserType* output) const {
    
    CHECK(is_solid_color_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::SolidColorQuadStateDataView>(
        data_->data.f_solid_color_quad_state.Get(), output, message_);
  }
  bool is_surface_quad_state() const { return data_->tag == Tag::kSurfaceQuadState; }
  inline void GetSurfaceQuadStateDataView(
      SurfaceQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceQuadState(UserType* output) const {
    
    CHECK(is_surface_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::SurfaceQuadStateDataView>(
        data_->data.f_surface_quad_state.Get(), output, message_);
  }
  bool is_texture_quad_state() const { return data_->tag == Tag::kTextureQuadState; }
  inline void GetTextureQuadStateDataView(
      TextureQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTextureQuadState(UserType* output) const {
    
    CHECK(is_texture_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::TextureQuadStateDataView>(
        data_->data.f_texture_quad_state.Get(), output, message_);
  }
  bool is_tile_quad_state() const { return data_->tag == Tag::kTileQuadState; }
  inline void GetTileQuadStateDataView(
      TileQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTileQuadState(UserType* output) const {
    
    CHECK(is_tile_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::TileQuadStateDataView>(
        data_->data.f_tile_quad_state.Get(), output, message_);
  }
  bool is_video_hole_quad_state() const { return data_->tag == Tag::kVideoHoleQuadState; }
  inline void GetVideoHoleQuadStateDataView(
      VideoHoleQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVideoHoleQuadState(UserType* output) const {
    
    CHECK(is_video_hole_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::VideoHoleQuadStateDataView>(
        data_->data.f_video_hole_quad_state.Get(), output, message_);
  }
  bool is_shared_element_quad_state() const { return data_->tag == Tag::kSharedElementQuadState; }
  inline void GetSharedElementQuadStateDataView(
      SharedElementQuadStateDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedElementQuadState(UserType* output) const {
    
    CHECK(is_shared_element_quad_state());
    return mojo::internal::Deserialize<::viz::mojom::SharedElementQuadStateDataView>(
        data_->data.f_shared_element_quad_state.Get(), output, message_);
  }

 private:
  internal::DrawQuadState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_DATA_VIEW_H_