// services/viz/public/mojom/compositing/quads.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/quads.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/quads.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/quads.mojom-blink-import-headers.h"
#include "services/viz/public/mojom/compositing/quads.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace viz::mojom::blink {
RoundedDisplayMasksInfo::RoundedDisplayMasksInfo()
    : is_horizontally_positioned(),
      radii() {}

RoundedDisplayMasksInfo::RoundedDisplayMasksInfo(
    bool is_horizontally_positioned_in,
    ::blink::Vector<uint8_t> radii_in)
    : is_horizontally_positioned(std::move(is_horizontally_positioned_in)),
      radii(std::move(radii_in)) {}

RoundedDisplayMasksInfo::~RoundedDisplayMasksInfo() = default;

void RoundedDisplayMasksInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_horizontally_positioned"), this->is_horizontally_positioned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radii"), this->radii,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RoundedDisplayMasksInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugBorderQuadState::DebugBorderQuadState()
    : color(),
      width() {}

DebugBorderQuadState::DebugBorderQuadState(
    const ::SkColor4f& color_in,
    int32_t width_in)
    : color(std::move(color_in)),
      width(std::move(width_in)) {}

DebugBorderQuadState::~DebugBorderQuadState() = default;

void DebugBorderQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugBorderQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CompositorRenderPassQuadState::CompositorRenderPassQuadState()
    : render_pass_id(),
      mask_resource_id(),
      mask_uv_rect(),
      mask_texture_size(),
      filters_scale(),
      filters_origin(),
      tex_coord_rect(),
      force_anti_aliasing_off(),
      backdrop_filter_quality(),
      intersects_damage_under() {}

CompositorRenderPassQuadState::CompositorRenderPassQuadState(
    ::viz::mojom::blink::CompositorRenderPassIdPtr render_pass_id_in,
    ::viz::mojom::blink::ResourceIdPtr mask_resource_id_in,
    const ::gfx::RectF& mask_uv_rect_in,
    const ::gfx::Size& mask_texture_size_in,
    const ::gfx::Vector2dF& filters_scale_in,
    const ::gfx::PointF& filters_origin_in,
    const ::gfx::RectF& tex_coord_rect_in,
    bool force_anti_aliasing_off_in,
    float backdrop_filter_quality_in,
    bool intersects_damage_under_in)
    : render_pass_id(std::move(render_pass_id_in)),
      mask_resource_id(std::move(mask_resource_id_in)),
      mask_uv_rect(std::move(mask_uv_rect_in)),
      mask_texture_size(std::move(mask_texture_size_in)),
      filters_scale(std::move(filters_scale_in)),
      filters_origin(std::move(filters_origin_in)),
      tex_coord_rect(std::move(tex_coord_rect_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)),
      backdrop_filter_quality(std::move(backdrop_filter_quality_in)),
      intersects_damage_under(std::move(intersects_damage_under_in)) {}

CompositorRenderPassQuadState::~CompositorRenderPassQuadState() = default;

void CompositorRenderPassQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_pass_id"), this->render_pass_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::CompositorRenderPassIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_resource_id"), this->mask_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::ResourceIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_uv_rect"), this->mask_uv_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_texture_size"), this->mask_texture_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters_scale"), this->filters_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filters_origin"), this->filters_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tex_coord_rect"), this->tex_coord_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_anti_aliasing_off"), this->force_anti_aliasing_off,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backdrop_filter_quality"), this->backdrop_filter_quality,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "intersects_damage_under"), this->intersects_damage_under,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CompositorRenderPassQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SolidColorQuadState::SolidColorQuadState()
    : color(),
      force_anti_aliasing_off() {}

SolidColorQuadState::SolidColorQuadState(
    const ::SkColor4f& color_in,
    bool force_anti_aliasing_off_in)
    : color(std::move(color_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)) {}

SolidColorQuadState::~SolidColorQuadState() = default;

void SolidColorQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_anti_aliasing_off"), this->force_anti_aliasing_off,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SolidColorQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SurfaceQuadState::SurfaceQuadState()
    : surface_range(),
      default_background_color(),
      stretch_content_to_fill_bounds(),
      is_reflection(),
      allow_merge(),
      override_child_filter_quality(),
      override_child_dynamic_range_limit() {}

SurfaceQuadState::SurfaceQuadState(
    const ::viz::SurfaceRange& surface_range_in,
    const ::SkColor4f& default_background_color_in,
    bool stretch_content_to_fill_bounds_in,
    bool is_reflection_in,
    bool allow_merge_in,
    std::optional<::cc::mojom::blink::FilterQuality> override_child_filter_quality_in,
    ::cc::mojom::blink::DynamicRangeLimitPtr override_child_dynamic_range_limit_in)
    : surface_range(std::move(surface_range_in)),
      default_background_color(std::move(default_background_color_in)),
      stretch_content_to_fill_bounds(std::move(stretch_content_to_fill_bounds_in)),
      is_reflection(std::move(is_reflection_in)),
      allow_merge(std::move(allow_merge_in)),
      override_child_filter_quality(std::move(override_child_filter_quality_in)),
      override_child_dynamic_range_limit(std::move(override_child_dynamic_range_limit_in)) {}

SurfaceQuadState::~SurfaceQuadState() = default;

void SurfaceQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "surface_range"), this->surface_range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::SurfaceRange&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_background_color"), this->default_background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stretch_content_to_fill_bounds"), this->stretch_content_to_fill_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_reflection"), this->is_reflection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_merge"), this->allow_merge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "override_child_filter_quality"), this->override_child_filter_quality,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::cc::mojom::blink::FilterQuality>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "override_child_dynamic_range_limit"), this->override_child_dynamic_range_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::DynamicRangeLimitPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SurfaceQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextureQuadState::TextureQuadState()
    : resource_id(),
      tex_coord_rect(),
      background_color(),
      dynamic_range_limit(),
      nearest_neighbor(),
      secure_output_only(),
      is_video_frame(),
      force_rgbx(),
      protected_video_type(),
      damage_rect(),
      overlay_priority_hint(),
      rounded_display_masks_info() {}

TextureQuadState::TextureQuadState(
    ::viz::mojom::blink::ResourceIdPtr resource_id_in,
    const ::gfx::RectF& tex_coord_rect_in,
    const ::SkColor4f& background_color_in,
    ::cc::mojom::blink::DynamicRangeLimitPtr dynamic_range_limit_in,
    bool nearest_neighbor_in,
    bool secure_output_only_in,
    bool is_video_frame_in,
    bool force_rgbx_in,
    ProtectedVideoState protected_video_type_in,
    const std::optional<::gfx::Rect>& damage_rect_in,
    OverlayPriority overlay_priority_hint_in,
    RoundedDisplayMasksInfoPtr rounded_display_masks_info_in)
    : resource_id(std::move(resource_id_in)),
      tex_coord_rect(std::move(tex_coord_rect_in)),
      background_color(std::move(background_color_in)),
      dynamic_range_limit(std::move(dynamic_range_limit_in)),
      nearest_neighbor(std::move(nearest_neighbor_in)),
      secure_output_only(std::move(secure_output_only_in)),
      is_video_frame(std::move(is_video_frame_in)),
      force_rgbx(std::move(force_rgbx_in)),
      protected_video_type(std::move(protected_video_type_in)),
      damage_rect(std::move(damage_rect_in)),
      overlay_priority_hint(std::move(overlay_priority_hint_in)),
      rounded_display_masks_info(std::move(rounded_display_masks_info_in)) {}

TextureQuadState::~TextureQuadState() = default;

void TextureQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::ResourceIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tex_coord_rect"), this->tex_coord_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::SkColor4f&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dynamic_range_limit"), this->dynamic_range_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::mojom::blink::DynamicRangeLimitPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_neighbor"), this->nearest_neighbor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_output_only"), this->secure_output_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_video_frame"), this->is_video_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_rgbx"), this->force_rgbx,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_video_type"), this->protected_video_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProtectedVideoState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "damage_rect"), this->damage_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_priority_hint"), this->overlay_priority_hint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type OverlayPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rounded_display_masks_info"), this->rounded_display_masks_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RoundedDisplayMasksInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextureQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TileQuadState::TileQuadState()
    : tex_coord_rect(),
      resource_id(),
      nearest_neighbor(),
      force_anti_aliasing_off() {}

TileQuadState::TileQuadState(
    const ::gfx::RectF& tex_coord_rect_in,
    ::viz::mojom::blink::ResourceIdPtr resource_id_in,
    bool nearest_neighbor_in,
    bool force_anti_aliasing_off_in)
    : tex_coord_rect(std::move(tex_coord_rect_in)),
      resource_id(std::move(resource_id_in)),
      nearest_neighbor(std::move(nearest_neighbor_in)),
      force_anti_aliasing_off(std::move(force_anti_aliasing_off_in)) {}

TileQuadState::~TileQuadState() = default;

void TileQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tex_coord_rect"), this->tex_coord_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_id"), this->resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::ResourceIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nearest_neighbor"), this->nearest_neighbor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_anti_aliasing_off"), this->force_anti_aliasing_off,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TileQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoHoleQuadState::VideoHoleQuadState()
    : overlay_plane_id() {}

VideoHoleQuadState::VideoHoleQuadState(
    const ::base::UnguessableToken& overlay_plane_id_in)
    : overlay_plane_id(std::move(overlay_plane_id_in)) {}

VideoHoleQuadState::~VideoHoleQuadState() = default;

void VideoHoleQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overlay_plane_id"), this->overlay_plane_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoHoleQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedElementQuadState::SharedElementQuadState()
    : element_resource_id() {}

SharedElementQuadState::SharedElementQuadState(
    ::viz::mojom::blink::ViewTransitionElementResourceIdPtr element_resource_id_in)
    : element_resource_id(std::move(element_resource_id_in)) {}

SharedElementQuadState::~SharedElementQuadState() = default;

void SharedElementQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_resource_id"), this->element_resource_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::ViewTransitionElementResourceIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedElementQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DrawQuad::DrawQuad()
    : rect(),
      visible_rect(),
      needs_blending(),
      sqs(),
      draw_quad_state() {}

DrawQuad::DrawQuad(
    const ::gfx::Rect& rect_in,
    const ::gfx::Rect& visible_rect_in,
    bool needs_blending_in,
    ::viz::mojom::blink::SharedQuadStatePtr sqs_in,
    DrawQuadStatePtr draw_quad_state_in)
    : rect(std::move(rect_in)),
      visible_rect(std::move(visible_rect_in)),
      needs_blending(std::move(needs_blending_in)),
      sqs(std::move(sqs_in)),
      draw_quad_state(std::move(draw_quad_state_in)) {}

DrawQuad::~DrawQuad() = default;

void DrawQuad::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_blending"), this->needs_blending,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sqs"), this->sqs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::viz::mojom::blink::SharedQuadStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "draw_quad_state"), this->draw_quad_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DrawQuadStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DrawQuad::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DrawQuadStatePtr
DrawQuadState::NewDebugBorderQuadState(
    DebugBorderQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewRenderPassQuadState(
    CompositorRenderPassQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRenderPassQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewSolidColorQuadState(
    SolidColorQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSolidColorQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewSurfaceQuadState(
    SurfaceQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSurfaceQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewTextureQuadState(
    TextureQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTextureQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewTileQuadState(
    TileQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTileQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewVideoHoleQuadState(
    VideoHoleQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
      std::move(value));
}

DrawQuadStatePtr
DrawQuadState::NewSharedElementQuadState(
    SharedElementQuadStatePtr value) {
  return DrawQuadStatePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSharedElementQuadState)>,
      std::move(value));
}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
    DebugBorderQuadStatePtr value)
    : tag_(Tag::kDebugBorderQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kRenderPassQuadState)>,
    CompositorRenderPassQuadStatePtr value)
    : tag_(Tag::kRenderPassQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRenderPassQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorQuadState)>,
    SolidColorQuadStatePtr value)
    : tag_(Tag::kSolidColorQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSolidColorQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceQuadState)>,
    SurfaceQuadStatePtr value)
    : tag_(Tag::kSurfaceQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSurfaceQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextureQuadState)>,
    TextureQuadStatePtr value)
    : tag_(Tag::kTextureQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTextureQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kTileQuadState)>,
    TileQuadStatePtr value)
    : tag_(Tag::kTileQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTileQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
    VideoHoleQuadStatePtr value)
    : tag_(Tag::kVideoHoleQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
            std::move(value)) {}

DrawQuadState::DrawQuadState(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedElementQuadState)>,
    SharedElementQuadStatePtr value)
    : tag_(Tag::kSharedElementQuadState),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSharedElementQuadState)>,
            std::move(value)) {}
DrawQuadState::~DrawQuadState() {
  DestroyActive();
}

void DrawQuadState::set_debug_border_quad_state(DebugBorderQuadStatePtr debug_border_quad_state) {
  if (tag_ == Tag::kDebugBorderQuadState) {
    data_.debug_border_quad_state = std::move(debug_border_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kDebugBorderQuadState;
    new (&data_.debug_border_quad_state) DebugBorderQuadStatePtr(
        std::move(debug_border_quad_state));
  }
}

void DrawQuadState::set_render_pass_quad_state(CompositorRenderPassQuadStatePtr render_pass_quad_state) {
  if (tag_ == Tag::kRenderPassQuadState) {
    data_.render_pass_quad_state = std::move(render_pass_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kRenderPassQuadState;
    new (&data_.render_pass_quad_state) CompositorRenderPassQuadStatePtr(
        std::move(render_pass_quad_state));
  }
}

void DrawQuadState::set_solid_color_quad_state(SolidColorQuadStatePtr solid_color_quad_state) {
  if (tag_ == Tag::kSolidColorQuadState) {
    data_.solid_color_quad_state = std::move(solid_color_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kSolidColorQuadState;
    new (&data_.solid_color_quad_state) SolidColorQuadStatePtr(
        std::move(solid_color_quad_state));
  }
}

void DrawQuadState::set_surface_quad_state(SurfaceQuadStatePtr surface_quad_state) {
  if (tag_ == Tag::kSurfaceQuadState) {
    data_.surface_quad_state = std::move(surface_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kSurfaceQuadState;
    new (&data_.surface_quad_state) SurfaceQuadStatePtr(
        std::move(surface_quad_state));
  }
}

void DrawQuadState::set_texture_quad_state(TextureQuadStatePtr texture_quad_state) {
  if (tag_ == Tag::kTextureQuadState) {
    data_.texture_quad_state = std::move(texture_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kTextureQuadState;
    new (&data_.texture_quad_state) TextureQuadStatePtr(
        std::move(texture_quad_state));
  }
}

void DrawQuadState::set_tile_quad_state(TileQuadStatePtr tile_quad_state) {
  if (tag_ == Tag::kTileQuadState) {
    data_.tile_quad_state = std::move(tile_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kTileQuadState;
    new (&data_.tile_quad_state) TileQuadStatePtr(
        std::move(tile_quad_state));
  }
}

void DrawQuadState::set_video_hole_quad_state(VideoHoleQuadStatePtr video_hole_quad_state) {
  if (tag_ == Tag::kVideoHoleQuadState) {
    data_.video_hole_quad_state = std::move(video_hole_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kVideoHoleQuadState;
    new (&data_.video_hole_quad_state) VideoHoleQuadStatePtr(
        std::move(video_hole_quad_state));
  }
}

void DrawQuadState::set_shared_element_quad_state(SharedElementQuadStatePtr shared_element_quad_state) {
  if (tag_ == Tag::kSharedElementQuadState) {
    data_.shared_element_quad_state = std::move(shared_element_quad_state);
  } else {
    DestroyActive();
    tag_ = Tag::kSharedElementQuadState;
    new (&data_.shared_element_quad_state) SharedElementQuadStatePtr(
        std::move(shared_element_quad_state));
  }
}


DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDebugBorderQuadState)>,
    DebugBorderQuadStatePtr value)
    : debug_border_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRenderPassQuadState)>,
    CompositorRenderPassQuadStatePtr value)
    : render_pass_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSolidColorQuadState)>,
    SolidColorQuadStatePtr value)
    : solid_color_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSurfaceQuadState)>,
    SurfaceQuadStatePtr value)
    : surface_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTextureQuadState)>,
    TextureQuadStatePtr value)
    : texture_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTileQuadState)>,
    TileQuadStatePtr value)
    : tile_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kVideoHoleQuadState)>,
    VideoHoleQuadStatePtr value)
    : video_hole_quad_state(std::move(value)) {}

DrawQuadState::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSharedElementQuadState)>,
    SharedElementQuadStatePtr value)
    : shared_element_quad_state(std::move(value)) {}

void DrawQuadState::DestroyActive() {
  switch (tag_) {

    case Tag::kDebugBorderQuadState:
      std::destroy_at(&data_.debug_border_quad_state);
      break;
    case Tag::kRenderPassQuadState:
      std::destroy_at(&data_.render_pass_quad_state);
      break;
    case Tag::kSolidColorQuadState:
      std::destroy_at(&data_.solid_color_quad_state);
      break;
    case Tag::kSurfaceQuadState:
      std::destroy_at(&data_.surface_quad_state);
      break;
    case Tag::kTextureQuadState:
      std::destroy_at(&data_.texture_quad_state);
      break;
    case Tag::kTileQuadState:
      std::destroy_at(&data_.tile_quad_state);
      break;
    case Tag::kVideoHoleQuadState:
      std::destroy_at(&data_.video_hole_quad_state);
      break;
    case Tag::kSharedElementQuadState:
      std::destroy_at(&data_.shared_element_quad_state);
      break;
  }
}

bool DrawQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // viz::mojom::blink


namespace mojo {


// static
bool StructTraits<::viz::mojom::blink::RoundedDisplayMasksInfo::DataView, ::viz::mojom::blink::RoundedDisplayMasksInfoPtr>::Read(
    ::viz::mojom::blink::RoundedDisplayMasksInfo::DataView input,
    ::viz::mojom::blink::RoundedDisplayMasksInfoPtr* output) {
  bool success = true;
  ::viz::mojom::blink::RoundedDisplayMasksInfoPtr result(::viz::mojom::blink::RoundedDisplayMasksInfo::New());
  
      if (success)
        result->is_horizontally_positioned = input.is_horizontally_positioned();
      if (success && !input.ReadRadii(&result->radii))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::DebugBorderQuadState::DataView, ::viz::mojom::blink::DebugBorderQuadStatePtr>::Read(
    ::viz::mojom::blink::DebugBorderQuadState::DataView input,
    ::viz::mojom::blink::DebugBorderQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::DebugBorderQuadStatePtr result(::viz::mojom::blink::DebugBorderQuadState::New());
  
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success)
        result->width = input.width();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::CompositorRenderPassQuadState::DataView, ::viz::mojom::blink::CompositorRenderPassQuadStatePtr>::Read(
    ::viz::mojom::blink::CompositorRenderPassQuadState::DataView input,
    ::viz::mojom::blink::CompositorRenderPassQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::CompositorRenderPassQuadStatePtr result(::viz::mojom::blink::CompositorRenderPassQuadState::New());
  
      if (success && !input.ReadRenderPassId(&result->render_pass_id))
        success = false;
      if (success && !input.ReadMaskResourceId(&result->mask_resource_id))
        success = false;
      if (success && !input.ReadMaskUvRect(&result->mask_uv_rect))
        success = false;
      if (success && !input.ReadMaskTextureSize(&result->mask_texture_size))
        success = false;
      if (success && !input.ReadFiltersScale(&result->filters_scale))
        success = false;
      if (success && !input.ReadFiltersOrigin(&result->filters_origin))
        success = false;
      if (success && !input.ReadTexCoordRect(&result->tex_coord_rect))
        success = false;
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
      if (success)
        result->backdrop_filter_quality = input.backdrop_filter_quality();
      if (success)
        result->intersects_damage_under = input.intersects_damage_under();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::SolidColorQuadState::DataView, ::viz::mojom::blink::SolidColorQuadStatePtr>::Read(
    ::viz::mojom::blink::SolidColorQuadState::DataView input,
    ::viz::mojom::blink::SolidColorQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::SolidColorQuadStatePtr result(::viz::mojom::blink::SolidColorQuadState::New());
  
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::SurfaceQuadState::DataView, ::viz::mojom::blink::SurfaceQuadStatePtr>::Read(
    ::viz::mojom::blink::SurfaceQuadState::DataView input,
    ::viz::mojom::blink::SurfaceQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::SurfaceQuadStatePtr result(::viz::mojom::blink::SurfaceQuadState::New());
  
      if (success && !input.ReadSurfaceRange(&result->surface_range))
        success = false;
      if (success && !input.ReadDefaultBackgroundColor(&result->default_background_color))
        success = false;
      if (success)
        result->stretch_content_to_fill_bounds = input.stretch_content_to_fill_bounds();
      if (success)
        result->is_reflection = input.is_reflection();
      if (success)
        result->allow_merge = input.allow_merge();
      if (success && !input.ReadOverrideChildFilterQuality(&result->override_child_filter_quality)) {
        success = false;
      }
      if (success && !input.ReadOverrideChildDynamicRangeLimit(&result->override_child_dynamic_range_limit))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::TextureQuadState::DataView, ::viz::mojom::blink::TextureQuadStatePtr>::Read(
    ::viz::mojom::blink::TextureQuadState::DataView input,
    ::viz::mojom::blink::TextureQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::TextureQuadStatePtr result(::viz::mojom::blink::TextureQuadState::New());
  
      if (success && !input.ReadResourceId(&result->resource_id))
        success = false;
      if (success && !input.ReadTexCoordRect(&result->tex_coord_rect))
        success = false;
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadDynamicRangeLimit(&result->dynamic_range_limit))
        success = false;
      if (success)
        result->nearest_neighbor = input.nearest_neighbor();
      if (success)
        result->secure_output_only = input.secure_output_only();
      if (success)
        result->is_video_frame = input.is_video_frame();
      if (success)
        result->force_rgbx = input.force_rgbx();
      if (success && !input.ReadProtectedVideoType(&result->protected_video_type))
        success = false;
      if (success && !input.ReadDamageRect(&result->damage_rect))
        success = false;
      if (success && !input.ReadOverlayPriorityHint(&result->overlay_priority_hint))
        success = false;
      if (success && !input.ReadRoundedDisplayMasksInfo(&result->rounded_display_masks_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::TileQuadState::DataView, ::viz::mojom::blink::TileQuadStatePtr>::Read(
    ::viz::mojom::blink::TileQuadState::DataView input,
    ::viz::mojom::blink::TileQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::TileQuadStatePtr result(::viz::mojom::blink::TileQuadState::New());
  
      if (success && !input.ReadTexCoordRect(&result->tex_coord_rect))
        success = false;
      if (success && !input.ReadResourceId(&result->resource_id))
        success = false;
      if (success)
        result->nearest_neighbor = input.nearest_neighbor();
      if (success)
        result->force_anti_aliasing_off = input.force_anti_aliasing_off();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::VideoHoleQuadState::DataView, ::viz::mojom::blink::VideoHoleQuadStatePtr>::Read(
    ::viz::mojom::blink::VideoHoleQuadState::DataView input,
    ::viz::mojom::blink::VideoHoleQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::VideoHoleQuadStatePtr result(::viz::mojom::blink::VideoHoleQuadState::New());
  
      if (success && !input.ReadOverlayPlaneId(&result->overlay_plane_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::SharedElementQuadState::DataView, ::viz::mojom::blink::SharedElementQuadStatePtr>::Read(
    ::viz::mojom::blink::SharedElementQuadState::DataView input,
    ::viz::mojom::blink::SharedElementQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::blink::SharedElementQuadStatePtr result(::viz::mojom::blink::SharedElementQuadState::New());
  
      if (success && !input.ReadElementResourceId(&result->element_resource_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::blink::DrawQuad::DataView, ::viz::mojom::blink::DrawQuadPtr>::Read(
    ::viz::mojom::blink::DrawQuad::DataView input,
    ::viz::mojom::blink::DrawQuadPtr* output) {
  bool success = true;
  ::viz::mojom::blink::DrawQuadPtr result(::viz::mojom::blink::DrawQuad::New());
  
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success)
        result->needs_blending = input.needs_blending();
      if (success && !input.ReadSqs(&result->sqs))
        success = false;
      if (success && !input.ReadDrawQuadState(&result->draw_quad_state))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::blink::DrawQuadState::DataView, ::viz::mojom::blink::DrawQuadStatePtr>::Read(
    ::viz::mojom::blink::DrawQuadState::DataView input,
    ::viz::mojom::blink::DrawQuadStatePtr* output) {
  using UnionType = ::viz::mojom::blink::DrawQuadState;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kDebugBorderQuadState: {
      ::viz::mojom::blink::DebugBorderQuadStatePtr result_debug_border_quad_state{};
      if (!input.ReadDebugBorderQuadState(&result_debug_border_quad_state))
        return false;

      *output = UnionType::NewDebugBorderQuadState(
          std::move(result_debug_border_quad_state));
      break;
    }
    case Tag::kRenderPassQuadState: {
      ::viz::mojom::blink::CompositorRenderPassQuadStatePtr result_render_pass_quad_state{};
      if (!input.ReadRenderPassQuadState(&result_render_pass_quad_state))
        return false;

      *output = UnionType::NewRenderPassQuadState(
          std::move(result_render_pass_quad_state));
      break;
    }
    case Tag::kSolidColorQuadState: {
      ::viz::mojom::blink::SolidColorQuadStatePtr result_solid_color_quad_state{};
      if (!input.ReadSolidColorQuadState(&result_solid_color_quad_state))
        return false;

      *output = UnionType::NewSolidColorQuadState(
          std::move(result_solid_color_quad_state));
      break;
    }
    case Tag::kSurfaceQuadState: {
      ::viz::mojom::blink::SurfaceQuadStatePtr result_surface_quad_state{};
      if (!input.ReadSurfaceQuadState(&result_surface_quad_state))
        return false;

      *output = UnionType::NewSurfaceQuadState(
          std::move(result_surface_quad_state));
      break;
    }
    case Tag::kTextureQuadState: {
      ::viz::mojom::blink::TextureQuadStatePtr result_texture_quad_state{};
      if (!input.ReadTextureQuadState(&result_texture_quad_state))
        return false;

      *output = UnionType::NewTextureQuadState(
          std::move(result_texture_quad_state));
      break;
    }
    case Tag::kTileQuadState: {
      ::viz::mojom::blink::TileQuadStatePtr result_tile_quad_state{};
      if (!input.ReadTileQuadState(&result_tile_quad_state))
        return false;

      *output = UnionType::NewTileQuadState(
          std::move(result_tile_quad_state));
      break;
    }
    case Tag::kVideoHoleQuadState: {
      ::viz::mojom::blink::VideoHoleQuadStatePtr result_video_hole_quad_state{};
      if (!input.ReadVideoHoleQuadState(&result_video_hole_quad_state))
        return false;

      *output = UnionType::NewVideoHoleQuadState(
          std::move(result_video_hole_quad_state));
      break;
    }
    case Tag::kSharedElementQuadState: {
      ::viz::mojom::blink::SharedElementQuadStatePtr result_shared_element_quad_state{};
      if (!input.ReadSharedElementQuadState(&result_shared_element_quad_state))
        return false;

      *output = UnionType::NewSharedElementQuadState(
          std::move(result_shared_element_quad_state));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom::blink {




}  // viz::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif