// services/viz/public/mojom/compositing/layer_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* TransferableUIResourceRequest_TypeToStringHelper(TransferableUIResourceRequest_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TransferableUIResourceRequest_Type::kCreate:
      return "kCreate";
    case TransferableUIResourceRequest_Type::kDelete:
      return "kDelete";
    default:
      return nullptr;
  }
}

std::string TransferableUIResourceRequest_TypeToString(TransferableUIResourceRequest_Type value) {
  const char *str = TransferableUIResourceRequest_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TransferableUIResourceRequest_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TransferableUIResourceRequest_Type value) {
  return os << TransferableUIResourceRequest_TypeToString(value);
}

namespace internal {


// static
bool TransferableUIResourceRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransferableUIResourceRequest_Data* object =
      static_cast<const TransferableUIResourceRequest_Data*>(data);


  if (!::viz::mojom::internal::TransferableUIResourceRequest_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uid, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->transferable_resource, validation_context))
    return false;

  return true;
}

TransferableUIResourceRequest_Data::TransferableUIResourceRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerTreeUpdate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 320, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerTreeUpdate_Data* object =
      static_cast<const LayerTreeUpdate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->begin_frame_args, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->begin_frame_args, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selection, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->selection, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_viewport, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_viewport, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_color_spaces, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_color_spaces, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->local_surface_id_from_parent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_local_surface_id, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->current_local_surface_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->target_local_surface_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->viewport_damage_rect, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->viewport_damage_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_state, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->debug_state, validation_context))
    return false;


  if (!::gfx::mojom::internal::OverlayTransform_Data
        ::Validate(object->display_transform_hint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_controls_params, 30, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_controls_params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->browser_controls_offset_tag_modifications, 31, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->browser_controls_offset_tag_modifications, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ui_resource_requests, 34, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ui_resource_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ui_resource_requests, validation_context,
                                         &ui_resource_requests_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layers, 35, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& layers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->layers, validation_context,
                                         &layers_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& layer_order_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->layer_order, validation_context,
                                         &layer_order_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->transform_tree_update, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scroll_tree_update, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transform_nodes, 39, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& transform_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->transform_nodes, validation_context,
                                         &transform_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clip_nodes, 40, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& clip_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->clip_nodes, validation_context,
                                         &clip_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->effect_nodes, 41, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& effect_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->effect_nodes, validation_context,
                                         &effect_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scroll_nodes, 42, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scroll_nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scroll_nodes, validation_context,
                                         &scroll_nodes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tilings, 47, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tilings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tilings, validation_context,
                                         &tilings_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& surface_ranges_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->surface_ranges, validation_context,
                                         &surface_ranges_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& view_transition_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->view_transition_requests, validation_context,
                                         &view_transition_requests_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& animation_timelines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->animation_timelines, validation_context,
                                         &animation_timelines_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& removed_animation_timelines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_animation_timelines, validation_context,
                                         &removed_animation_timelines_validate_params)) {
    return false;
  }

  return true;
}

LayerTreeUpdate_Data::LayerTreeUpdate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PendingLayerContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PendingLayerContext_Data* object =
      static_cast<const PendingLayerContext_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PendingLayerContext_Data::PendingLayerContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_SetVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_SetVisible_Params_Data* object =
      static_cast<const LayerContext_SetVisible_Params_Data*>(data);

  return true;
}

LayerContext_SetVisible_Params_Data::LayerContext_SetVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_UpdateDisplayTree_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_UpdateDisplayTree_Params_Data* object =
      static_cast<const LayerContext_UpdateDisplayTree_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update, validation_context))
    return false;

  return true;
}

LayerContext_UpdateDisplayTree_Params_Data::LayerContext_UpdateDisplayTree_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContext_UpdateDisplayTiling_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContext_UpdateDisplayTiling_Params_Data* object =
      static_cast<const LayerContext_UpdateDisplayTiling_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tiling, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tiling, validation_context))
    return false;

  return true;
}

LayerContext_UpdateDisplayTiling_Params_Data::LayerContext_UpdateDisplayTiling_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContextClient_OnRequestCommitForFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContextClient_OnRequestCommitForFrame_Params_Data* object =
      static_cast<const LayerContextClient_OnRequestCommitForFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->args, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->args, validation_context))
    return false;

  return true;
}

LayerContextClient_OnRequestCommitForFrame_Params_Data::LayerContextClient_OnRequestCommitForFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LayerContextClient_OnTilingsReadyForCleanup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LayerContextClient_OnTilingsReadyForCleanup_Params_Data* object =
      static_cast<const LayerContextClient_OnTilingsReadyForCleanup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tiling_scales_to_clean_up, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tiling_scales_to_clean_up_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tiling_scales_to_clean_up, validation_context,
                                         &tiling_scales_to_clean_up_validate_params)) {
    return false;
  }

  return true;
}

LayerContextClient_OnTilingsReadyForCleanup_Params_Data::LayerContextClient_OnTilingsReadyForCleanup_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::TransferableUIResourceRequest_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::TransferableUIResourceRequest_Type value) {
  return std::move(context).WriteString(::viz::mojom::TransferableUIResourceRequest_TypeToString(value));
}

} // namespace perfetto