// services/viz/public/mojom/compositing/layer.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "cc/mojom/element_id.mojom-shared-internal.h"
#include "cc/mojom/hit_test_opaqueness.mojom-shared-internal.h"
#include "cc/mojom/layer_type.mojom-shared-internal.h"
#include "cc/mojom/paint_flags.mojom-shared-internal.h"
#include "cc/mojom/render_surface_reason.mojom-shared-internal.h"
#include "cc/mojom/synced_scroll_offset.mojom-shared-internal.h"
#include "cc/mojom/ui_resource_id.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor4f.mojom-shared-internal.h"
#include "skia/public/mojom/skpath.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared-internal.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared-internal.h"
#include "ui/gfx/mojom/transform.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace viz::mojom {
namespace internal {
class RareProperties_Data;
class MirrorLayerExtra_Data;
class SurfaceLayerExtra_Data;
class TextureLayerExtra_Data;
class UIResourceLayerExtra_Data;
class TileDisplayLayerExtra_Data;
class ScrollbarLayerBaseExtra_Data;
class NinePatchThumbScrollbarLayerExtra_Data;
class PaintedScrollbarLayerExtra_Data;
class SolidColorScrollbarLayerExtra_Data;
class ViewTransitionContentLayerExtra_Data;
class NinePatchLayerExtra_Data;
class Layer_Data;
class AnchorPositionScrollData_Data;
class StickyPositionNodeData_Data;
class TransformTreeUpdate_Data;
class TransformNode_Data;
class ClipNode_Data;
class EffectNode_Data;
class ScrollTreeUpdate_Data;
class ScrollNode_Data;
class LayerExtra_Data;

#pragma pack(push, 1)


class  LayerExtra_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  LayerExtra_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~LayerExtra_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<LayerExtra_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class LayerExtra_Tag : uint32_t {

    
    kMirrorLayerExtra,
    
    kNinePatchThumbScrollbarLayerExtra,
    
    kPaintedScrollbarLayerExtra,
    
    kSolidColorScrollbarLayerExtra,
    
    kSurfaceLayerExtra,
    
    kTextureLayerExtra,
    
    kUiResourceLayerExtra,
    
    kTileDisplayLayerExtra,
    
    kViewTransitionContentLayerExtra,
    
    kNinePatchLayerExtra,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::MirrorLayerExtra_Data> f_mirror_layer_extra;
    mojo::internal::Pointer<internal::NinePatchThumbScrollbarLayerExtra_Data> f_nine_patch_thumb_scrollbar_layer_extra;
    mojo::internal::Pointer<internal::PaintedScrollbarLayerExtra_Data> f_painted_scrollbar_layer_extra;
    mojo::internal::Pointer<internal::SolidColorScrollbarLayerExtra_Data> f_solid_color_scrollbar_layer_extra;
    mojo::internal::Pointer<internal::SurfaceLayerExtra_Data> f_surface_layer_extra;
    mojo::internal::Pointer<internal::TextureLayerExtra_Data> f_texture_layer_extra;
    mojo::internal::Pointer<internal::UIResourceLayerExtra_Data> f_ui_resource_layer_extra;
    mojo::internal::Pointer<internal::TileDisplayLayerExtra_Data> f_tile_display_layer_extra;
    mojo::internal::Pointer<internal::ViewTransitionContentLayerExtra_Data> f_view_transition_content_layer_extra;
    mojo::internal::Pointer<internal::NinePatchLayerExtra_Data> f_nine_patch_layer_extra;
    uint64_t unknown;
  };

  uint32_t size;
  LayerExtra_Tag tag;
  Union_ data;
};
static_assert(sizeof(LayerExtra_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(LayerExtra_Data)");
class  RareProperties_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t filter_quality;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::cc::mojom::internal::DynamicRangeLimit_Data> dynamic_range_limit;
  mojo::internal::Pointer<::viz::mojom::internal::RegionCaptureBounds_Data> capture_bounds;

 private:
  friend class mojo::internal::MessageFragment<RareProperties_Data>;

  RareProperties_Data();
  ~RareProperties_Data() = delete;
};
static_assert(sizeof(RareProperties_Data) == 32,
              "Bad sizeof(RareProperties_Data)");
// Used by RareProperties::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RareProperties_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RareProperties_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RareProperties_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RareProperties_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RareProperties_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MirrorLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t mirrored_layer_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MirrorLayerExtra_Data>;

  MirrorLayerExtra_Data();
  ~MirrorLayerExtra_Data() = delete;
};
static_assert(sizeof(MirrorLayerExtra_Data) == 16,
              "Bad sizeof(MirrorLayerExtra_Data)");
// Used by MirrorLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MirrorLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MirrorLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MirrorLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MirrorLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MirrorLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SurfaceLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::SurfaceRange_Data> surface_range;
  uint8_t deadline_in_frames_$flag : 1;
  uint8_t stretch_content_to_fill_bounds : 1;
  uint8_t surface_hit_testable : 1;
  uint8_t has_pointer_events_none : 1;
  uint8_t is_reflection : 1;
  uint8_t will_draw_needs_reset : 1;
  uint8_t override_child_paint_flags : 1;
  uint8_t pad7_[3];
  uint32_t deadline_in_frames_$value;

 private:
  friend class mojo::internal::MessageFragment<SurfaceLayerExtra_Data>;

  SurfaceLayerExtra_Data();
  ~SurfaceLayerExtra_Data() = delete;
};
static_assert(sizeof(SurfaceLayerExtra_Data) == 24,
              "Bad sizeof(SurfaceLayerExtra_Data)");
// Used by SurfaceLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SurfaceLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SurfaceLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SurfaceLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SurfaceLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SurfaceLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TextureLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t blend_background_color : 1;
  uint8_t force_texture_to_opaque : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_top_left;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_bottom_right;
  mojo::internal::Pointer<::viz::mojom::internal::TransferableResource_Data> transferable_resource;

 private:
  friend class mojo::internal::MessageFragment<TextureLayerExtra_Data>;

  TextureLayerExtra_Data();
  ~TextureLayerExtra_Data() = delete;
};
static_assert(sizeof(TextureLayerExtra_Data) == 40,
              "Bad sizeof(TextureLayerExtra_Data)");
// Used by TextureLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TextureLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TextureLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TextureLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TextureLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TextureLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UIResourceLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> ui_resource_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> image_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_top_left;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_bottom_right;

 private:
  friend class mojo::internal::MessageFragment<UIResourceLayerExtra_Data>;

  UIResourceLayerExtra_Data();
  ~UIResourceLayerExtra_Data() = delete;
};
static_assert(sizeof(UIResourceLayerExtra_Data) == 40,
              "Bad sizeof(UIResourceLayerExtra_Data)");
// Used by UIResourceLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UIResourceLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UIResourceLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UIResourceLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UIResourceLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UIResourceLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TileDisplayLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor4f_Data> solid_color;
  uint8_t is_backdrop_filter_mask : 1;
  uint8_t is_directly_composited_image : 1;
  uint8_t nearest_neighbor : 1;
  uint8_t pad3_[3];
  int32_t content_color_usage;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> recorded_bounds;
  mojo::internal::Pointer<mojo::internal::Array_Data<float>> proposed_tiling_scales_for_deletion;

 private:
  friend class mojo::internal::MessageFragment<TileDisplayLayerExtra_Data>;

  TileDisplayLayerExtra_Data();
  ~TileDisplayLayerExtra_Data() = delete;
};
static_assert(sizeof(TileDisplayLayerExtra_Data) == 40,
              "Bad sizeof(TileDisplayLayerExtra_Data)");
// Used by TileDisplayLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TileDisplayLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TileDisplayLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TileDisplayLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TileDisplayLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TileDisplayLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ScrollbarLayerBaseExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> scroll_element_id;
  uint8_t is_overlay_scrollbar : 1;
  uint8_t is_web_test : 1;
  uint8_t is_horizontal_orientation : 1;
  uint8_t is_left_side_vertical_scrollbar : 1;
  uint8_t has_find_in_page_tickmarks : 1;
  uint8_t pad5_[3];
  float thumb_thickness_scale_factor;
  float current_pos;
  float clip_layer_length;
  float scroll_layer_length;
  float vertical_adjust;

 private:
  friend class mojo::internal::MessageFragment<ScrollbarLayerBaseExtra_Data>;

  ScrollbarLayerBaseExtra_Data();
  ~ScrollbarLayerBaseExtra_Data() = delete;
};
static_assert(sizeof(ScrollbarLayerBaseExtra_Data) == 40,
              "Bad sizeof(ScrollbarLayerBaseExtra_Data)");
// Used by ScrollbarLayerBaseExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollbarLayerBaseExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollbarLayerBaseExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollbarLayerBaseExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScrollbarLayerBaseExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollbarLayerBaseExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NinePatchThumbScrollbarLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ScrollbarLayerBaseExtra_Data> scrollbar_base_extra;
  int32_t thumb_thickness;
  int32_t thumb_length;
  int32_t track_start;
  int32_t track_length;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> image_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> aperture;
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> thumb_ui_resource_id;
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> track_and_buttons_ui_resource_id;

 private:
  friend class mojo::internal::MessageFragment<NinePatchThumbScrollbarLayerExtra_Data>;

  NinePatchThumbScrollbarLayerExtra_Data();
  ~NinePatchThumbScrollbarLayerExtra_Data() = delete;
};
static_assert(sizeof(NinePatchThumbScrollbarLayerExtra_Data) == 64,
              "Bad sizeof(NinePatchThumbScrollbarLayerExtra_Data)");
// Used by NinePatchThumbScrollbarLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<NinePatchThumbScrollbarLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NinePatchThumbScrollbarLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PaintedScrollbarLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ScrollbarLayerBaseExtra_Data> scrollbar_base_extra;
  float internal_contents_scale;
  uint8_t jump_on_track_click : 1;
  uint8_t supports_drag_snap_back : 1;
  uint8_t uses_nine_patch_track_and_buttons : 1;
  uint8_t pad4_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> internal_content_bounds;
  int32_t thumb_thickness;
  int32_t thumb_length;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> back_button_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> forward_button_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> track_rect;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor4f_Data> thumb_color;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> track_and_buttons_image_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> track_and_buttons_aperture;
  float painted_opacity;
  uint8_t pad14_[4];
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> track_and_buttons_ui_resource_id;
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> thumb_ui_resource_id;

 private:
  friend class mojo::internal::MessageFragment<PaintedScrollbarLayerExtra_Data>;

  PaintedScrollbarLayerExtra_Data();
  ~PaintedScrollbarLayerExtra_Data() = delete;
};
static_assert(sizeof(PaintedScrollbarLayerExtra_Data) == 112,
              "Bad sizeof(PaintedScrollbarLayerExtra_Data)");
// Used by PaintedScrollbarLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PaintedScrollbarLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PaintedScrollbarLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PaintedScrollbarLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PaintedScrollbarLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PaintedScrollbarLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SolidColorScrollbarLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ScrollbarLayerBaseExtra_Data> scrollbar_base_extra;
  int32_t thumb_thickness;
  int32_t track_start;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor4f_Data> color;

 private:
  friend class mojo::internal::MessageFragment<SolidColorScrollbarLayerExtra_Data>;

  SolidColorScrollbarLayerExtra_Data();
  ~SolidColorScrollbarLayerExtra_Data() = delete;
};
static_assert(sizeof(SolidColorScrollbarLayerExtra_Data) == 32,
              "Bad sizeof(SolidColorScrollbarLayerExtra_Data)");
// Used by SolidColorScrollbarLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SolidColorScrollbarLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SolidColorScrollbarLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SolidColorScrollbarLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SolidColorScrollbarLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SolidColorScrollbarLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ViewTransitionContentLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::viz::mojom::internal::ViewTransitionElementResourceId_Data> resource_id;
  uint8_t is_live_content_layer : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> max_extents_rect;

 private:
  friend class mojo::internal::MessageFragment<ViewTransitionContentLayerExtra_Data>;

  ViewTransitionContentLayerExtra_Data();
  ~ViewTransitionContentLayerExtra_Data() = delete;
};
static_assert(sizeof(ViewTransitionContentLayerExtra_Data) == 32,
              "Bad sizeof(ViewTransitionContentLayerExtra_Data)");
// Used by ViewTransitionContentLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ViewTransitionContentLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ViewTransitionContentLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ViewTransitionContentLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ViewTransitionContentLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ViewTransitionContentLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  NinePatchLayerExtra_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> image_aperture;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> border;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> layer_occlusion;
  uint8_t fill_center : 1;
  uint8_t pad3_[7];
  mojo::internal::Pointer<::cc::mojom::internal::UIResourceId_Data> ui_resource_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> image_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_top_left;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> uv_bottom_right;

 private:
  friend class mojo::internal::MessageFragment<NinePatchLayerExtra_Data>;

  NinePatchLayerExtra_Data();
  ~NinePatchLayerExtra_Data() = delete;
};
static_assert(sizeof(NinePatchLayerExtra_Data) == 72,
              "Bad sizeof(NinePatchLayerExtra_Data)");
// Used by NinePatchLayerExtra::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct NinePatchLayerExtra_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  NinePatchLayerExtra_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~NinePatchLayerExtra_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<NinePatchLayerExtra_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    NinePatchLayerExtra_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Layer_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t id;
  int32_t type;
  uint8_t contents_opaque : 1;
  uint8_t contents_opaque_for_text : 1;
  uint8_t is_drawable : 1;
  uint8_t layer_property_changed_not_from_property_trees : 1;
  uint8_t layer_property_changed_from_property_trees : 1;
  uint8_t should_check_backface_visibility : 1;
  uint8_t pad7_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> bounds;
  int32_t hit_test_opaqueness;
  int32_t transform_tree_index;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor4f_Data> background_color;
  mojo::internal::Pointer<::skia::mojom::internal::SkColor4f_Data> safe_opaque_background_color;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> update_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> offset_to_transform_parent;
  int32_t clip_tree_index;
  int32_t effect_tree_index;
  int32_t scroll_tree_index;
  uint8_t pad18_[4];
  mojo::internal::Pointer<internal::RareProperties_Data> rare_properties;
  internal::LayerExtra_Data layer_extra;

 private:
  friend class mojo::internal::MessageFragment<Layer_Data>;

  Layer_Data();
  ~Layer_Data() = delete;
};
static_assert(sizeof(Layer_Data) == 120,
              "Bad sizeof(Layer_Data)");
// Used by Layer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Layer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Layer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Layer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Layer_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Layer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AnchorPositionScrollData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data>>> adjustment_container_ids;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2d_Data> accumulated_scroll_origin;
  uint8_t needs_scroll_adjustment_in_x : 1;
  uint8_t needs_scroll_adjustment_in_y : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<AnchorPositionScrollData_Data>;

  AnchorPositionScrollData_Data();
  ~AnchorPositionScrollData_Data() = delete;
};
static_assert(sizeof(AnchorPositionScrollData_Data) == 32,
              "Bad sizeof(AnchorPositionScrollData_Data)");
// Used by AnchorPositionScrollData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AnchorPositionScrollData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AnchorPositionScrollData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AnchorPositionScrollData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AnchorPositionScrollData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AnchorPositionScrollData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  StickyPositionNodeData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t scroll_ancestor;
  uint8_t is_anchored_left : 1;
  uint8_t is_anchored_right : 1;
  uint8_t is_anchored_top : 1;
  uint8_t is_anchored_bottom : 1;
  uint8_t pad4_[3];
  float left_offset;
  float right_offset;
  float top_offset;
  float bottom_offset;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> constraint_box_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> scroll_container_relative_sticky_box_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> scroll_container_relative_containing_block_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> pixel_snap_offset;
  int32_t nearest_node_shifting_sticky_box;
  int32_t nearest_node_shifting_containing_block;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> total_sticky_box_sticky_offset;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> total_containing_block_sticky_offset;

 private:
  friend class mojo::internal::MessageFragment<StickyPositionNodeData_Data>;

  StickyPositionNodeData_Data();
  ~StickyPositionNodeData_Data() = delete;
};
static_assert(sizeof(StickyPositionNodeData_Data) == 88,
              "Bad sizeof(StickyPositionNodeData_Data)");
// Used by StickyPositionNodeData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct StickyPositionNodeData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  StickyPositionNodeData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~StickyPositionNodeData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<StickyPositionNodeData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    StickyPositionNodeData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TransformTreeUpdate_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  float page_scale_factor;
  float device_scale_factor;
  float device_transform_scale_factor;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> nodes_affected_by_outer_viewport_bounds_delta;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> nodes_affected_by_safe_area_bottom;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::StickyPositionNodeData_Data>>> sticky_position_data;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AnchorPositionScrollData_Data>>> anchor_position_scroll_data;

 private:
  friend class mojo::internal::MessageFragment<TransformTreeUpdate_Data>;

  TransformTreeUpdate_Data();
  ~TransformTreeUpdate_Data() = delete;
};
static_assert(sizeof(TransformTreeUpdate_Data) == 56,
              "Bad sizeof(TransformTreeUpdate_Data)");
// Used by TransformTreeUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TransformTreeUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TransformTreeUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TransformTreeUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TransformTreeUpdate_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TransformTreeUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TransformNode_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t parent_id;
  int32_t parent_frame_id;
  uint8_t sticky_position_constraint_id_$flag : 1;
  uint8_t anchor_position_scroll_data_id_$flag : 1;
  uint8_t has_potential_animation : 1;
  uint8_t is_currently_animating : 1;
  uint8_t flattens_inherited_transform : 1;
  uint8_t scrolls : 1;
  uint8_t should_undo_overscroll : 1;
  uint8_t should_be_snapped : 1;
  uint8_t moved_by_outer_viewport_bounds_delta_y : 1;
  uint8_t in_subtree_of_page_scale_layer : 1;
  uint8_t transform_changed : 1;
  uint8_t delegates_to_parent_for_backface : 1;
  uint8_t will_change_transform : 1;
  uint8_t node_and_ancestors_are_animated_or_invertible : 1;
  uint8_t is_invertible : 1;
  uint8_t ancestors_are_invertible : 1;
  uint8_t node_and_ancestors_are_flat : 1;
  uint8_t node_or_ancestors_will_change_transform : 1;
  uint8_t moved_by_safe_area_bottom : 1;
  uint8_t pad21_[1];
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> local;
  mojo::internal::Pointer<::gfx::mojom::internal::Point3F_Data> origin;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> post_translation;
  mojo::internal::Pointer<::gfx::mojom::internal::Transform_Data> to_parent;
  mojo::internal::Pointer<::gfx::mojom::internal::PointF_Data> scroll_offset;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> snap_amount;
  uint32_t sticky_position_constraint_id_$value;
  uint32_t anchor_position_scroll_data_id_$value;
  int32_t sorting_context_id;
  float maximum_animation_scale;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> visible_frame_element_id;
  uint64_t damage_reasons_bit_mask;

 private:
  friend class mojo::internal::MessageFragment<TransformNode_Data>;

  TransformNode_Data();
  ~TransformNode_Data() = delete;
};
static_assert(sizeof(TransformNode_Data) == 112,
              "Bad sizeof(TransformNode_Data)");
// Used by TransformNode::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TransformNode_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TransformNode_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TransformNode_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TransformNode_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TransformNode_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ClipNode_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t parent_id;
  int32_t transform_id;
  int32_t pixel_moving_filter_id;
  mojo::internal::Pointer<::gfx::mojom::internal::RectF_Data> clip;

 private:
  friend class mojo::internal::MessageFragment<ClipNode_Data>;

  ClipNode_Data();
  ~ClipNode_Data() = delete;
};
static_assert(sizeof(ClipNode_Data) == 32,
              "Bad sizeof(ClipNode_Data)");
// Used by ClipNode::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ClipNode_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ClipNode_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ClipNode_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ClipNode_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ClipNode_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EffectNode_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t parent_id;
  int32_t transform_id;
  int32_t clip_id;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;
  float opacity;
  int32_t render_surface_reason;
  mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data> surface_contents_scale;
  mojo::internal::Pointer<::viz::mojom::internal::SubtreeCaptureId_Data> subtree_capture_id;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> subtree_size;
  uint32_t blend_mode;
  int32_t target_id;
  int32_t view_transition_target_id;
  int32_t closest_ancestor_with_cached_render_surface_id;
  int32_t closest_ancestor_with_copy_request_id;
  int32_t closest_ancestor_being_captured_id;
  int32_t closest_ancestor_with_shared_element_id;
  float backdrop_filter_quality;
  mojo::internal::Pointer<::viz::mojom::internal::ViewTransitionElementResourceId_Data> view_transition_element_resource_id;
  mojo::internal::Pointer<::viz::mojom::internal::FilterOperations_Data> filters;
  mojo::internal::Pointer<::viz::mojom::internal::FilterOperations_Data> backdrop_filters;
  mojo::internal::Pointer<::skia::mojom::internal::SkPath_Data> backdrop_filter_bounds;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> backdrop_mask_element_id;
  mojo::internal::Pointer<::gfx::mojom::internal::MaskFilterInfo_Data> mask_filter_info;
  uint8_t cache_render_surface : 1;
  uint8_t double_sided : 1;
  uint8_t trilinear_filtering : 1;
  uint8_t subtree_hidden : 1;
  uint8_t has_potential_filter_animation : 1;
  uint8_t has_potential_backdrop_filter_animation : 1;
  uint8_t has_potential_opacity_animation : 1;
  uint8_t effect_changed : 1;
  uint8_t subtree_has_copy_request : 1;
  uint8_t is_fast_rounded_corner : 1;
  uint8_t may_have_backdrop_effect : 1;
  uint8_t needs_effect_for_2d_scale_transform : 1;
  uint8_t pad35_[6];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::viz::mojom::internal::CopyOutputRequest_Data>>> copy_output_requests;

 private:
  friend class mojo::internal::MessageFragment<EffectNode_Data>;

  EffectNode_Data();
  ~EffectNode_Data() = delete;
};
static_assert(sizeof(EffectNode_Data) == 160,
              "Bad sizeof(EffectNode_Data)");
// Used by EffectNode::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EffectNode_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EffectNode_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EffectNode_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<EffectNode_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EffectNode_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ScrollTreeUpdate_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data>, mojo::internal::Pointer<::cc::mojom::internal::SyncedScrollOffset_Data>>> synced_scroll_offsets;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data>, mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data>>> scrolling_contents_cull_rects;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data>, mojo::internal::Pointer<::gfx::mojom::internal::Vector2dF_Data>>> elastic_overscroll;

 private:
  friend class mojo::internal::MessageFragment<ScrollTreeUpdate_Data>;

  ScrollTreeUpdate_Data();
  ~ScrollTreeUpdate_Data() = delete;
};
static_assert(sizeof(ScrollTreeUpdate_Data) == 32,
              "Bad sizeof(ScrollTreeUpdate_Data)");
// Used by ScrollTreeUpdate::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollTreeUpdate_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollTreeUpdate_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollTreeUpdate_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScrollTreeUpdate_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollTreeUpdate_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ScrollNode_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  int32_t parent_id;
  int32_t transform_id;
  uint8_t max_scroll_offset_affected_by_page_scale : 1;
  uint8_t scrolls_inner_viewport : 1;
  uint8_t scrolls_outer_viewport : 1;
  uint8_t prevent_viewport_scrolling_from_inner : 1;
  uint8_t user_scrollable_horizontal : 1;
  uint8_t user_scrollable_vertical : 1;
  uint8_t is_composited : 1;
  uint8_t pad9_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> container_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> bounds;
  mojo::internal::Pointer<::cc::mojom::internal::ElementId_Data> element_id;

 private:
  friend class mojo::internal::MessageFragment<ScrollNode_Data>;

  ScrollNode_Data();
  ~ScrollNode_Data() = delete;
};
static_assert(sizeof(ScrollNode_Data) == 48,
              "Bad sizeof(ScrollNode_Data)");
// Used by ScrollNode::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ScrollNode_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ScrollNode_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ScrollNode_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ScrollNode_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ScrollNode_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SHARED_INTERNAL_H_