// services/viz/public/mojom/compositing/frame_timing_details.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "ui/gfx/mojom/presentation_feedback.mojom-shared.h"
#include "ui/gfx/mojom/swap_timings.mojom-shared.h"


namespace viz::mojom {
class FrameTimingDetailsDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameTimingDetailsDataView> {
  using Data = ::viz::mojom::internal::FrameTimingDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class FrameTimingDetailsDataView {
 public:
  FrameTimingDetailsDataView() = default;

  FrameTimingDetailsDataView(
      internal::FrameTimingDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReceivedCompositorFrameTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceivedCompositorFrameTimestamp(UserType* output) {
    
    auto* pointer = data_->received_compositor_frame_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetEmbeddedFrameTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddedFrameTimestamp(UserType* output) {
    
    auto* pointer = data_->embedded_frame_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDrawStartTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDrawStartTimestamp(UserType* output) {
    
    auto* pointer = data_->draw_start_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSwapTimingsDataView(
      ::gfx::mojom::SwapTimingsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSwapTimings(UserType* output) {
    
    auto* pointer = data_->swap_timings.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SwapTimingsDataView>(
        pointer, output, message_);
  }
  inline void GetPresentationFeedbackDataView(
      ::gfx::mojom::PresentationFeedbackDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentationFeedback(UserType* output) {
    
    auto* pointer = data_->presentation_feedback.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PresentationFeedbackDataView>(
        pointer, output, message_);
  }
  inline void GetFrameIdDataView(
      ::viz::mojom::BeginFrameIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameId(UserType* output) {
    
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameIdDataView>(
        pointer, output, message_);
  }
  inline void GetStartUpdateDisplayTreeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartUpdateDisplayTree(UserType* output) {
    
    auto* pointer = data_->start_update_display_tree.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetStartPrepareToDrawDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartPrepareToDraw(UserType* output) {
    
    auto* pointer = data_->start_prepare_to_draw.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetStartDrawLayersDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartDrawLayers(UserType* output) {
    
    auto* pointer = data_->start_draw_layers.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSubmitCompositorFrameDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmitCompositorFrame(UserType* output) {
    
    auto* pointer = data_->submit_compositor_frame.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameTimingDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_TIMING_DETAILS_MOJOM_DATA_VIEW_H_