// services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BundledFrameSubmissionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledFrameSubmissionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledFrameSubmission_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sink_id = Traits::sink_id(input);

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::viz::mojom::BundledFrameSubmissionDataDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in BundledFrameSubmission struct");
  }

  static bool Deserialize(::viz::mojom::internal::BundledFrameSubmission_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BundledFrameSubmissionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BundledCompositorFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledCompositorFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledCompositorFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::local_surface_id(input)) in_local_surface_id = Traits::local_surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_surface_id)::BaseType> local_surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id,
      local_surface_id_fragment);

    fragment->local_surface_id.Set(
        local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->local_surface_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in BundledCompositorFrame struct");

    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame)::BaseType> frame_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame,
      frame_fragment);

    fragment->frame.Set(
        frame_fragment.is_null() ? nullptr : frame_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in BundledCompositorFrame struct");

    decltype(Traits::hit_test_region_list(input)) in_hit_test_region_list = Traits::hit_test_region_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hit_test_region_list)::BaseType> hit_test_region_list_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list,
      hit_test_region_list_fragment);

    fragment->hit_test_region_list.Set(
        hit_test_region_list_fragment.is_null() ? nullptr : hit_test_region_list_fragment.data());

    fragment->submit_time = Traits::submit_time(input);
  }

  static bool Deserialize(::viz::mojom::internal::BundledCompositorFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BundledCompositorFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BundledReturnedResourcesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BundledReturnedResourcesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BundledReturnedResources_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sink_id = Traits::sink_id(input);

    decltype(Traits::resources(input)) in_resources = Traits::resources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resources)::BaseType>
        resources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources,
      resources_fragment,
      &resources_validate_params);

    fragment->resources.Set(
        resources_fragment.is_null() ? nullptr : resources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in BundledReturnedResources struct");
  }

  static bool Deserialize(::viz::mojom::internal::BundledReturnedResources_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BundledReturnedResourcesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BeginFrameInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sink_id = Traits::sink_id(input);

    decltype(Traits::args(input)) in_args = Traits::args(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->args)::BaseType> args_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args,
      args_fragment);

    fragment->args.Set(
        args_fragment.is_null() ? nullptr : args_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->args.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in BeginFrameInfo struct");

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType>
        details_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
      in_details,
      details_fragment,
      &details_validate_params);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in BeginFrameInfo struct");

    decltype(Traits::resources(input)) in_resources = Traits::resources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resources)::BaseType>
        resources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources,
      resources_fragment,
      &resources_validate_params);

    fragment->resources.Set(
        resources_fragment.is_null() ? nullptr : resources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in BeginFrameInfo struct");
  }

  static bool Deserialize(::viz::mojom::internal::BeginFrameInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BeginFrameInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BundledFrameSubmissionDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::BundledFrameSubmissionDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::BundledFrameSubmissionData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::BundledFrameSubmissionDataDataView::Tag::kFrame: {
    decltype(Traits::frame(input))
    in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::BundledCompositorFrameDataView>(
  in_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null frame in BundledFrameSubmissionData union");
    fragment->data.f_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::BundledFrameSubmissionDataDataView::Tag::kDidNotProduceFrame: {
    decltype(Traits::did_not_produce_frame(input))
    in_did_not_produce_frame = Traits::did_not_produce_frame(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_did_not_produce_frame)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
  in_did_not_produce_frame,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null did_not_produce_frame in BundledFrameSubmissionData union");
    fragment->data.f_did_not_produce_frame.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::viz::mojom::internal::BundledFrameSubmissionData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BundledFrameSubmissionDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void BundledFrameSubmissionDataView::GetDataDataView(
    BundledFrameSubmissionDataDataView* output) {
  auto pointer = &data_->data;
  *output = BundledFrameSubmissionDataDataView(pointer, message_);
}


inline void BundledCompositorFrameDataView::GetLocalSurfaceIdDataView(
    ::viz::mojom::LocalSurfaceIdDataView* output) {
  auto pointer = data_->local_surface_id.Get();
  *output = ::viz::mojom::LocalSurfaceIdDataView(pointer, message_);
}
inline void BundledCompositorFrameDataView::GetFrameDataView(
    ::viz::mojom::CompositorFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = ::viz::mojom::CompositorFrameDataView(pointer, message_);
}
inline void BundledCompositorFrameDataView::GetHitTestRegionListDataView(
    ::viz::mojom::HitTestRegionListDataView* output) {
  auto pointer = data_->hit_test_region_list.Get();
  *output = ::viz::mojom::HitTestRegionListDataView(pointer, message_);
}


inline void BundledReturnedResourcesDataView::GetResourcesDataView(
    mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>* output) {
  auto pointer = data_->resources.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>(pointer, message_);
}


inline void BeginFrameInfoDataView::GetArgsDataView(
    ::viz::mojom::BeginFrameArgsDataView* output) {
  auto pointer = data_->args.Get();
  *output = ::viz::mojom::BeginFrameArgsDataView(pointer, message_);
}
inline void BeginFrameInfoDataView::GetDetailsDataView(
    mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>* output) {
  auto pointer = data_->details.Get();
  *output = mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>(pointer, message_);
}
inline void BeginFrameInfoDataView::GetResourcesDataView(
    mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>* output) {
  auto pointer = data_->resources.Get();
  *output = mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>(pointer, message_);
}


inline void BundledFrameSubmissionDataDataView::GetFrameDataView(
    BundledCompositorFrameDataView* output) const {
  CHECK(is_frame());
  *output = BundledCompositorFrameDataView(data_->data.f_frame.Get(), message_);
}
inline void BundledFrameSubmissionDataDataView::GetDidNotProduceFrameDataView(
    ::viz::mojom::BeginFrameAckDataView* output) const {
  CHECK(is_did_not_produce_frame());
  *output = ::viz::mojom::BeginFrameAckDataView(data_->data.f_did_not_produce_frame.Get(), message_);
}


}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_SHARED_H_