// services/viz/public/mojom/compositing/frame_sink_bundle.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"


namespace viz::mojom {
class BundledFrameSubmissionDataView;

class BundledCompositorFrameDataView;

class BundledReturnedResourcesDataView;

class BeginFrameInfoDataView;

class BundledFrameSubmissionDataDataView;


}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BundledFrameSubmissionDataView> {
  using Data = ::viz::mojom::internal::BundledFrameSubmission_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BundledCompositorFrameDataView> {
  using Data = ::viz::mojom::internal::BundledCompositorFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BundledReturnedResourcesDataView> {
  using Data = ::viz::mojom::internal::BundledReturnedResources_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameInfoDataView> {
  using Data = ::viz::mojom::internal::BeginFrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BundledFrameSubmissionDataDataView> {
  using Data = ::viz::mojom::internal::BundledFrameSubmissionData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {
// Interface base classes. They are used for type safety check.
class FrameSinkBundleInterfaceBase {};

using FrameSinkBundlePtrDataView =
    mojo::InterfacePtrDataView<FrameSinkBundleInterfaceBase>;
using FrameSinkBundleRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkBundleInterfaceBase>;
using FrameSinkBundleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkBundleInterfaceBase>;
using FrameSinkBundleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkBundleInterfaceBase>;
class FrameSinkBundleClientInterfaceBase {};

using FrameSinkBundleClientPtrDataView =
    mojo::InterfacePtrDataView<FrameSinkBundleClientInterfaceBase>;
using FrameSinkBundleClientRequestDataView =
    mojo::InterfaceRequestDataView<FrameSinkBundleClientInterfaceBase>;
using FrameSinkBundleClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameSinkBundleClientInterfaceBase>;
using FrameSinkBundleClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameSinkBundleClientInterfaceBase>;


class BundledFrameSubmissionDataView {
 public:
  BundledFrameSubmissionDataView() = default;

  BundledFrameSubmissionDataView(
      internal::BundledFrameSubmission_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t sink_id() const {
    return data_->sink_id;
  }
  inline void GetDataDataView(
      BundledFrameSubmissionDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::viz::mojom::BundledFrameSubmissionDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::BundledFrameSubmission_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundledCompositorFrameDataView {
 public:
  BundledCompositorFrameDataView() = default;

  BundledCompositorFrameDataView(
      internal::BundledCompositorFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceId(UserType* output) {
    
    auto* pointer = data_->local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetFrameDataView(
      ::viz::mojom::CompositorFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameDataView>(
        pointer, output, message_);
  }
  inline void GetHitTestRegionListDataView(
      ::viz::mojom::HitTestRegionListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHitTestRegionList(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::HitTestRegionListDataView, UserType>(),
    "Attempting to read the optional `hit_test_region_list` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHitTestRegionList` instead "
    "of `ReadHitTestRegionList if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->hit_test_region_list.Get();
    return mojo::internal::Deserialize<::viz::mojom::HitTestRegionListDataView>(
        pointer, output, message_);
  }
  uint64_t submit_time() const {
    return data_->submit_time;
  }
 private:
  internal::BundledCompositorFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundledReturnedResourcesDataView {
 public:
  BundledReturnedResourcesDataView() = default;

  BundledReturnedResourcesDataView(
      internal::BundledReturnedResources_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t sink_id() const {
    return data_->sink_id;
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BundledReturnedResources_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BeginFrameInfoDataView {
 public:
  BeginFrameInfoDataView() = default;

  BeginFrameInfoDataView(
      internal::BeginFrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t sink_id() const {
    return data_->sink_id;
  }
  inline void GetArgsDataView(
      ::viz::mojom::BeginFrameArgsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArgs(UserType* output) {
    
    auto* pointer = data_->args.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameArgsDataView>(
        pointer, output, message_);
  }
  inline void GetDetailsDataView(
      mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
        pointer, output, message_);
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BeginFrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BundledFrameSubmissionDataDataView {
 public:
  using Tag = internal::BundledFrameSubmissionData_Data::BundledFrameSubmissionData_Tag;

  BundledFrameSubmissionDataDataView() = default;

  BundledFrameSubmissionDataDataView(
      internal::BundledFrameSubmissionData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_frame() const { return data_->tag == Tag::kFrame; }
  inline void GetFrameDataView(
      BundledCompositorFrameDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) const {
    
    CHECK(is_frame());
    return mojo::internal::Deserialize<::viz::mojom::BundledCompositorFrameDataView>(
        data_->data.f_frame.Get(), output, message_);
  }
  bool is_did_not_produce_frame() const { return data_->tag == Tag::kDidNotProduceFrame; }
  inline void GetDidNotProduceFrameDataView(
      ::viz::mojom::BeginFrameAckDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDidNotProduceFrame(UserType* output) const {
    
    CHECK(is_did_not_produce_frame());
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameAckDataView>(
        data_->data.f_did_not_produce_frame.Get(), output, message_);
  }

 private:
  internal::BundledFrameSubmissionData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_DATA_VIEW_H_