// services/viz/public/mojom/compositing/frame_interval_inputs.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::ContentFrameIntervalType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ContentFrameIntervalInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ContentFrameIntervalInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ContentFrameIntervalInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::viz::mojom::ContentFrameIntervalType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::frame_interval(input)) in_frame_interval = Traits::frame_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_interval)::BaseType> frame_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_frame_interval,
        frame_interval_fragment);

      fragment->frame_interval.Set(
          frame_interval_fragment.is_null() ? nullptr : frame_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_interval in ContentFrameIntervalInfo struct");

      fragment->duplicate_count = Traits::duplicate_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::FrameIntervalInputsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameIntervalInputsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameIntervalInputs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_time(input)) in_frame_time = Traits::frame_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_time)::BaseType> frame_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_frame_time,
        frame_time_fragment);

      fragment->frame_time.Set(
          frame_time_fragment.is_null() ? nullptr : frame_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_time in FrameIntervalInputs struct");

      fragment->has_user_input = Traits::has_user_input(input);

      fragment->has_input = Traits::has_input(input);

      fragment->major_scroll_speed_in_pixels_per_second = Traits::major_scroll_speed_in_pixels_per_second(input);

      decltype(Traits::content_interval_info(input)) in_content_interval_info = Traits::content_interval_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_interval_info)::BaseType>
          content_interval_info_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& content_interval_info_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ContentFrameIntervalInfoDataView>, send_validation>(
        in_content_interval_info,
        content_interval_info_fragment,
        &content_interval_info_validate_params);

      fragment->content_interval_info.Set(
          content_interval_info_fragment.is_null() ? nullptr : content_interval_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_interval_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_interval_info in FrameIntervalInputs struct");

      fragment->has_only_content_frame_interval_updates = Traits::has_only_content_frame_interval_updates(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SEND_VALIDATION_H_