// services/viz/public/mojom/compositing/copy_output_result.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::CopyOutputResultFormat, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::CopyOutputResultDestination, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CopyOutputResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CopyOutputResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CopyOutputResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::viz::mojom::CopyOutputResultFormat>(
        Traits::format(input),
        &fragment->format);

      
      mojo::internal::Serialize<::viz::mojom::CopyOutputResultDestination>(
        Traits::destination(input),
        &fragment->destination);

      decltype(Traits::rect(input)) in_rect = Traits::rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rect)::BaseType> rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_rect,
        rect_fragment);

      fragment->rect.Set(
          rect_fragment.is_null() ? nullptr : rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in CopyOutputResult struct");

      decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::BitmapInSharedMemoryDataView, send_validation>(
        in_bitmap,
        bitmap_fragment);

      fragment->bitmap.Set(
          bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

      decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::MailboxDataView, send_validation>(
        in_mailbox,
        mailbox_fragment);

      fragment->mailbox.Set(
          mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());

      decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_space)::BaseType> color_space_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView, send_validation>(
        in_color_space,
        color_space_fragment);

      fragment->color_space.Set(
          color_space_fragment.is_null() ? nullptr : color_space_fragment.data());

      decltype(Traits::releaser(input)) in_releaser = Traits::releaser(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::TextureReleaserInterfaceBase>>(
        in_releaser,
        &fragment->releaser,
        &fragment.message());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SEND_VALIDATION_H_