// services/viz/public/mojom/compositing/copy_output_result.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"


namespace viz::mojom {
class CopyOutputResultDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CopyOutputResultDataView> {
  using Data = ::viz::mojom::internal::CopyOutputResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class CopyOutputResultFormat : int32_t {
  
  RGBA = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, CopyOutputResultFormat value);
inline bool IsKnownEnumValue(CopyOutputResultFormat value) {
  return internal::CopyOutputResultFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CopyOutputResultDestination : int32_t {
  
  kSystemMemory = 0,
  
  kSharedImage = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CopyOutputResultDestination value);
inline bool IsKnownEnumValue(CopyOutputResultDestination value) {
  return internal::CopyOutputResultDestination_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CopyOutputResultDataView {
 public:
  CopyOutputResultDataView() = default;

  CopyOutputResultDataView(
      internal::CopyOutputResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultFormat>(
        data_value, output);
  }
  CopyOutputResultFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultFormat>(data_->format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultDestination>(
        data_value, output);
  }
  CopyOutputResultDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultDestination>(data_->destination));
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetBitmapDataView(
      ::viz::mojom::BitmapInSharedMemoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::BitmapInSharedMemoryDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::viz::mojom::BitmapInSharedMemoryDataView>(
        pointer, output, message_);
  }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::MailboxDataView, UserType>(),
    "Attempting to read the optional `mailbox` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMailbox` instead "
    "of `ReadMailbox if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ColorSpaceDataView, UserType>(),
    "Attempting to read the optional `color_space` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorSpace` instead "
    "of `ReadColorSpace if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReleaser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::TextureReleaserInterfaceBase>>(
            &data_->releaser, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CopyOutputResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_DATA_VIEW_H_