// services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "skia/public/mojom/skpath.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorRenderPassDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorRenderPassDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorRenderPass_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CompositorRenderPass struct");

    decltype(Traits::output_rect(input)) in_output_rect = Traits::output_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_rect)::BaseType> output_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_output_rect,
      output_rect_fragment);

    fragment->output_rect.Set(
        output_rect_fragment.is_null() ? nullptr : output_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_rect in CompositorRenderPass struct");

    decltype(Traits::damage_rect(input)) in_damage_rect = Traits::damage_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->damage_rect)::BaseType> damage_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_damage_rect,
      damage_rect_fragment);

    fragment->damage_rect.Set(
        damage_rect_fragment.is_null() ? nullptr : damage_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->damage_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null damage_rect in CompositorRenderPass struct");

    decltype(Traits::transform_to_root_target(input)) in_transform_to_root_target = Traits::transform_to_root_target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transform_to_root_target)::BaseType> transform_to_root_target_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
      in_transform_to_root_target,
      transform_to_root_target_fragment);

    fragment->transform_to_root_target.Set(
        transform_to_root_target_fragment.is_null() ? nullptr : transform_to_root_target_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transform_to_root_target.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transform_to_root_target in CompositorRenderPass struct");

    decltype(Traits::filters(input)) in_filters = Traits::filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filters)::BaseType> filters_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView>(
      in_filters,
      filters_fragment);

    fragment->filters.Set(
        filters_fragment.is_null() ? nullptr : filters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filters in CompositorRenderPass struct");

    decltype(Traits::backdrop_filters(input)) in_backdrop_filters = Traits::backdrop_filters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->backdrop_filters)::BaseType> backdrop_filters_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView>(
      in_backdrop_filters,
      backdrop_filters_fragment);

    fragment->backdrop_filters.Set(
        backdrop_filters_fragment.is_null() ? nullptr : backdrop_filters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->backdrop_filters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null backdrop_filters in CompositorRenderPass struct");

    decltype(Traits::backdrop_filter_bounds(input)) in_backdrop_filter_bounds = Traits::backdrop_filter_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->backdrop_filter_bounds)::BaseType> backdrop_filter_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkPathDataView>(
      in_backdrop_filter_bounds,
      backdrop_filter_bounds_fragment);

    fragment->backdrop_filter_bounds.Set(
        backdrop_filter_bounds_fragment.is_null() ? nullptr : backdrop_filter_bounds_fragment.data());

    decltype(Traits::subtree_capture_id(input)) in_subtree_capture_id = Traits::subtree_capture_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subtree_capture_id)::BaseType> subtree_capture_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView>(
      in_subtree_capture_id,
      subtree_capture_id_fragment);

    fragment->subtree_capture_id.Set(
        subtree_capture_id_fragment.is_null() ? nullptr : subtree_capture_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subtree_capture_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subtree_capture_id in CompositorRenderPass struct");

    decltype(Traits::subtree_size(input)) in_subtree_size = Traits::subtree_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subtree_size)::BaseType> subtree_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_subtree_size,
      subtree_size_fragment);

    fragment->subtree_size.Set(
        subtree_size_fragment.is_null() ? nullptr : subtree_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subtree_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subtree_size in CompositorRenderPass struct");

    decltype(Traits::view_transition_element_resource_id(input)) in_view_transition_element_resource_id = Traits::view_transition_element_resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_element_resource_id)::BaseType> view_transition_element_resource_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
      in_view_transition_element_resource_id,
      view_transition_element_resource_id_fragment);

    fragment->view_transition_element_resource_id.Set(
        view_transition_element_resource_id_fragment.is_null() ? nullptr : view_transition_element_resource_id_fragment.data());

    fragment->has_transparent_background = Traits::has_transparent_background(input);

    fragment->cache_render_pass = Traits::cache_render_pass(input);

    fragment->has_damage_from_contributing_content = Traits::has_damage_from_contributing_content(input);

    fragment->generate_mipmap = Traits::generate_mipmap(input);

    decltype(Traits::copy_requests(input)) in_copy_requests = Traits::copy_requests(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->copy_requests)::BaseType>
        copy_requests_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& copy_requests_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>>(
      in_copy_requests,
      copy_requests_fragment,
      &copy_requests_validate_params);

    fragment->copy_requests.Set(
        copy_requests_fragment.is_null() ? nullptr : copy_requests_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->copy_requests.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null copy_requests in CompositorRenderPass struct");

    decltype(Traits::quad_list(input)) in_quad_list = Traits::quad_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->quad_list)::BaseType>
        quad_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& quad_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>>(
      in_quad_list,
      quad_list_fragment,
      &quad_list_validate_params);

    fragment->quad_list.Set(
        quad_list_fragment.is_null() ? nullptr : quad_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->quad_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null quad_list in CompositorRenderPass struct");

    fragment->has_per_quad_damage = Traits::has_per_quad_damage(input);
  }

  static bool Deserialize(::viz::mojom::internal::CompositorRenderPass_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorRenderPassDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void CompositorRenderPassDataView::GetIdDataView(
    ::viz::mojom::CompositorRenderPassIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::viz::mojom::CompositorRenderPassIdDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetOutputRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->output_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetDamageRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->damage_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetTransformToRootTargetDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->transform_to_root_target.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetFiltersDataView(
    ::viz::mojom::FilterOperationsDataView* output) {
  auto pointer = data_->filters.Get();
  *output = ::viz::mojom::FilterOperationsDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetBackdropFiltersDataView(
    ::viz::mojom::FilterOperationsDataView* output) {
  auto pointer = data_->backdrop_filters.Get();
  *output = ::viz::mojom::FilterOperationsDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetBackdropFilterBoundsDataView(
    ::skia::mojom::SkPathDataView* output) {
  auto pointer = data_->backdrop_filter_bounds.Get();
  *output = ::skia::mojom::SkPathDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetSubtreeCaptureIdDataView(
    ::viz::mojom::SubtreeCaptureIdDataView* output) {
  auto pointer = data_->subtree_capture_id.Get();
  *output = ::viz::mojom::SubtreeCaptureIdDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetSubtreeSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->subtree_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetViewTransitionElementResourceIdDataView(
    ::viz::mojom::ViewTransitionElementResourceIdDataView* output) {
  auto pointer = data_->view_transition_element_resource_id.Get();
  *output = ::viz::mojom::ViewTransitionElementResourceIdDataView(pointer, message_);
}
inline void CompositorRenderPassDataView::GetCopyRequestsDataView(
    mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>* output) {
  auto pointer = data_->copy_requests.Get();
  *output = mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>(pointer, message_);
}
inline void CompositorRenderPassDataView::GetQuadListDataView(
    mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>* output) {
  auto pointer = data_->quad_list.Get();
  *output = mojo::ArrayDataView<::viz::mojom::DrawQuadDataView>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_SHARED_H_