// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "ui/gfx/mojom/display_color_spaces.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/compositor_frame_transition_directive_mojom_traits.h"




namespace viz::mojom {









class  CompositorFrameTransitionDirectiveSharedElement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrameTransitionDirectiveSharedElement, T>::value>;
  using DataView = CompositorFrameTransitionDirectiveSharedElementDataView;
  using Data_ = internal::CompositorFrameTransitionDirectiveSharedElement_Data;

  template <typename... Args>
  static CompositorFrameTransitionDirectiveSharedElementPtr New(Args&&... args) {
    return CompositorFrameTransitionDirectiveSharedElementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFrameTransitionDirectiveSharedElementPtr From(const U& u) {
    return mojo::TypeConverter<CompositorFrameTransitionDirectiveSharedElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrameTransitionDirectiveSharedElement>::Convert(*this);
  }


  CompositorFrameTransitionDirectiveSharedElement();

  CompositorFrameTransitionDirectiveSharedElement(
      const ::viz::CompositorRenderPassId& render_pass_id,
      const ::viz::ViewTransitionElementResourceId& view_transition_element_resource_id);


  ~CompositorFrameTransitionDirectiveSharedElement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFrameTransitionDirectiveSharedElementPtr>
  CompositorFrameTransitionDirectiveSharedElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameTransitionDirectiveSharedElement::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameTransitionDirectiveSharedElement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrameTransitionDirectiveSharedElement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrameTransitionDirectiveSharedElement_UnserializedMessageContext<
            UserType, CompositorFrameTransitionDirectiveSharedElement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorFrameTransitionDirectiveSharedElement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorFrameTransitionDirectiveSharedElement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrameTransitionDirectiveSharedElement_UnserializedMessageContext<
            UserType, CompositorFrameTransitionDirectiveSharedElement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrameTransitionDirectiveSharedElement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::CompositorRenderPassId render_pass_id;
  
  ::viz::ViewTransitionElementResourceId view_transition_element_resource_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CompositorFrameTransitionDirective {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrameTransitionDirective, T>::value>;
  using DataView = CompositorFrameTransitionDirectiveDataView;
  using Data_ = internal::CompositorFrameTransitionDirective_Data;

  template <typename... Args>
  static CompositorFrameTransitionDirectivePtr New(Args&&... args) {
    return CompositorFrameTransitionDirectivePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFrameTransitionDirectivePtr From(const U& u) {
    return mojo::TypeConverter<CompositorFrameTransitionDirectivePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrameTransitionDirective>::Convert(*this);
  }


  CompositorFrameTransitionDirective();

  CompositorFrameTransitionDirective(
      const ::blink::ViewTransitionToken& transition_token,
      bool maybe_cross_frame_sink,
      uint32_t sequence_id,
      CompositorFrameTransitionDirectiveType type,
      std::vector<CompositorFrameTransitionDirectiveSharedElementPtr> shared_elements,
      const ::gfx::DisplayColorSpaces& display_color_spaces);

CompositorFrameTransitionDirective(const CompositorFrameTransitionDirective&) = delete;
CompositorFrameTransitionDirective& operator=(const CompositorFrameTransitionDirective&) = delete;

  ~CompositorFrameTransitionDirective();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFrameTransitionDirectivePtr>
  CompositorFrameTransitionDirectivePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameTransitionDirective::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameTransitionDirective::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrameTransitionDirective::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrameTransitionDirective_UnserializedMessageContext<
            UserType, CompositorFrameTransitionDirective::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorFrameTransitionDirective::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorFrameTransitionDirective::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrameTransitionDirective_UnserializedMessageContext<
            UserType, CompositorFrameTransitionDirective::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrameTransitionDirective::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::ViewTransitionToken transition_token;
  
  bool maybe_cross_frame_sink;
  
  uint32_t sequence_id;
  
  CompositorFrameTransitionDirectiveType type;
  
  std::vector<CompositorFrameTransitionDirectiveSharedElementPtr> shared_elements;
  
  ::gfx::DisplayColorSpaces display_color_spaces;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorFrameTransitionDirectiveSharedElementPtr CompositorFrameTransitionDirectiveSharedElement::Clone() const {
  return New(
      mojo::Clone(render_pass_id),
      mojo::Clone(view_transition_element_resource_id)
  );
}

template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>*>
bool CompositorFrameTransitionDirectiveSharedElement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->render_pass_id, other_struct.render_pass_id))
    return false;
  if (!mojo::Equals(this->view_transition_element_resource_id, other_struct.view_transition_element_resource_id))
    return false;
  return true;
}

template <typename T, CompositorFrameTransitionDirectiveSharedElement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.render_pass_id < rhs.render_pass_id)
    return true;
  if (rhs.render_pass_id < lhs.render_pass_id)
    return false;
  if (lhs.view_transition_element_resource_id < rhs.view_transition_element_resource_id)
    return true;
  if (rhs.view_transition_element_resource_id < lhs.view_transition_element_resource_id)
    return false;
  return false;
}
template <typename StructPtrType>
CompositorFrameTransitionDirectivePtr CompositorFrameTransitionDirective::Clone() const {
  return New(
      mojo::Clone(transition_token),
      mojo::Clone(maybe_cross_frame_sink),
      mojo::Clone(sequence_id),
      mojo::Clone(type),
      mojo::Clone(shared_elements),
      mojo::Clone(display_color_spaces)
  );
}

template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>*>
bool CompositorFrameTransitionDirective::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transition_token, other_struct.transition_token))
    return false;
  if (!mojo::Equals(this->maybe_cross_frame_sink, other_struct.maybe_cross_frame_sink))
    return false;
  if (!mojo::Equals(this->sequence_id, other_struct.sequence_id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->shared_elements, other_struct.shared_elements))
    return false;
  if (!mojo::Equals(this->display_color_spaces, other_struct.display_color_spaces))
    return false;
  return true;
}

template <typename T, CompositorFrameTransitionDirective::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transition_token < rhs.transition_token)
    return true;
  if (rhs.transition_token < lhs.transition_token)
    return false;
  if (lhs.maybe_cross_frame_sink < rhs.maybe_cross_frame_sink)
    return true;
  if (rhs.maybe_cross_frame_sink < lhs.maybe_cross_frame_sink)
    return false;
  if (lhs.sequence_id < rhs.sequence_id)
    return true;
  if (rhs.sequence_id < lhs.sequence_id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.shared_elements < rhs.shared_elements)
    return true;
  if (rhs.shared_elements < lhs.shared_elements)
    return false;
  if (lhs.display_color_spaces < rhs.display_color_spaces)
    return true;
  if (rhs.display_color_spaces < lhs.display_color_spaces)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CompositorFrameTransitionDirectiveSharedElement::DataView,
                                         ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr> {
  static bool IsNull(const ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::CompositorFrameTransitionDirectiveSharedElement::render_pass_id)& render_pass_id(
      const ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr& input) {
    return input->render_pass_id;
  }

  static const decltype(::viz::mojom::CompositorFrameTransitionDirectiveSharedElement::view_transition_element_resource_id)& view_transition_element_resource_id(
      const ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr& input) {
    return input->view_transition_element_resource_id;
  }

  static bool Read(::viz::mojom::CompositorFrameTransitionDirectiveSharedElement::DataView input, ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::CompositorFrameTransitionDirective::DataView,
                                         ::viz::mojom::CompositorFrameTransitionDirectivePtr> {
  static bool IsNull(const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorFrameTransitionDirectivePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::CompositorFrameTransitionDirective::transition_token)& transition_token(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->transition_token;
  }

  static decltype(::viz::mojom::CompositorFrameTransitionDirective::maybe_cross_frame_sink) maybe_cross_frame_sink(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->maybe_cross_frame_sink;
  }

  static decltype(::viz::mojom::CompositorFrameTransitionDirective::sequence_id) sequence_id(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->sequence_id;
  }

  static decltype(::viz::mojom::CompositorFrameTransitionDirective::type) type(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::CompositorFrameTransitionDirective::shared_elements)& shared_elements(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->shared_elements;
  }

  static const decltype(::viz::mojom::CompositorFrameTransitionDirective::display_color_spaces)& display_color_spaces(
      const ::viz::mojom::CompositorFrameTransitionDirectivePtr& input) {
    return input->display_color_spaces;
  }

  static bool Read(::viz::mojom::CompositorFrameTransitionDirective::DataView input, ::viz::mojom::CompositorFrameTransitionDirectivePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_H_