// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::CompositorFrameTransitionDirectiveType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameTransitionDirectiveSharedElement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::render_pass_id(input)) in_render_pass_id = Traits::render_pass_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->render_pass_id)::BaseType> render_pass_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView, send_validation>(
        in_render_pass_id,
        render_pass_id_fragment);

      fragment->render_pass_id.Set(
          render_pass_id_fragment.is_null() ? nullptr : render_pass_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->render_pass_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null render_pass_id in CompositorFrameTransitionDirectiveSharedElement struct");

      decltype(Traits::view_transition_element_resource_id(input)) in_view_transition_element_resource_id = Traits::view_transition_element_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_transition_element_resource_id)::BaseType> view_transition_element_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView, send_validation>(
        in_view_transition_element_resource_id,
        view_transition_element_resource_id_fragment);

      fragment->view_transition_element_resource_id.Set(
          view_transition_element_resource_id_fragment.is_null() ? nullptr : view_transition_element_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->view_transition_element_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_transition_element_resource_id in CompositorFrameTransitionDirectiveSharedElement struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CompositorFrameTransitionDirectiveDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameTransitionDirectiveDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameTransitionDirective_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::transition_token(input)) in_transition_token = Traits::transition_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transition_token)::BaseType> transition_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView, send_validation>(
        in_transition_token,
        transition_token_fragment);

      fragment->transition_token.Set(
          transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transition_token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transition_token in CompositorFrameTransitionDirective struct");

      fragment->maybe_cross_frame_sink = Traits::maybe_cross_frame_sink(input);

      fragment->sequence_id = Traits::sequence_id(input);

      
      mojo::internal::Serialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::shared_elements(input)) in_shared_elements = Traits::shared_elements(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shared_elements)::BaseType>
          shared_elements_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shared_elements_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView>, send_validation>(
        in_shared_elements,
        shared_elements_fragment,
        &shared_elements_validate_params);

      fragment->shared_elements.Set(
          shared_elements_fragment.is_null() ? nullptr : shared_elements_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->shared_elements.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_elements in CompositorFrameTransitionDirective struct");

      decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_color_spaces)::BaseType> display_color_spaces_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView, send_validation>(
        in_display_color_spaces,
        display_color_spaces_fragment);

      fragment->display_color_spaces.Set(
          display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_color_spaces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_color_spaces in CompositorFrameTransitionDirective struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SEND_VALIDATION_H_