// services/viz/public/mojom/compositing/compositor_frame_sink.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ScrollbarAnimator as cc_mojom_ScrollbarAnimator,
  ScrollbarAnimatorSpec as cc_mojom_ScrollbarAnimatorSpec
} from '../../../../../cc/mojom/scrollbar_animator.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  HitTestRegionList as viz_mojom_HitTestRegionList,
  HitTestRegionListSpec as viz_mojom_HitTestRegionListSpec
} from '../hit_test/hit_test_region_list.mojom.m.js';

import {
  BeginFrameAck as viz_mojom_BeginFrameAck,
  BeginFrameAckSpec as viz_mojom_BeginFrameAckSpec,
  BeginFrameArgs as viz_mojom_BeginFrameArgs,
  BeginFrameArgsSpec as viz_mojom_BeginFrameArgsSpec
} from './begin_frame_args.mojom.m.js';

import {
  CompositorFrame as viz_mojom_CompositorFrame,
  CompositorFrameSpec as viz_mojom_CompositorFrameSpec
} from './compositor_frame.mojom.m.js';

import {
  FrameTimingDetails as viz_mojom_FrameTimingDetails,
  FrameTimingDetailsSpec as viz_mojom_FrameTimingDetailsSpec
} from './frame_timing_details.mojom.m.js';

import {
  PendingLayerContext as viz_mojom_PendingLayerContext,
  PendingLayerContextSpec as viz_mojom_PendingLayerContextSpec
} from './layer_context.mojom.m.js';

import {
  LocalSurfaceId as viz_mojom_LocalSurfaceId,
  LocalSurfaceIdSpec as viz_mojom_LocalSurfaceIdSpec
} from './local_surface_id.mojom.m.js';

import {
  ReturnedResource as viz_mojom_ReturnedResource,
  ReturnedResourceSpec as viz_mojom_ReturnedResourceSpec
} from './returned_resource.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CompositorFrameSinkPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.CompositorFrameSink', scope);
  }
}

/** @interface */
export class CompositorFrameSinkInterface {
  
  /**
   * @param { !CompositorFrameSinkParams } params
   */

  setParams(params) {}
  
  /**
   * @param { !boolean } needsBeginFrame
   */

  setNeedsBeginFrame(needsBeginFrame) {}
  
  /**
   * @param { !viz_mojom_LocalSurfaceId } localSurfaceId
   * @param { !viz_mojom_CompositorFrame } frame
   * @param { ?viz_mojom_HitTestRegionList } hitTestRegionList
   * @param { !bigint } submitTime
   */

  submitCompositorFrame(localSurfaceId, frame, hitTestRegionList, submitTime) {}
  
  /**
   * @param { !viz_mojom_BeginFrameAck } ack
   */

  didNotProduceFrame(ack) {}
  
  /**
   */

  notifyNewLocalSurfaceIdExpectedWhilePaused() {}
  
  /**
   * @param { !viz_mojom_PendingLayerContext } context
   * @param { !LayerContextSettings } settings
   */

  bindLayerContext(context, settings) {}
}

/**
 * @implements { CompositorFrameSinkInterface }
 */
export class CompositorFrameSinkRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CompositorFrameSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CompositorFrameSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CompositorFrameSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CompositorFrameSinkParams } params
   */

  setParams(
      params) {
    this.proxy.sendMessage(
        0,
        CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !boolean } needsBeginFrame
   */

  setNeedsBeginFrame(
      needsBeginFrame) {
    this.proxy.sendMessage(
        1,
        CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        [
          needsBeginFrame
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_LocalSurfaceId } localSurfaceId
   * @param { !viz_mojom_CompositorFrame } frame
   * @param { ?viz_mojom_HitTestRegionList } hitTestRegionList
   * @param { !bigint } submitTime
   */

  submitCompositorFrame(
      localSurfaceId,
      frame,
      hitTestRegionList,
      submitTime) {
    this.proxy.sendMessage(
        2,
        CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        [
          localSurfaceId,
          frame,
          hitTestRegionList,
          submitTime
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_BeginFrameAck } ack
   */

  didNotProduceFrame(
      ack) {
    this.proxy.sendMessage(
        3,
        CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        [
          ack
        ],
        false);
  }

  
  /**
   */

  notifyNewLocalSurfaceIdExpectedWhilePaused() {
    this.proxy.sendMessage(
        4,
        CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_PendingLayerContext } context
   * @param { !LayerContextSettings } settings
   */

  bindLayerContext(
      context,
      settings) {
    this.proxy.sendMessage(
        5,
        CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        [
          context,
          settings
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CompositorFrameSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CompositorFrameSinkReceiver {
  /**
   * @param {!CompositorFrameSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CompositorFrameSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CompositorFrameSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CompositorFrameSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        impl.setParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        impl.setNeedsBeginFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        impl.submitCompositorFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        impl.didNotProduceFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        impl.notifyNewLocalSurfaceIdExpectedWhilePaused.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        impl.bindLayerContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CompositorFrameSink {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CompositorFrameSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CompositorFrameSinkRemote}
   */
  static getRemote() {
    let remote = new CompositorFrameSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CompositorFrameSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CompositorFrameSinkCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CompositorFrameSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CompositorFrameSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CompositorFrameSink_SetParams_ParamsSpec.$,
        null,
        this.setParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNeedsBeginFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
        null,
        this.setNeedsBeginFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitCompositorFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
        null,
        this.submitCompositorFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didNotProduceFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
        null,
        this.didNotProduceFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyNewLocalSurfaceIdExpectedWhilePaused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
        null,
        this.notifyNewLocalSurfaceIdExpectedWhilePaused.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindLayerContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CompositorFrameSink_BindLayerContext_ParamsSpec.$,
        null,
        this.bindLayerContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CompositorFrameSinkClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'viz.mojom.CompositorFrameSinkClient', scope);
  }
}

/** @interface */
export class CompositorFrameSinkClientInterface {
  
  /**
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  didReceiveCompositorFrameAck(resources) {}
  
  /**
   * @param { !viz_mojom_BeginFrameArgs } args
   * @param { !Object<!number, !viz_mojom_FrameTimingDetails> } details
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  onBeginFrame(args, details, resources) {}
  
  /**
   * @param { !boolean } paused
   */

  onBeginFramePausedChanged(paused) {}
  
  /**
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  reclaimResources(resources) {}
  
  /**
   * @param { !number } sequenceId
   */

  onCompositorFrameTransitionDirectiveProcessed(sequenceId) {}
  
  /**
   * @param { !viz_mojom_LocalSurfaceId } localSurfaceId
   */

  onSurfaceEvicted(localSurfaceId) {}
}

/**
 * @implements { CompositorFrameSinkClientInterface }
 */
export class CompositorFrameSinkClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CompositorFrameSinkClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CompositorFrameSinkClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CompositorFrameSinkClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  didReceiveCompositorFrameAck(
      resources) {
    this.proxy.sendMessage(
        0,
        CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        [
          resources
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_BeginFrameArgs } args
   * @param { !Object<!number, !viz_mojom_FrameTimingDetails> } details
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  onBeginFrame(
      args,
      details,
      resources) {
    this.proxy.sendMessage(
        1,
        CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        [
          args,
          details,
          resources
        ],
        false);
  }

  
  /**
   * @param { !boolean } paused
   */

  onBeginFramePausedChanged(
      paused) {
    this.proxy.sendMessage(
        2,
        CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        [
          paused
        ],
        false);
  }

  
  /**
   * @param { !Array<!viz_mojom_ReturnedResource> } resources
   */

  reclaimResources(
      resources) {
    this.proxy.sendMessage(
        3,
        CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        [
          resources
        ],
        false);
  }

  
  /**
   * @param { !number } sequenceId
   */

  onCompositorFrameTransitionDirectiveProcessed(
      sequenceId) {
    this.proxy.sendMessage(
        4,
        CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        [
          sequenceId
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_LocalSurfaceId } localSurfaceId
   */

  onSurfaceEvicted(
      localSurfaceId) {
    this.proxy.sendMessage(
        5,
        CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        [
          localSurfaceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CompositorFrameSinkClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CompositorFrameSinkClientReceiver {
  /**
   * @param {!CompositorFrameSinkClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CompositorFrameSinkClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CompositorFrameSinkClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CompositorFrameSinkClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        impl.didReceiveCompositorFrameAck.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        impl.onBeginFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        impl.onBeginFramePausedChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        impl.reclaimResources.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        impl.onCompositorFrameTransitionDirectiveProcessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        impl.onSurfaceEvicted.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CompositorFrameSinkClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CompositorFrameSinkClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CompositorFrameSinkClientRemote}
   */
  static getRemote() {
    let remote = new CompositorFrameSinkClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CompositorFrameSinkClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CompositorFrameSinkClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CompositorFrameSinkClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CompositorFrameSinkClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReceiveCompositorFrameAck =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
        null,
        this.didReceiveCompositorFrameAck.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeginFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
        null,
        this.onBeginFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBeginFramePausedChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
        null,
        this.onBeginFramePausedChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reclaimResources =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
        null,
        this.reclaimResources.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompositorFrameTransitionDirectiveProcessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
        null,
        this.onCompositorFrameTransitionDirectiveProcessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSurfaceEvicted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
        null,
        this.onSurfaceEvicted.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LayerContextSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_SetParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_SubmitCompositorFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_DidNotProduceFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSink_BindLayerContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_OnBeginFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_ReclaimResources_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LayerContextSettingsSpec.$,
    'LayerContextSettings',
    [
      mojo.internal.StructField(
        'drawModeIsGpu', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableEarlyDamageCheck', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'damagedFrameLimit', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollbarAnimator', 8,
        0,
        cc_mojom_ScrollbarAnimatorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollbarFadeDelay', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollbarFadeDuration', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scrollbarThinningDuration', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'idleThicknessScale', 12,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topControlsShowThreshold', 40,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topControlsHideThreshold', 44,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimumOcclusionTrackingSize', 48,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableEdgeAntiAliasing', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableBackfaceVisibilityInterop', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableFluentScrollbar', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableFluentOverlayScrollbar', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class LayerContextSettings {
  constructor() {
    /** @type { !boolean } */
    this.drawModeIsGpu;
    /** @type { !boolean } */
    this.enableEarlyDamageCheck;
    /** @type { !number } */
    this.damagedFrameLimit;
    /** @type { !cc_mojom_ScrollbarAnimator } */
    this.scrollbarAnimator;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.scrollbarFadeDelay;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.scrollbarFadeDuration;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.scrollbarThinningDuration;
    /** @type { !number } */
    this.idleThicknessScale;
    /** @type { !number } */
    this.topControlsShowThreshold;
    /** @type { !number } */
    this.topControlsHideThreshold;
    /** @type { !gfx_mojom_Size } */
    this.minimumOcclusionTrackingSize;
    /** @type { !boolean } */
    this.enableEdgeAntiAliasing;
    /** @type { !boolean } */
    this.enableBackfaceVisibilityInterop;
    /** @type { !boolean } */
    this.enableFluentScrollbar;
    /** @type { !boolean } */
    this.enableFluentOverlayScrollbar;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkParamsSpec.$,
    'CompositorFrameSinkParams',
    [
      mojo.internal.StructField(
        'wantsAnimateOnlyBeginFrames', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'autoNeedsBeginFrame', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'noCompositorFrameAcks', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkParams {
  constructor() {
    /** @type { !boolean } */
    this.wantsAnimateOnlyBeginFrames;
    /** @type { !boolean } */
    this.autoNeedsBeginFrame;
    /** @type { !boolean } */
    this.noCompositorFrameAcks;
  }
}



mojo.internal.Struct(
    CompositorFrameSink_SetParams_ParamsSpec.$,
    'CompositorFrameSink_SetParams_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        CompositorFrameSinkParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSink_SetParams_Params {
  constructor() {
    /** @type { !CompositorFrameSinkParams } */
    this.params;
  }
}



mojo.internal.Struct(
    CompositorFrameSink_SetNeedsBeginFrame_ParamsSpec.$,
    'CompositorFrameSink_SetNeedsBeginFrame_Params',
    [
      mojo.internal.StructField(
        'needsBeginFrame', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSink_SetNeedsBeginFrame_Params {
  constructor() {
    /** @type { !boolean } */
    this.needsBeginFrame;
  }
}



mojo.internal.Struct(
    CompositorFrameSink_SubmitCompositorFrame_ParamsSpec.$,
    'CompositorFrameSink_SubmitCompositorFrame_Params',
    [
      mojo.internal.StructField(
        'localSurfaceId', 0,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frame', 8,
        0,
        viz_mojom_CompositorFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hitTestRegionList', 16,
        0,
        viz_mojom_HitTestRegionListSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'submitTime', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CompositorFrameSink_SubmitCompositorFrame_Params {
  constructor() {
    /** @type { !viz_mojom_LocalSurfaceId } */
    this.localSurfaceId;
    /** @type { !viz_mojom_CompositorFrame } */
    this.frame;
    /** @type { (viz_mojom_HitTestRegionList|undefined) } */
    this.hitTestRegionList;
    /** @type { !bigint } */
    this.submitTime;
  }
}



mojo.internal.Struct(
    CompositorFrameSink_DidNotProduceFrame_ParamsSpec.$,
    'CompositorFrameSink_DidNotProduceFrame_Params',
    [
      mojo.internal.StructField(
        'ack', 0,
        0,
        viz_mojom_BeginFrameAckSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSink_DidNotProduceFrame_Params {
  constructor() {
    /** @type { !viz_mojom_BeginFrameAck } */
    this.ack;
  }
}



mojo.internal.Struct(
    CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_ParamsSpec.$,
    'CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CompositorFrameSink_BindLayerContext_ParamsSpec.$,
    'CompositorFrameSink_BindLayerContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        viz_mojom_PendingLayerContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        LayerContextSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CompositorFrameSink_BindLayerContext_Params {
  constructor() {
    /** @type { !viz_mojom_PendingLayerContext } */
    this.context;
    /** @type { !LayerContextSettings } */
    this.settings;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsSpec.$,
    'CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params',
    [
      mojo.internal.StructField(
        'resources', 0,
        0,
        mojo.internal.Array(viz_mojom_ReturnedResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params {
  constructor() {
    /** @type { !Array<!viz_mojom_ReturnedResource> } */
    this.resources;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_OnBeginFrame_ParamsSpec.$,
    'CompositorFrameSinkClient_OnBeginFrame_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        viz_mojom_BeginFrameArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.Map(mojo.internal.Uint32, viz_mojom_FrameTimingDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resources', 16,
        0,
        mojo.internal.Array(viz_mojom_ReturnedResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_OnBeginFrame_Params {
  constructor() {
    /** @type { !viz_mojom_BeginFrameArgs } */
    this.args;
    /** @type { !Object<!number, !viz_mojom_FrameTimingDetails> } */
    this.details;
    /** @type { !Array<!viz_mojom_ReturnedResource> } */
    this.resources;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsSpec.$,
    'CompositorFrameSinkClient_OnBeginFramePausedChanged_Params',
    [
      mojo.internal.StructField(
        'paused', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_OnBeginFramePausedChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.paused;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_ReclaimResources_ParamsSpec.$,
    'CompositorFrameSinkClient_ReclaimResources_Params',
    [
      mojo.internal.StructField(
        'resources', 0,
        0,
        mojo.internal.Array(viz_mojom_ReturnedResourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_ReclaimResources_Params {
  constructor() {
    /** @type { !Array<!viz_mojom_ReturnedResource> } */
    this.resources;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_ParamsSpec.$,
    'CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params',
    [
      mojo.internal.StructField(
        'sequenceId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params {
  constructor() {
    /** @type { !number } */
    this.sequenceId;
  }
}



mojo.internal.Struct(
    CompositorFrameSinkClient_OnSurfaceEvicted_ParamsSpec.$,
    'CompositorFrameSinkClient_OnSurfaceEvicted_Params',
    [
      mojo.internal.StructField(
        'localSurfaceId', 0,
        0,
        viz_mojom_LocalSurfaceIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CompositorFrameSinkClient_OnSurfaceEvicted_Params {
  constructor() {
    /** @type { !viz_mojom_LocalSurfaceId } */
    this.localSurfaceId;
  }
}

