// services/viz/public/mojom/compositing/compositor_frame_sink.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/compositor_frame_sink.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var scrollbar_animator$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/scrollbar_animator.mojom', '../../../../../cc/mojom/scrollbar_animator.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }
  var begin_frame_args$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/begin_frame_args.mojom', 'begin_frame_args.mojom.js');
  }
  var compositor_frame$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame.mojom', 'compositor_frame.mojom.js');
  }
  var layer_context$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/layer_context.mojom', 'layer_context.mojom.js');
  }
  var local_surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/local_surface_id.mojom', 'local_surface_id.mojom.js');
  }
  var frame_timing_details$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_timing_details.mojom', 'frame_timing_details.mojom.js');
  }
  var returned_resource$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/returned_resource.mojom', 'returned_resource.mojom.js');
  }
  var thread$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/thread.mojom', 'thread.mojom.js');
  }
  var hit_test_region_list$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/hit_test/hit_test_region_list.mojom', '../hit_test/hit_test_region_list.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function LayerContextSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerContextSettings.prototype.initDefaults_ = function() {
    this.drawModeIsGpu = false;
    this.enableEarlyDamageCheck = false;
    this.enableEdgeAntiAliasing = false;
    this.enableBackfaceVisibilityInterop = false;
    this.enableFluentScrollbar = false;
    this.enableFluentOverlayScrollbar = false;
    this.damagedFrameLimit = 0;
    this.scrollbarAnimator = 0;
    this.idleThicknessScale = 0;
    this.scrollbarFadeDelay = null;
    this.scrollbarFadeDuration = null;
    this.scrollbarThinningDuration = null;
    this.topControlsShowThreshold = 0;
    this.topControlsHideThreshold = 0;
    this.minimumOcclusionTrackingSize = null;
  };
  LayerContextSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerContextSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate LayerContextSettings.scrollbarAnimator
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, scrollbar_animator$.ScrollbarAnimator);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContextSettings.scrollbarFadeDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContextSettings.scrollbarFadeDuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContextSettings.scrollbarThinningDuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate LayerContextSettings.minimumOcclusionTrackingSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  LayerContextSettings.encodedSize = codec.kStructHeaderSize + 56;

  LayerContextSettings.decode = function(decoder) {
    var packed;
    var val = new LayerContextSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.drawModeIsGpu = (packed >> 0) & 1 ? true : false;
    val.enableEarlyDamageCheck = (packed >> 1) & 1 ? true : false;
    val.enableEdgeAntiAliasing = (packed >> 2) & 1 ? true : false;
    val.enableBackfaceVisibilityInterop = (packed >> 3) & 1 ? true : false;
    val.enableFluentScrollbar = (packed >> 4) & 1 ? true : false;
    val.enableFluentOverlayScrollbar = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.damagedFrameLimit =
        decoder.decodeStruct(codec.Int32);
    val.scrollbarAnimator =
        decoder.decodeStruct(new codec.Enum(scrollbar_animator$.ScrollbarAnimator));
    val.idleThicknessScale =
        decoder.decodeStruct(codec.Float);
    val.scrollbarFadeDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.scrollbarFadeDuration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.scrollbarThinningDuration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.topControlsShowThreshold =
        decoder.decodeStruct(codec.Float);
    val.topControlsHideThreshold =
        decoder.decodeStruct(codec.Float);
    val.minimumOcclusionTrackingSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  LayerContextSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerContextSettings.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.drawModeIsGpu & 1) << 0
    packed |= (val.enableEarlyDamageCheck & 1) << 1
    packed |= (val.enableEdgeAntiAliasing & 1) << 2
    packed |= (val.enableBackfaceVisibilityInterop & 1) << 3
    packed |= (val.enableFluentScrollbar & 1) << 4
    packed |= (val.enableFluentOverlayScrollbar & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.damagedFrameLimit);
    encoder.encodeStruct(codec.Int32, val.scrollbarAnimator);
    encoder.encodeStruct(codec.Float, val.idleThicknessScale);
    encoder.encodeStructPointer(time$.TimeDelta, val.scrollbarFadeDelay);
    encoder.encodeStructPointer(time$.TimeDelta, val.scrollbarFadeDuration);
    encoder.encodeStructPointer(time$.TimeDelta, val.scrollbarThinningDuration);
    encoder.encodeStruct(codec.Float, val.topControlsShowThreshold);
    encoder.encodeStruct(codec.Float, val.topControlsHideThreshold);
    encoder.encodeStructPointer(geometry$.Size, val.minimumOcclusionTrackingSize);
  };
  function CompositorFrameSinkParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkParams.prototype.initDefaults_ = function() {
    this.wantsAnimateOnlyBeginFrames = false;
    this.autoNeedsBeginFrame = false;
    this.noCompositorFrameAcks = false;
  };
  CompositorFrameSinkParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  CompositorFrameSinkParams.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkParams.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.wantsAnimateOnlyBeginFrames = (packed >> 0) & 1 ? true : false;
    val.autoNeedsBeginFrame = (packed >> 1) & 1 ? true : false;
    val.noCompositorFrameAcks = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompositorFrameSinkParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.wantsAnimateOnlyBeginFrames & 1) << 0
    packed |= (val.autoNeedsBeginFrame & 1) << 1
    packed |= (val.noCompositorFrameAcks & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CompositorFrameSink_SetParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_SetParams_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  CompositorFrameSink_SetParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_SetParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_SetParams_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CompositorFrameSinkParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSink_SetParams_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSink_SetParams_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_SetParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(CompositorFrameSinkParams);
    return val;
  };

  CompositorFrameSink_SetParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_SetParams_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CompositorFrameSinkParams, val.params);
  };
  function CompositorFrameSink_SetNeedsBeginFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_SetNeedsBeginFrame_Params.prototype.initDefaults_ = function() {
    this.needsBeginFrame = false;
  };
  CompositorFrameSink_SetNeedsBeginFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_SetNeedsBeginFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompositorFrameSink_SetNeedsBeginFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSink_SetNeedsBeginFrame_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_SetNeedsBeginFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.needsBeginFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompositorFrameSink_SetNeedsBeginFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_SetNeedsBeginFrame_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.needsBeginFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CompositorFrameSink_SubmitCompositorFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_SubmitCompositorFrame_Params.prototype.initDefaults_ = function() {
    this.localSurfaceId = null;
    this.frame = null;
    this.hitTestRegionList = null;
    this.submitTime = 0;
  };
  CompositorFrameSink_SubmitCompositorFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_SubmitCompositorFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_SubmitCompositorFrame_Params.localSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, local_surface_id$.LocalSurfaceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_SubmitCompositorFrame_Params.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, compositor_frame$.CompositorFrame, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_SubmitCompositorFrame_Params.hitTestRegionList
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, hit_test_region_list$.HitTestRegionList, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompositorFrameSink_SubmitCompositorFrame_Params.encodedSize = codec.kStructHeaderSize + 32;

  CompositorFrameSink_SubmitCompositorFrame_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_SubmitCompositorFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    val.frame =
        decoder.decodeStructPointer(compositor_frame$.CompositorFrame);
    val.hitTestRegionList =
        decoder.decodeStructPointer(hit_test_region_list$.HitTestRegionList);
    val.submitTime =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  CompositorFrameSink_SubmitCompositorFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_SubmitCompositorFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.localSurfaceId);
    encoder.encodeStructPointer(compositor_frame$.CompositorFrame, val.frame);
    encoder.encodeStructPointer(hit_test_region_list$.HitTestRegionList, val.hitTestRegionList);
    encoder.encodeStruct(codec.Uint64, val.submitTime);
  };
  function CompositorFrameSink_DidNotProduceFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_DidNotProduceFrame_Params.prototype.initDefaults_ = function() {
    this.ack = null;
  };
  CompositorFrameSink_DidNotProduceFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_DidNotProduceFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_DidNotProduceFrame_Params.ack
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, begin_frame_args$.BeginFrameAck, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSink_DidNotProduceFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSink_DidNotProduceFrame_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_DidNotProduceFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.ack =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameAck);
    return val;
  };

  CompositorFrameSink_DidNotProduceFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_DidNotProduceFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameAck, val.ack);
  };
  function CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.prototype.initDefaults_ = function() {
  };
  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.encodedSize = codec.kStructHeaderSize + 0;

  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CompositorFrameSink_BindLayerContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSink_BindLayerContext_Params.prototype.initDefaults_ = function() {
    this.context = null;
    this.settings = null;
  };
  CompositorFrameSink_BindLayerContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSink_BindLayerContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_BindLayerContext_Params.context
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, layer_context$.PendingLayerContext, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSink_BindLayerContext_Params.settings
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, LayerContextSettings, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSink_BindLayerContext_Params.encodedSize = codec.kStructHeaderSize + 16;

  CompositorFrameSink_BindLayerContext_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSink_BindLayerContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStructPointer(layer_context$.PendingLayerContext);
    val.settings =
        decoder.decodeStructPointer(LayerContextSettings);
    return val;
  };

  CompositorFrameSink_BindLayerContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSink_BindLayerContext_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(layer_context$.PendingLayerContext, val.context);
    encoder.encodeStructPointer(LayerContextSettings, val.settings);
  };
  function CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.prototype.initDefaults_ = function() {
    this.resources = null;
  };
  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.resources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(returned_resource$.ReturnedResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resources =
        decoder.decodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource));
    return val;
  };

  CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource), val.resources);
  };
  function CompositorFrameSinkClient_OnBeginFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_OnBeginFrame_Params.prototype.initDefaults_ = function() {
    this.args = null;
    this.details = null;
    this.resources = null;
  };
  CompositorFrameSinkClient_OnBeginFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_OnBeginFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_OnBeginFrame_Params.args
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, begin_frame_args$.BeginFrameArgs, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_OnBeginFrame_Params.details
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_OnBeginFrame_Params.resources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(returned_resource$.ReturnedResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_OnBeginFrame_Params.encodedSize = codec.kStructHeaderSize + 24;

  CompositorFrameSinkClient_OnBeginFrame_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_OnBeginFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.args =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameArgs);
    val.details =
        decoder.decodeMapPointer(codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails));
    val.resources =
        decoder.decodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource));
    return val;
  };

  CompositorFrameSinkClient_OnBeginFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_OnBeginFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameArgs, val.args);
    encoder.encodeMapPointer(codec.Uint32, new codec.PointerTo(frame_timing_details$.FrameTimingDetails), val.details);
    encoder.encodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource), val.resources);
  };
  function CompositorFrameSinkClient_OnBeginFramePausedChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.prototype.initDefaults_ = function() {
    this.paused = false;
  };
  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_OnBeginFramePausedChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.paused = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.paused & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CompositorFrameSinkClient_ReclaimResources_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_ReclaimResources_Params.prototype.initDefaults_ = function() {
    this.resources = null;
  };
  CompositorFrameSinkClient_ReclaimResources_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_ReclaimResources_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_ReclaimResources_Params.resources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(returned_resource$.ReturnedResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_ReclaimResources_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkClient_ReclaimResources_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_ReclaimResources_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resources =
        decoder.decodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource));
    return val;
  };

  CompositorFrameSinkClient_ReclaimResources_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_ReclaimResources_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(returned_resource$.ReturnedResource), val.resources);
  };
  function CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.prototype.initDefaults_ = function() {
    this.sequenceId = 0;
  };
  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sequenceId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.sequenceId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CompositorFrameSinkClient_OnSurfaceEvicted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameSinkClient_OnSurfaceEvicted_Params.prototype.initDefaults_ = function() {
    this.localSurfaceId = null;
  };
  CompositorFrameSinkClient_OnSurfaceEvicted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameSinkClient_OnSurfaceEvicted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameSinkClient_OnSurfaceEvicted_Params.localSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, local_surface_id$.LocalSurfaceId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameSinkClient_OnSurfaceEvicted_Params.encodedSize = codec.kStructHeaderSize + 8;

  CompositorFrameSinkClient_OnSurfaceEvicted_Params.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameSinkClient_OnSurfaceEvicted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    return val;
  };

  CompositorFrameSinkClient_OnSurfaceEvicted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameSinkClient_OnSurfaceEvicted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.localSurfaceId);
  };
  var kCompositorFrameSink_SetParams_Name = 0;
  var kCompositorFrameSink_SetNeedsBeginFrame_Name = 1;
  var kCompositorFrameSink_SubmitCompositorFrame_Name = 2;
  var kCompositorFrameSink_DidNotProduceFrame_Name = 3;
  var kCompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Name = 4;
  var kCompositorFrameSink_BindLayerContext_Name = 5;

  function CompositorFrameSinkPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CompositorFrameSink,
                                                   handleOrPtrInfo);
  }

  function CompositorFrameSinkAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CompositorFrameSink, associatedInterfacePtrInfo);
  }

  CompositorFrameSinkAssociatedPtr.prototype =
      Object.create(CompositorFrameSinkPtr.prototype);
  CompositorFrameSinkAssociatedPtr.prototype.constructor =
      CompositorFrameSinkAssociatedPtr;

  function CompositorFrameSinkProxy(receiver) {
    this.receiver_ = receiver;
  }
  CompositorFrameSinkPtr.prototype.setParams = function() {
    return CompositorFrameSinkProxy.prototype.setParams
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.setParams = function(params) {
    var params_ = new CompositorFrameSink_SetParams_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSink_SetParams_Name,
        codec.align(CompositorFrameSink_SetParams_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSink_SetParams_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkPtr.prototype.setNeedsBeginFrame = function() {
    return CompositorFrameSinkProxy.prototype.setNeedsBeginFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.setNeedsBeginFrame = function(needsBeginFrame) {
    var params_ = new CompositorFrameSink_SetNeedsBeginFrame_Params();
    params_.needsBeginFrame = needsBeginFrame;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSink_SetNeedsBeginFrame_Name,
        codec.align(CompositorFrameSink_SetNeedsBeginFrame_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSink_SetNeedsBeginFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkPtr.prototype.submitCompositorFrame = function() {
    return CompositorFrameSinkProxy.prototype.submitCompositorFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.submitCompositorFrame = function(localSurfaceId, frame, hitTestRegionList, submitTime) {
    var params_ = new CompositorFrameSink_SubmitCompositorFrame_Params();
    params_.localSurfaceId = localSurfaceId;
    params_.frame = frame;
    params_.hitTestRegionList = hitTestRegionList;
    params_.submitTime = submitTime;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSink_SubmitCompositorFrame_Name,
        codec.align(CompositorFrameSink_SubmitCompositorFrame_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSink_SubmitCompositorFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkPtr.prototype.didNotProduceFrame = function() {
    return CompositorFrameSinkProxy.prototype.didNotProduceFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.didNotProduceFrame = function(ack) {
    var params_ = new CompositorFrameSink_DidNotProduceFrame_Params();
    params_.ack = ack;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSink_DidNotProduceFrame_Name,
        codec.align(CompositorFrameSink_DidNotProduceFrame_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSink_DidNotProduceFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkPtr.prototype.notifyNewLocalSurfaceIdExpectedWhilePaused = function() {
    return CompositorFrameSinkProxy.prototype.notifyNewLocalSurfaceIdExpectedWhilePaused
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.notifyNewLocalSurfaceIdExpectedWhilePaused = function() {
    var params_ = new CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params();
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Name,
        codec.align(CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkPtr.prototype.bindLayerContext = function() {
    return CompositorFrameSinkProxy.prototype.bindLayerContext
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkProxy.prototype.bindLayerContext = function(context, settings) {
    var params_ = new CompositorFrameSink_BindLayerContext_Params();
    params_.context = context;
    params_.settings = settings;
    var builder = new codec.MessageV2Builder(
        kCompositorFrameSink_BindLayerContext_Name,
        codec.align(CompositorFrameSink_BindLayerContext_Params.encodedSize));
    builder.setPayload(CompositorFrameSink_BindLayerContext_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CompositorFrameSinkStub(delegate) {
    this.delegate_ = delegate;
  }
  CompositorFrameSinkStub.prototype.setParams = function(params) {
    return this.delegate_ && this.delegate_.setParams && this.delegate_.setParams(params);
  }
  CompositorFrameSinkStub.prototype.setNeedsBeginFrame = function(needsBeginFrame) {
    return this.delegate_ && this.delegate_.setNeedsBeginFrame && this.delegate_.setNeedsBeginFrame(needsBeginFrame);
  }
  CompositorFrameSinkStub.prototype.submitCompositorFrame = function(localSurfaceId, frame, hitTestRegionList, submitTime) {
    return this.delegate_ && this.delegate_.submitCompositorFrame && this.delegate_.submitCompositorFrame(localSurfaceId, frame, hitTestRegionList, submitTime);
  }
  CompositorFrameSinkStub.prototype.didNotProduceFrame = function(ack) {
    return this.delegate_ && this.delegate_.didNotProduceFrame && this.delegate_.didNotProduceFrame(ack);
  }
  CompositorFrameSinkStub.prototype.notifyNewLocalSurfaceIdExpectedWhilePaused = function() {
    return this.delegate_ && this.delegate_.notifyNewLocalSurfaceIdExpectedWhilePaused && this.delegate_.notifyNewLocalSurfaceIdExpectedWhilePaused();
  }
  CompositorFrameSinkStub.prototype.bindLayerContext = function(context, settings) {
    return this.delegate_ && this.delegate_.bindLayerContext && this.delegate_.bindLayerContext(context, settings);
  }

  CompositorFrameSinkStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCompositorFrameSink_SetParams_Name:
      var params = reader.decodeStruct(CompositorFrameSink_SetParams_Params);
      this.setParams(params.params);
      return true;
    case kCompositorFrameSink_SetNeedsBeginFrame_Name:
      var params = reader.decodeStruct(CompositorFrameSink_SetNeedsBeginFrame_Params);
      this.setNeedsBeginFrame(params.needsBeginFrame);
      return true;
    case kCompositorFrameSink_SubmitCompositorFrame_Name:
      var params = reader.decodeStruct(CompositorFrameSink_SubmitCompositorFrame_Params);
      this.submitCompositorFrame(params.localSurfaceId, params.frame, params.hitTestRegionList, params.submitTime);
      return true;
    case kCompositorFrameSink_DidNotProduceFrame_Name:
      var params = reader.decodeStruct(CompositorFrameSink_DidNotProduceFrame_Params);
      this.didNotProduceFrame(params.ack);
      return true;
    case kCompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Name:
      var params = reader.decodeStruct(CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params);
      this.notifyNewLocalSurfaceIdExpectedWhilePaused();
      return true;
    case kCompositorFrameSink_BindLayerContext_Name:
      var params = reader.decodeStruct(CompositorFrameSink_BindLayerContext_Params);
      this.bindLayerContext(params.context, params.settings);
      return true;
    default:
      return false;
    }
  };

  CompositorFrameSinkStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCompositorFrameSinkRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCompositorFrameSink_SetParams_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_SetParams_Params;
      break;
      case kCompositorFrameSink_SetNeedsBeginFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_SetNeedsBeginFrame_Params;
      break;
      case kCompositorFrameSink_SubmitCompositorFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_SubmitCompositorFrame_Params;
      break;
      case kCompositorFrameSink_DidNotProduceFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_DidNotProduceFrame_Params;
      break;
      case kCompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_NotifyNewLocalSurfaceIdExpectedWhilePaused_Params;
      break;
      case kCompositorFrameSink_BindLayerContext_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSink_BindLayerContext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCompositorFrameSinkResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CompositorFrameSink = {
    name: 'viz.mojom.CompositorFrameSink',
    kVersion: 0,
    ptrClass: CompositorFrameSinkPtr,
    proxyClass: CompositorFrameSinkProxy,
    stubClass: CompositorFrameSinkStub,
    validateRequest: validateCompositorFrameSinkRequest,
    validateResponse: null,
  };
  CompositorFrameSinkStub.prototype.validator = validateCompositorFrameSinkRequest;
  CompositorFrameSinkProxy.prototype.validator = null;
  var kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name = 0;
  var kCompositorFrameSinkClient_OnBeginFrame_Name = 1;
  var kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name = 2;
  var kCompositorFrameSinkClient_ReclaimResources_Name = 3;
  var kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name = 4;
  var kCompositorFrameSinkClient_OnSurfaceEvicted_Name = 5;

  function CompositorFrameSinkClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CompositorFrameSinkClient,
                                                   handleOrPtrInfo);
  }

  function CompositorFrameSinkClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CompositorFrameSinkClient, associatedInterfacePtrInfo);
  }

  CompositorFrameSinkClientAssociatedPtr.prototype =
      Object.create(CompositorFrameSinkClientPtr.prototype);
  CompositorFrameSinkClientAssociatedPtr.prototype.constructor =
      CompositorFrameSinkClientAssociatedPtr;

  function CompositorFrameSinkClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  CompositorFrameSinkClientPtr.prototype.didReceiveCompositorFrameAck = function() {
    return CompositorFrameSinkClientProxy.prototype.didReceiveCompositorFrameAck
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.didReceiveCompositorFrameAck = function(resources) {
    var params_ = new CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params();
    params_.resources = resources;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name,
        codec.align(CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkClientPtr.prototype.onBeginFrame = function() {
    return CompositorFrameSinkClientProxy.prototype.onBeginFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.onBeginFrame = function(args, details, resources) {
    var params_ = new CompositorFrameSinkClient_OnBeginFrame_Params();
    params_.args = args;
    params_.details = details;
    params_.resources = resources;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_OnBeginFrame_Name,
        codec.align(CompositorFrameSinkClient_OnBeginFrame_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_OnBeginFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkClientPtr.prototype.onBeginFramePausedChanged = function() {
    return CompositorFrameSinkClientProxy.prototype.onBeginFramePausedChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.onBeginFramePausedChanged = function(paused) {
    var params_ = new CompositorFrameSinkClient_OnBeginFramePausedChanged_Params();
    params_.paused = paused;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name,
        codec.align(CompositorFrameSinkClient_OnBeginFramePausedChanged_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_OnBeginFramePausedChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkClientPtr.prototype.reclaimResources = function() {
    return CompositorFrameSinkClientProxy.prototype.reclaimResources
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.reclaimResources = function(resources) {
    var params_ = new CompositorFrameSinkClient_ReclaimResources_Params();
    params_.resources = resources;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_ReclaimResources_Name,
        codec.align(CompositorFrameSinkClient_ReclaimResources_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_ReclaimResources_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkClientPtr.prototype.onCompositorFrameTransitionDirectiveProcessed = function() {
    return CompositorFrameSinkClientProxy.prototype.onCompositorFrameTransitionDirectiveProcessed
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.onCompositorFrameTransitionDirectiveProcessed = function(sequenceId) {
    var params_ = new CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params();
    params_.sequenceId = sequenceId;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name,
        codec.align(CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CompositorFrameSinkClientPtr.prototype.onSurfaceEvicted = function() {
    return CompositorFrameSinkClientProxy.prototype.onSurfaceEvicted
        .apply(this.ptr.getProxy(), arguments);
  };

  CompositorFrameSinkClientProxy.prototype.onSurfaceEvicted = function(localSurfaceId) {
    var params_ = new CompositorFrameSinkClient_OnSurfaceEvicted_Params();
    params_.localSurfaceId = localSurfaceId;
    var builder = new codec.MessageV0Builder(
        kCompositorFrameSinkClient_OnSurfaceEvicted_Name,
        codec.align(CompositorFrameSinkClient_OnSurfaceEvicted_Params.encodedSize));
    builder.encodeStruct(CompositorFrameSinkClient_OnSurfaceEvicted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CompositorFrameSinkClientStub(delegate) {
    this.delegate_ = delegate;
  }
  CompositorFrameSinkClientStub.prototype.didReceiveCompositorFrameAck = function(resources) {
    return this.delegate_ && this.delegate_.didReceiveCompositorFrameAck && this.delegate_.didReceiveCompositorFrameAck(resources);
  }
  CompositorFrameSinkClientStub.prototype.onBeginFrame = function(args, details, resources) {
    return this.delegate_ && this.delegate_.onBeginFrame && this.delegate_.onBeginFrame(args, details, resources);
  }
  CompositorFrameSinkClientStub.prototype.onBeginFramePausedChanged = function(paused) {
    return this.delegate_ && this.delegate_.onBeginFramePausedChanged && this.delegate_.onBeginFramePausedChanged(paused);
  }
  CompositorFrameSinkClientStub.prototype.reclaimResources = function(resources) {
    return this.delegate_ && this.delegate_.reclaimResources && this.delegate_.reclaimResources(resources);
  }
  CompositorFrameSinkClientStub.prototype.onCompositorFrameTransitionDirectiveProcessed = function(sequenceId) {
    return this.delegate_ && this.delegate_.onCompositorFrameTransitionDirectiveProcessed && this.delegate_.onCompositorFrameTransitionDirectiveProcessed(sequenceId);
  }
  CompositorFrameSinkClientStub.prototype.onSurfaceEvicted = function(localSurfaceId) {
    return this.delegate_ && this.delegate_.onSurfaceEvicted && this.delegate_.onSurfaceEvicted(localSurfaceId);
  }

  CompositorFrameSinkClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params);
      this.didReceiveCompositorFrameAck(params.resources);
      return true;
    case kCompositorFrameSinkClient_OnBeginFrame_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_OnBeginFrame_Params);
      this.onBeginFrame(params.args, params.details, params.resources);
      return true;
    case kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_OnBeginFramePausedChanged_Params);
      this.onBeginFramePausedChanged(params.paused);
      return true;
    case kCompositorFrameSinkClient_ReclaimResources_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_ReclaimResources_Params);
      this.reclaimResources(params.resources);
      return true;
    case kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params);
      this.onCompositorFrameTransitionDirectiveProcessed(params.sequenceId);
      return true;
    case kCompositorFrameSinkClient_OnSurfaceEvicted_Name:
      var params = reader.decodeStruct(CompositorFrameSinkClient_OnSurfaceEvicted_Params);
      this.onSurfaceEvicted(params.localSurfaceId);
      return true;
    default:
      return false;
    }
  };

  CompositorFrameSinkClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCompositorFrameSinkClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params;
      break;
      case kCompositorFrameSinkClient_OnBeginFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_OnBeginFrame_Params;
      break;
      case kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_OnBeginFramePausedChanged_Params;
      break;
      case kCompositorFrameSinkClient_ReclaimResources_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_ReclaimResources_Params;
      break;
      case kCompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_OnCompositorFrameTransitionDirectiveProcessed_Params;
      break;
      case kCompositorFrameSinkClient_OnSurfaceEvicted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CompositorFrameSinkClient_OnSurfaceEvicted_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCompositorFrameSinkClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CompositorFrameSinkClient = {
    name: 'viz.mojom.CompositorFrameSinkClient',
    kVersion: 0,
    ptrClass: CompositorFrameSinkClientPtr,
    proxyClass: CompositorFrameSinkClientProxy,
    stubClass: CompositorFrameSinkClientStub,
    validateRequest: validateCompositorFrameSinkClientRequest,
    validateResponse: null,
  };
  CompositorFrameSinkClientStub.prototype.validator = validateCompositorFrameSinkClientRequest;
  CompositorFrameSinkClientProxy.prototype.validator = null;
  exports.LayerContextSettings = LayerContextSettings;
  exports.CompositorFrameSinkParams = CompositorFrameSinkParams;
  exports.CompositorFrameSink = CompositorFrameSink;
  exports.CompositorFrameSinkPtr = CompositorFrameSinkPtr;
  exports.CompositorFrameSinkAssociatedPtr = CompositorFrameSinkAssociatedPtr;
  exports.CompositorFrameSinkClient = CompositorFrameSinkClient;
  exports.CompositorFrameSinkClientPtr = CompositorFrameSinkClientPtr;
  exports.CompositorFrameSinkClientAssociatedPtr = CompositorFrameSinkClientAssociatedPtr;
})();