// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-internal.h"
#include "cc/mojom/scrollbar_animator.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/thread.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::LayerContextSettingsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LayerContextSettingsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::LayerContextSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->draw_mode_is_gpu = Traits::draw_mode_is_gpu(input);

      fragment->enable_early_damage_check = Traits::enable_early_damage_check(input);

      fragment->damaged_frame_limit = Traits::damaged_frame_limit(input);

      
      mojo::internal::Serialize<::cc::mojom::ScrollbarAnimator>(
        Traits::scrollbar_animator(input),
        &fragment->scrollbar_animator);

      decltype(Traits::scrollbar_fade_delay(input)) in_scrollbar_fade_delay = Traits::scrollbar_fade_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_fade_delay)::BaseType> scrollbar_fade_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_scrollbar_fade_delay,
        scrollbar_fade_delay_fragment);

      fragment->scrollbar_fade_delay.Set(
          scrollbar_fade_delay_fragment.is_null() ? nullptr : scrollbar_fade_delay_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_fade_delay.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_fade_delay in LayerContextSettings struct");

      decltype(Traits::scrollbar_fade_duration(input)) in_scrollbar_fade_duration = Traits::scrollbar_fade_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_fade_duration)::BaseType> scrollbar_fade_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_scrollbar_fade_duration,
        scrollbar_fade_duration_fragment);

      fragment->scrollbar_fade_duration.Set(
          scrollbar_fade_duration_fragment.is_null() ? nullptr : scrollbar_fade_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_fade_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_fade_duration in LayerContextSettings struct");

      decltype(Traits::scrollbar_thinning_duration(input)) in_scrollbar_thinning_duration = Traits::scrollbar_thinning_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_thinning_duration)::BaseType> scrollbar_thinning_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_scrollbar_thinning_duration,
        scrollbar_thinning_duration_fragment);

      fragment->scrollbar_thinning_duration.Set(
          scrollbar_thinning_duration_fragment.is_null() ? nullptr : scrollbar_thinning_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_thinning_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_thinning_duration in LayerContextSettings struct");

      fragment->idle_thickness_scale = Traits::idle_thickness_scale(input);

      fragment->top_controls_show_threshold = Traits::top_controls_show_threshold(input);

      fragment->top_controls_hide_threshold = Traits::top_controls_hide_threshold(input);

      decltype(Traits::minimum_occlusion_tracking_size(input)) in_minimum_occlusion_tracking_size = Traits::minimum_occlusion_tracking_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->minimum_occlusion_tracking_size)::BaseType> minimum_occlusion_tracking_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_minimum_occlusion_tracking_size,
        minimum_occlusion_tracking_size_fragment);

      fragment->minimum_occlusion_tracking_size.Set(
          minimum_occlusion_tracking_size_fragment.is_null() ? nullptr : minimum_occlusion_tracking_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->minimum_occlusion_tracking_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null minimum_occlusion_tracking_size in LayerContextSettings struct");

      fragment->enable_edge_anti_aliasing = Traits::enable_edge_anti_aliasing(input);

      fragment->enable_backface_visibility_interop = Traits::enable_backface_visibility_interop(input);

      fragment->enable_fluent_scrollbar = Traits::enable_fluent_scrollbar(input);

      fragment->enable_fluent_overlay_scrollbar = Traits::enable_fluent_overlay_scrollbar(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::CompositorFrameSinkParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameSinkParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameSinkParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->wants_animate_only_begin_frames = Traits::wants_animate_only_begin_frames(input);

      fragment->auto_needs_begin_frame = Traits::auto_needs_begin_frame(input);

      fragment->no_compositor_frame_acks = Traits::no_compositor_frame_acks(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_SEND_VALIDATION_H_