// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h"
#include "ui/gfx/mojom/delegated_ink_metadata.mojom-shared.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_deadline.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-shared.h"
#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-shared.h"
#include "services/viz/public/mojom/compositing/selection.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/overlay_transform.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"




#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorFrameMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->device_scale_factor = Traits::device_scale_factor(input);

    decltype(Traits::root_scroll_offset(input)) in_root_scroll_offset = Traits::root_scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_scroll_offset)::BaseType> root_scroll_offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_root_scroll_offset,
      root_scroll_offset_fragment);

    fragment->root_scroll_offset.Set(
        root_scroll_offset_fragment.is_null() ? nullptr : root_scroll_offset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->root_scroll_offset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_scroll_offset in CompositorFrameMetadata struct");

    fragment->page_scale_factor = Traits::page_scale_factor(input);

    decltype(Traits::scrollable_viewport_size(input)) in_scrollable_viewport_size = Traits::scrollable_viewport_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scrollable_viewport_size)::BaseType> scrollable_viewport_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_scrollable_viewport_size,
      scrollable_viewport_size_fragment);

    fragment->scrollable_viewport_size.Set(
        scrollable_viewport_size_fragment.is_null() ? nullptr : scrollable_viewport_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scrollable_viewport_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scrollable_viewport_size in CompositorFrameMetadata struct");

    decltype(Traits::visible_viewport_size(input)) in_visible_viewport_size = Traits::visible_viewport_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_viewport_size)::BaseType> visible_viewport_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_visible_viewport_size,
      visible_viewport_size_fragment);

    fragment->visible_viewport_size.Set(
        visible_viewport_size_fragment.is_null() ? nullptr : visible_viewport_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_viewport_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_viewport_size in CompositorFrameMetadata struct");

    
    mojo::internal::Serialize<::gfx::mojom::ContentColorUsage>(
      Traits::content_color_usage(input),
      &fragment->content_color_usage);

    fragment->may_contain_video = Traits::may_contain_video(input);

    fragment->may_throttle_if_undrawn_frames = Traits::may_throttle_if_undrawn_frames(input);

    fragment->is_handling_interaction = Traits::is_handling_interaction(input);

    fragment->is_handling_animation = Traits::is_handling_animation(input);

    decltype(Traits::root_background_color(input)) in_root_background_color = Traits::root_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_background_color)::BaseType> root_background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColor4fDataView>(
      in_root_background_color,
      root_background_color_fragment);

    fragment->root_background_color.Set(
        root_background_color_fragment.is_null() ? nullptr : root_background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->root_background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null root_background_color in CompositorFrameMetadata struct");

    decltype(Traits::latency_info(input)) in_latency_info = Traits::latency_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency_info)::BaseType>
        latency_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& latency_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::LatencyInfoDataView>>(
      in_latency_info,
      latency_info_fragment,
      &latency_info_validate_params);

    fragment->latency_info.Set(
        latency_info_fragment.is_null() ? nullptr : latency_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->latency_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null latency_info in CompositorFrameMetadata struct");

    decltype(Traits::referenced_surfaces(input)) in_referenced_surfaces = Traits::referenced_surfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referenced_surfaces)::BaseType>
        referenced_surfaces_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& referenced_surfaces_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>>(
      in_referenced_surfaces,
      referenced_surfaces_fragment,
      &referenced_surfaces_validate_params);

    fragment->referenced_surfaces.Set(
        referenced_surfaces_fragment.is_null() ? nullptr : referenced_surfaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referenced_surfaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referenced_surfaces in CompositorFrameMetadata struct");

    decltype(Traits::deadline(input)) in_deadline = Traits::deadline(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deadline)::BaseType> deadline_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FrameDeadlineDataView>(
      in_deadline,
      deadline_fragment);

    fragment->deadline.Set(
        deadline_fragment.is_null() ? nullptr : deadline_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->deadline.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null deadline in CompositorFrameMetadata struct");

    decltype(Traits::activation_dependencies(input)) in_activation_dependencies = Traits::activation_dependencies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->activation_dependencies)::BaseType>
        activation_dependencies_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& activation_dependencies_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>>(
      in_activation_dependencies,
      activation_dependencies_fragment,
      &activation_dependencies_validate_params);

    fragment->activation_dependencies.Set(
        activation_dependencies_fragment.is_null() ? nullptr : activation_dependencies_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->activation_dependencies.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activation_dependencies in CompositorFrameMetadata struct");

    decltype(Traits::begin_frame_ack(input)) in_begin_frame_ack = Traits::begin_frame_ack(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->begin_frame_ack)::BaseType> begin_frame_ack_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
      in_begin_frame_ack,
      begin_frame_ack_fragment);

    fragment->begin_frame_ack.Set(
        begin_frame_ack_fragment.is_null() ? nullptr : begin_frame_ack_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->begin_frame_ack.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null begin_frame_ack in CompositorFrameMetadata struct");

    fragment->frame_token = Traits::frame_token(input);

    fragment->send_frame_token_to_embedder = Traits::send_frame_token_to_embedder(input);

    fragment->top_controls_visible_height_set = Traits::top_controls_visible_height_set(input);

    fragment->top_controls_visible_height = Traits::top_controls_visible_height(input);

    fragment->min_page_scale_factor = Traits::min_page_scale_factor(input);

    
    mojo::internal::Serialize<::gfx::mojom::OverlayTransform>(
      Traits::display_transform_hint(input),
      &fragment->display_transform_hint);

    fragment->is_mobile_optimized = Traits::is_mobile_optimized(input);

    decltype(Traits::delegated_ink_metadata(input)) in_delegated_ink_metadata = Traits::delegated_ink_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->delegated_ink_metadata)::BaseType> delegated_ink_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::DelegatedInkMetadataDataView>(
      in_delegated_ink_metadata,
      delegated_ink_metadata_fragment);

    fragment->delegated_ink_metadata.Set(
        delegated_ink_metadata_fragment.is_null() ? nullptr : delegated_ink_metadata_fragment.data());

    decltype(Traits::transition_directives(input)) in_transition_directives = Traits::transition_directives(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transition_directives)::BaseType>
        transition_directives_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transition_directives_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveDataView>>(
      in_transition_directives,
      transition_directives_fragment,
      &transition_directives_validate_params);

    fragment->transition_directives.Set(
        transition_directives_fragment.is_null() ? nullptr : transition_directives_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transition_directives.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transition_directives in CompositorFrameMetadata struct");

    decltype(Traits::capture_bounds(input)) in_capture_bounds = Traits::capture_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->capture_bounds)::BaseType> capture_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::RegionCaptureBoundsDataView>(
      in_capture_bounds,
      capture_bounds_fragment);

    fragment->capture_bounds.Set(
        capture_bounds_fragment.is_null() ? nullptr : capture_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->capture_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capture_bounds in CompositorFrameMetadata struct");

    fragment->has_shared_element_resources = Traits::has_shared_element_resources(input);

    decltype(Traits::screenshot_destination(input)) in_screenshot_destination = Traits::screenshot_destination(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screenshot_destination)::BaseType> screenshot_destination_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView>(
      in_screenshot_destination,
      screenshot_destination_fragment);

    fragment->screenshot_destination.Set(
        screenshot_destination_fragment.is_null() ? nullptr : screenshot_destination_fragment.data());

    fragment->is_software = Traits::is_software(input);

    decltype(Traits::offset_tag_definitions(input)) in_offset_tag_definitions = Traits::offset_tag_definitions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset_tag_definitions)::BaseType>
        offset_tag_definitions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& offset_tag_definitions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::OffsetTagDefinitionDataView>>(
      in_offset_tag_definitions,
      offset_tag_definitions_fragment,
      &offset_tag_definitions_validate_params);

    fragment->offset_tag_definitions.Set(
        offset_tag_definitions_fragment.is_null() ? nullptr : offset_tag_definitions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->offset_tag_definitions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offset_tag_definitions in CompositorFrameMetadata struct");

    decltype(Traits::offset_tag_values(input)) in_offset_tag_values = Traits::offset_tag_values(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset_tag_values)::BaseType>
        offset_tag_values_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& offset_tag_values_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::OffsetTagValueDataView>>(
      in_offset_tag_values,
      offset_tag_values_fragment,
      &offset_tag_values_validate_params);

    fragment->offset_tag_values.Set(
        offset_tag_values_fragment.is_null() ? nullptr : offset_tag_values_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->offset_tag_values.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offset_tag_values in CompositorFrameMetadata struct");

    decltype(Traits::frame_interval_inputs(input)) in_frame_interval_inputs = Traits::frame_interval_inputs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interval_inputs)::BaseType> frame_interval_inputs_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::FrameIntervalInputsDataView>(
      in_frame_interval_inputs,
      frame_interval_inputs_fragment);

    fragment->frame_interval_inputs.Set(
        frame_interval_inputs_fragment.is_null() ? nullptr : frame_interval_inputs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_interval_inputs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_interval_inputs in CompositorFrameMetadata struct");

    decltype(Traits::trees_in_viz_timing(input)) in_trees_in_viz_timing = Traits::trees_in_viz_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trees_in_viz_timing)::BaseType> trees_in_viz_timing_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::TreesInVizTimingDataView>(
      in_trees_in_viz_timing,
      trees_in_viz_timing_fragment);

    fragment->trees_in_viz_timing.Set(
        trees_in_viz_timing_fragment.is_null() ? nullptr : trees_in_viz_timing_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trees_in_viz_timing.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trees_in_viz_timing in CompositorFrameMetadata struct");
  }

  static bool Deserialize(::viz::mojom::internal::CompositorFrameMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorFrameMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void CompositorFrameMetadataDataView::GetRootScrollOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->root_scroll_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetScrollableViewportSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->scrollable_viewport_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetVisibleViewportSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->visible_viewport_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetRootBackgroundColorDataView(
    ::skia::mojom::SkColor4fDataView* output) {
  auto pointer = data_->root_background_color.Get();
  *output = ::skia::mojom::SkColor4fDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetLatencyInfoDataView(
    mojo::ArrayDataView<::ui::mojom::LatencyInfoDataView>* output) {
  auto pointer = data_->latency_info.Get();
  *output = mojo::ArrayDataView<::ui::mojom::LatencyInfoDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetReferencedSurfacesDataView(
    mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>* output) {
  auto pointer = data_->referenced_surfaces.Get();
  *output = mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetDeadlineDataView(
    ::viz::mojom::FrameDeadlineDataView* output) {
  auto pointer = data_->deadline.Get();
  *output = ::viz::mojom::FrameDeadlineDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetActivationDependenciesDataView(
    mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>* output) {
  auto pointer = data_->activation_dependencies.Get();
  *output = mojo::ArrayDataView<::viz::mojom::SurfaceIdDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetBeginFrameAckDataView(
    ::viz::mojom::BeginFrameAckDataView* output) {
  auto pointer = data_->begin_frame_ack.Get();
  *output = ::viz::mojom::BeginFrameAckDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetDelegatedInkMetadataDataView(
    ::gfx::mojom::DelegatedInkMetadataDataView* output) {
  auto pointer = data_->delegated_ink_metadata.Get();
  *output = ::gfx::mojom::DelegatedInkMetadataDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetTransitionDirectivesDataView(
    mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveDataView>* output) {
  auto pointer = data_->transition_directives.Get();
  *output = mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetCaptureBoundsDataView(
    ::viz::mojom::RegionCaptureBoundsDataView* output) {
  auto pointer = data_->capture_bounds.Get();
  *output = ::viz::mojom::RegionCaptureBoundsDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetScreenshotDestinationDataView(
    ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView* output) {
  auto pointer = data_->screenshot_destination.Get();
  *output = ::blink::mojom::SameDocNavigationScreenshotDestinationTokenDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetOffsetTagDefinitionsDataView(
    mojo::ArrayDataView<::viz::mojom::OffsetTagDefinitionDataView>* output) {
  auto pointer = data_->offset_tag_definitions.Get();
  *output = mojo::ArrayDataView<::viz::mojom::OffsetTagDefinitionDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetOffsetTagValuesDataView(
    mojo::ArrayDataView<::viz::mojom::OffsetTagValueDataView>* output) {
  auto pointer = data_->offset_tag_values.Get();
  *output = mojo::ArrayDataView<::viz::mojom::OffsetTagValueDataView>(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetFrameIntervalInputsDataView(
    ::viz::mojom::FrameIntervalInputsDataView* output) {
  auto pointer = data_->frame_interval_inputs.Get();
  *output = ::viz::mojom::FrameIntervalInputsDataView(pointer, message_);
}
inline void CompositorFrameMetadataDataView::GetTreesInVizTimingDataView(
    ::viz::mojom::TreesInVizTimingDataView* output) {
  auto pointer = data_->trees_in_viz_timing.Get();
  *output = ::viz::mojom::TreesInVizTimingDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_SHARED_H_