// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-blink.h"
#include "ui/gfx/mojom/delegated_ink_metadata.mojom-blink.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-blink.h"
#include "services/viz/public/mojom/compositing/frame_deadline.mojom-blink.h"
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-blink.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-blink.h"
#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-blink.h"
#include "services/viz/public/mojom/compositing/selection.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-blink.h"
#include "ui/gfx/mojom/overlay_transform.mojom-blink-forward.h"
#include "ui/latency/mojom/latency_info.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT CompositorFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrameMetadata, T>::value>;
  using DataView = CompositorFrameMetadataDataView;
  using Data_ = internal::CompositorFrameMetadata_Data;

  template <typename... Args>
  static CompositorFrameMetadataPtr New(Args&&... args) {
    return CompositorFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CompositorFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrameMetadata>::Convert(*this);
  }


  CompositorFrameMetadata();

  CompositorFrameMetadata(
      float device_scale_factor,
      const ::gfx::PointF& root_scroll_offset,
      float page_scale_factor,
      const ::gfx::SizeF& scrollable_viewport_size,
      const ::gfx::Size& visible_viewport_size,
      ::gfx::ContentColorUsage content_color_usage,
      bool may_contain_video,
      bool may_throttle_if_undrawn_frames,
      bool is_handling_interaction,
      bool is_handling_animation,
      const ::SkColor4f& root_background_color,
      ::blink::Vector<::ui::LatencyInfo> latency_info,
      ::blink::Vector<::viz::SurfaceRange> referenced_surfaces,
      ::viz::mojom::blink::FrameDeadlinePtr deadline,
      ::blink::Vector<::viz::SurfaceId> activation_dependencies,
      const ::viz::BeginFrameAck& begin_frame_ack,
      uint32_t frame_token,
      bool send_frame_token_to_embedder,
      bool top_controls_visible_height_set,
      float top_controls_visible_height,
      float min_page_scale_factor,
      ::gfx::mojom::blink::OverlayTransform display_transform_hint,
      bool is_mobile_optimized,
      ::std::unique_ptr<::gfx::DelegatedInkMetadata> delegated_ink_metadata,
      ::blink::Vector<::viz::mojom::blink::CompositorFrameTransitionDirectivePtr> transition_directives,
      const ::viz::RegionCaptureBounds& capture_bounds,
      bool has_shared_element_resources,
      const std::optional<::blink::SameDocNavigationScreenshotDestinationToken>& screenshot_destination,
      bool is_software,
      ::blink::Vector<::viz::mojom::blink::OffsetTagDefinitionPtr> offset_tag_definitions,
      ::blink::Vector<::viz::OffsetTagValue> offset_tag_values,
      ::viz::mojom::blink::FrameIntervalInputsPtr frame_interval_inputs,
      ::viz::TreesInVizTiming trees_in_viz_timing);

CompositorFrameMetadata(const CompositorFrameMetadata&) = delete;
CompositorFrameMetadata& operator=(const CompositorFrameMetadata&) = delete;

  ~CompositorFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFrameMetadataPtr>
  CompositorFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameMetadata::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameMetadata::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrameMetadata_UnserializedMessageContext<
            UserType, CompositorFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrameMetadata_UnserializedMessageContext<
            UserType, CompositorFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float device_scale_factor;
  
  ::gfx::PointF root_scroll_offset;
  
  float page_scale_factor;
  
  ::gfx::SizeF scrollable_viewport_size;
  
  ::gfx::Size visible_viewport_size;
  
  ::gfx::ContentColorUsage content_color_usage;
  
  bool may_contain_video;
  
  bool may_throttle_if_undrawn_frames;
  
  bool is_handling_interaction;
  
  bool is_handling_animation;
  
  ::SkColor4f root_background_color;
  
  ::blink::Vector<::ui::LatencyInfo> latency_info;
  
  ::blink::Vector<::viz::SurfaceRange> referenced_surfaces;
  
  ::viz::mojom::blink::FrameDeadlinePtr deadline;
  
  ::blink::Vector<::viz::SurfaceId> activation_dependencies;
  
  ::viz::BeginFrameAck begin_frame_ack;
  
  uint32_t frame_token;
  
  bool send_frame_token_to_embedder;
  
  bool top_controls_visible_height_set;
  
  float top_controls_visible_height;
  
  float min_page_scale_factor;
  
  ::gfx::mojom::blink::OverlayTransform display_transform_hint;
  
  bool is_mobile_optimized;
  
  ::std::unique_ptr<::gfx::DelegatedInkMetadata> delegated_ink_metadata;
  
  ::blink::Vector<::viz::mojom::blink::CompositorFrameTransitionDirectivePtr> transition_directives;
  
  ::viz::RegionCaptureBounds capture_bounds;
  
  bool has_shared_element_resources;
  
  std::optional<::blink::SameDocNavigationScreenshotDestinationToken> screenshot_destination;
  
  bool is_software;
  
  ::blink::Vector<::viz::mojom::blink::OffsetTagDefinitionPtr> offset_tag_definitions;
  
  ::blink::Vector<::viz::OffsetTagValue> offset_tag_values;
  
  ::viz::mojom::blink::FrameIntervalInputsPtr frame_interval_inputs;
  
  ::viz::TreesInVizTiming trees_in_viz_timing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorFrameMetadataPtr CompositorFrameMetadata::Clone() const {
  return New(
      mojo::Clone(device_scale_factor),
      mojo::Clone(root_scroll_offset),
      mojo::Clone(page_scale_factor),
      mojo::Clone(scrollable_viewport_size),
      mojo::Clone(visible_viewport_size),
      mojo::Clone(content_color_usage),
      mojo::Clone(may_contain_video),
      mojo::Clone(may_throttle_if_undrawn_frames),
      mojo::Clone(is_handling_interaction),
      mojo::Clone(is_handling_animation),
      mojo::Clone(root_background_color),
      mojo::Clone(latency_info),
      mojo::Clone(referenced_surfaces),
      mojo::Clone(deadline),
      mojo::Clone(activation_dependencies),
      mojo::Clone(begin_frame_ack),
      mojo::Clone(frame_token),
      mojo::Clone(send_frame_token_to_embedder),
      mojo::Clone(top_controls_visible_height_set),
      mojo::Clone(top_controls_visible_height),
      mojo::Clone(min_page_scale_factor),
      mojo::Clone(display_transform_hint),
      mojo::Clone(is_mobile_optimized),
      mojo::Clone(delegated_ink_metadata),
      mojo::Clone(transition_directives),
      mojo::Clone(capture_bounds),
      mojo::Clone(has_shared_element_resources),
      mojo::Clone(screenshot_destination),
      mojo::Clone(is_software),
      mojo::Clone(offset_tag_definitions),
      mojo::Clone(offset_tag_values),
      mojo::Clone(frame_interval_inputs),
      mojo::Clone(trees_in_viz_timing)
  );
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>*>
bool CompositorFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->root_scroll_offset, other_struct.root_scroll_offset))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->scrollable_viewport_size, other_struct.scrollable_viewport_size))
    return false;
  if (!mojo::Equals(this->visible_viewport_size, other_struct.visible_viewport_size))
    return false;
  if (!mojo::Equals(this->content_color_usage, other_struct.content_color_usage))
    return false;
  if (!mojo::Equals(this->may_contain_video, other_struct.may_contain_video))
    return false;
  if (!mojo::Equals(this->may_throttle_if_undrawn_frames, other_struct.may_throttle_if_undrawn_frames))
    return false;
  if (!mojo::Equals(this->is_handling_interaction, other_struct.is_handling_interaction))
    return false;
  if (!mojo::Equals(this->is_handling_animation, other_struct.is_handling_animation))
    return false;
  if (!mojo::Equals(this->root_background_color, other_struct.root_background_color))
    return false;
  if (!mojo::Equals(this->latency_info, other_struct.latency_info))
    return false;
  if (!mojo::Equals(this->referenced_surfaces, other_struct.referenced_surfaces))
    return false;
  if (!mojo::Equals(this->deadline, other_struct.deadline))
    return false;
  if (!mojo::Equals(this->activation_dependencies, other_struct.activation_dependencies))
    return false;
  if (!mojo::Equals(this->begin_frame_ack, other_struct.begin_frame_ack))
    return false;
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->send_frame_token_to_embedder, other_struct.send_frame_token_to_embedder))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height_set, other_struct.top_controls_visible_height_set))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height, other_struct.top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->min_page_scale_factor, other_struct.min_page_scale_factor))
    return false;
  if (!mojo::Equals(this->display_transform_hint, other_struct.display_transform_hint))
    return false;
  if (!mojo::Equals(this->is_mobile_optimized, other_struct.is_mobile_optimized))
    return false;
  if (!mojo::Equals(this->delegated_ink_metadata, other_struct.delegated_ink_metadata))
    return false;
  if (!mojo::Equals(this->transition_directives, other_struct.transition_directives))
    return false;
  if (!mojo::Equals(this->capture_bounds, other_struct.capture_bounds))
    return false;
  if (!mojo::Equals(this->has_shared_element_resources, other_struct.has_shared_element_resources))
    return false;
  if (!mojo::Equals(this->screenshot_destination, other_struct.screenshot_destination))
    return false;
  if (!mojo::Equals(this->is_software, other_struct.is_software))
    return false;
  if (!mojo::Equals(this->offset_tag_definitions, other_struct.offset_tag_definitions))
    return false;
  if (!mojo::Equals(this->offset_tag_values, other_struct.offset_tag_values))
    return false;
  if (!mojo::Equals(this->frame_interval_inputs, other_struct.frame_interval_inputs))
    return false;
  if (!mojo::Equals(this->trees_in_viz_timing, other_struct.trees_in_viz_timing))
    return false;
  return true;
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.root_scroll_offset < rhs.root_scroll_offset)
    return true;
  if (rhs.root_scroll_offset < lhs.root_scroll_offset)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.scrollable_viewport_size < rhs.scrollable_viewport_size)
    return true;
  if (rhs.scrollable_viewport_size < lhs.scrollable_viewport_size)
    return false;
  if (lhs.visible_viewport_size < rhs.visible_viewport_size)
    return true;
  if (rhs.visible_viewport_size < lhs.visible_viewport_size)
    return false;
  if (lhs.content_color_usage < rhs.content_color_usage)
    return true;
  if (rhs.content_color_usage < lhs.content_color_usage)
    return false;
  if (lhs.may_contain_video < rhs.may_contain_video)
    return true;
  if (rhs.may_contain_video < lhs.may_contain_video)
    return false;
  if (lhs.may_throttle_if_undrawn_frames < rhs.may_throttle_if_undrawn_frames)
    return true;
  if (rhs.may_throttle_if_undrawn_frames < lhs.may_throttle_if_undrawn_frames)
    return false;
  if (lhs.is_handling_interaction < rhs.is_handling_interaction)
    return true;
  if (rhs.is_handling_interaction < lhs.is_handling_interaction)
    return false;
  if (lhs.is_handling_animation < rhs.is_handling_animation)
    return true;
  if (rhs.is_handling_animation < lhs.is_handling_animation)
    return false;
  if (lhs.root_background_color < rhs.root_background_color)
    return true;
  if (rhs.root_background_color < lhs.root_background_color)
    return false;
  if (lhs.latency_info < rhs.latency_info)
    return true;
  if (rhs.latency_info < lhs.latency_info)
    return false;
  if (lhs.referenced_surfaces < rhs.referenced_surfaces)
    return true;
  if (rhs.referenced_surfaces < lhs.referenced_surfaces)
    return false;
  if (lhs.deadline < rhs.deadline)
    return true;
  if (rhs.deadline < lhs.deadline)
    return false;
  if (lhs.activation_dependencies < rhs.activation_dependencies)
    return true;
  if (rhs.activation_dependencies < lhs.activation_dependencies)
    return false;
  if (lhs.begin_frame_ack < rhs.begin_frame_ack)
    return true;
  if (rhs.begin_frame_ack < lhs.begin_frame_ack)
    return false;
  if (lhs.frame_token < rhs.frame_token)
    return true;
  if (rhs.frame_token < lhs.frame_token)
    return false;
  if (lhs.send_frame_token_to_embedder < rhs.send_frame_token_to_embedder)
    return true;
  if (rhs.send_frame_token_to_embedder < lhs.send_frame_token_to_embedder)
    return false;
  if (lhs.top_controls_visible_height_set < rhs.top_controls_visible_height_set)
    return true;
  if (rhs.top_controls_visible_height_set < lhs.top_controls_visible_height_set)
    return false;
  if (lhs.top_controls_visible_height < rhs.top_controls_visible_height)
    return true;
  if (rhs.top_controls_visible_height < lhs.top_controls_visible_height)
    return false;
  if (lhs.min_page_scale_factor < rhs.min_page_scale_factor)
    return true;
  if (rhs.min_page_scale_factor < lhs.min_page_scale_factor)
    return false;
  if (lhs.display_transform_hint < rhs.display_transform_hint)
    return true;
  if (rhs.display_transform_hint < lhs.display_transform_hint)
    return false;
  if (lhs.is_mobile_optimized < rhs.is_mobile_optimized)
    return true;
  if (rhs.is_mobile_optimized < lhs.is_mobile_optimized)
    return false;
  if (lhs.delegated_ink_metadata < rhs.delegated_ink_metadata)
    return true;
  if (rhs.delegated_ink_metadata < lhs.delegated_ink_metadata)
    return false;
  if (lhs.transition_directives < rhs.transition_directives)
    return true;
  if (rhs.transition_directives < lhs.transition_directives)
    return false;
  if (lhs.capture_bounds < rhs.capture_bounds)
    return true;
  if (rhs.capture_bounds < lhs.capture_bounds)
    return false;
  if (lhs.has_shared_element_resources < rhs.has_shared_element_resources)
    return true;
  if (rhs.has_shared_element_resources < lhs.has_shared_element_resources)
    return false;
  if (lhs.screenshot_destination < rhs.screenshot_destination)
    return true;
  if (rhs.screenshot_destination < lhs.screenshot_destination)
    return false;
  if (lhs.is_software < rhs.is_software)
    return true;
  if (rhs.is_software < lhs.is_software)
    return false;
  if (lhs.offset_tag_definitions < rhs.offset_tag_definitions)
    return true;
  if (rhs.offset_tag_definitions < lhs.offset_tag_definitions)
    return false;
  if (lhs.offset_tag_values < rhs.offset_tag_values)
    return true;
  if (rhs.offset_tag_values < lhs.offset_tag_values)
    return false;
  if (lhs.frame_interval_inputs < rhs.frame_interval_inputs)
    return true;
  if (rhs.frame_interval_inputs < lhs.frame_interval_inputs)
    return false;
  if (lhs.trees_in_viz_timing < rhs.trees_in_viz_timing)
    return true;
  if (rhs.trees_in_viz_timing < lhs.trees_in_viz_timing)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::CompositorFrameMetadata::DataView,
                                         ::viz::mojom::blink::CompositorFrameMetadataPtr> {
  static bool IsNull(const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::CompositorFrameMetadataPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::device_scale_factor) device_scale_factor(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::root_scroll_offset)& root_scroll_offset(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->root_scroll_offset;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::page_scale_factor) page_scale_factor(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::scrollable_viewport_size)& scrollable_viewport_size(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->scrollable_viewport_size;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::visible_viewport_size)& visible_viewport_size(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->visible_viewport_size;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::content_color_usage) content_color_usage(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->content_color_usage;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::may_contain_video) may_contain_video(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->may_contain_video;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::may_throttle_if_undrawn_frames) may_throttle_if_undrawn_frames(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->may_throttle_if_undrawn_frames;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::is_handling_interaction) is_handling_interaction(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->is_handling_interaction;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::is_handling_animation) is_handling_animation(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->is_handling_animation;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::root_background_color)& root_background_color(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->root_background_color;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::latency_info)& latency_info(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->latency_info;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::referenced_surfaces)& referenced_surfaces(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->referenced_surfaces;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::deadline)& deadline(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->deadline;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::activation_dependencies)& activation_dependencies(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->activation_dependencies;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::begin_frame_ack)& begin_frame_ack(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->begin_frame_ack;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::frame_token) frame_token(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->frame_token;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::send_frame_token_to_embedder) send_frame_token_to_embedder(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->send_frame_token_to_embedder;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::top_controls_visible_height_set) top_controls_visible_height_set(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->top_controls_visible_height_set;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::top_controls_visible_height) top_controls_visible_height(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->top_controls_visible_height;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::min_page_scale_factor) min_page_scale_factor(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->min_page_scale_factor;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::display_transform_hint) display_transform_hint(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->display_transform_hint;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::is_mobile_optimized) is_mobile_optimized(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->is_mobile_optimized;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::delegated_ink_metadata)& delegated_ink_metadata(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->delegated_ink_metadata;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::transition_directives)& transition_directives(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->transition_directives;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::capture_bounds)& capture_bounds(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->capture_bounds;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::has_shared_element_resources) has_shared_element_resources(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->has_shared_element_resources;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::screenshot_destination)& screenshot_destination(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->screenshot_destination;
  }

  static decltype(::viz::mojom::blink::CompositorFrameMetadata::is_software) is_software(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->is_software;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::offset_tag_definitions)& offset_tag_definitions(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->offset_tag_definitions;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::offset_tag_values)& offset_tag_values(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->offset_tag_values;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::frame_interval_inputs)& frame_interval_inputs(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->frame_interval_inputs;
  }

  static const decltype(::viz::mojom::blink::CompositorFrameMetadata::trees_in_viz_timing)& trees_in_viz_timing(
      const ::viz::mojom::blink::CompositorFrameMetadataPtr& input) {
    return input->trees_in_viz_timing;
  }

  static bool Read(::viz::mojom::blink::CompositorFrameMetadata::DataView input, ::viz::mojom::blink::CompositorFrameMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_BLINK_H_