// services/viz/public/mojom/compositing/blit_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/blit_request.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/blit_request.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/blit_request.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/exported_shared_image.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/viz/public/cpp/compositing/blit_request_mojom_traits.h"




namespace viz::mojom {








class  BlitRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlitRequest, T>::value>;
  using DataView = BlitRequestDataView;
  using Data_ = internal::BlitRequest_Data;

  template <typename... Args>
  static BlitRequestPtr New(Args&&... args) {
    return BlitRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlitRequestPtr From(const U& u) {
    return mojo::TypeConverter<BlitRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlitRequest>::Convert(*this);
  }


  BlitRequest();

  BlitRequest(
      const ::gfx::Point& destination_region_offset,
      ::viz::LetterboxingBehavior letterboxing_behavior,
      ::gpu::ExportedSharedImage shared_image,
      const ::gpu::SyncToken& sync_token,
      bool populates_gpu_memory_buffer);

BlitRequest(const BlitRequest&) = delete;
BlitRequest& operator=(const BlitRequest&) = delete;

  ~BlitRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlitRequestPtr>
  BlitRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlitRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlitRequest_UnserializedMessageContext<
            UserType, BlitRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlitRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlitRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlitRequest_UnserializedMessageContext<
            UserType, BlitRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlitRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Point destination_region_offset;
  
  ::viz::LetterboxingBehavior letterboxing_behavior;
  
  ::gpu::ExportedSharedImage shared_image;
  
  ::gpu::SyncToken sync_token;
  
  bool populates_gpu_memory_buffer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlitRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BlitRequestPtr BlitRequest::Clone() const {
  return New(
      mojo::Clone(destination_region_offset),
      mojo::Clone(letterboxing_behavior),
      mojo::Clone(shared_image),
      mojo::Clone(sync_token),
      mojo::Clone(populates_gpu_memory_buffer)
  );
}

template <typename T, BlitRequest::EnableIfSame<T>*>
bool BlitRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->destination_region_offset, other_struct.destination_region_offset))
    return false;
  if (!mojo::Equals(this->letterboxing_behavior, other_struct.letterboxing_behavior))
    return false;
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->populates_gpu_memory_buffer, other_struct.populates_gpu_memory_buffer))
    return false;
  return true;
}

template <typename T, BlitRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.destination_region_offset < rhs.destination_region_offset)
    return true;
  if (rhs.destination_region_offset < lhs.destination_region_offset)
    return false;
  if (lhs.letterboxing_behavior < rhs.letterboxing_behavior)
    return true;
  if (rhs.letterboxing_behavior < lhs.letterboxing_behavior)
    return false;
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.populates_gpu_memory_buffer < rhs.populates_gpu_memory_buffer)
    return true;
  if (rhs.populates_gpu_memory_buffer < lhs.populates_gpu_memory_buffer)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::BlitRequest::DataView,
                                         ::viz::mojom::BlitRequestPtr> {
  static bool IsNull(const ::viz::mojom::BlitRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BlitRequestPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::BlitRequest::destination_region_offset)& destination_region_offset(
      const ::viz::mojom::BlitRequestPtr& input) {
    return input->destination_region_offset;
  }

  static decltype(::viz::mojom::BlitRequest::letterboxing_behavior) letterboxing_behavior(
      const ::viz::mojom::BlitRequestPtr& input) {
    return input->letterboxing_behavior;
  }

  static  decltype(::viz::mojom::BlitRequest::shared_image)& shared_image(
       ::viz::mojom::BlitRequestPtr& input) {
    return input->shared_image;
  }

  static const decltype(::viz::mojom::BlitRequest::sync_token)& sync_token(
      const ::viz::mojom::BlitRequestPtr& input) {
    return input->sync_token;
  }

  static decltype(::viz::mojom::BlitRequest::populates_gpu_memory_buffer) populates_gpu_memory_buffer(
      const ::viz::mojom::BlitRequestPtr& input) {
    return input->populates_gpu_memory_buffer;
  }

  static bool Read(::viz::mojom::BlitRequest::DataView input, ::viz::mojom::BlitRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_H_