// services/viz/public/mojom/compositing/blit_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/blit_request.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/public/mojom/compositing/blit_request.mojom-data-view.h"




namespace std {

template <>
struct hash<::viz::mojom::LetterboxingBehavior>
    : public mojo::internal::EnumHashImpl<::viz::mojom::LetterboxingBehavior> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::LetterboxingBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::LetterboxingBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::LetterboxingBehavior>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BlitRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BlitRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BlitRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::destination_region_offset(input)) in_destination_region_offset = Traits::destination_region_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->destination_region_offset)::BaseType> destination_region_offset_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_destination_region_offset,
      destination_region_offset_fragment);

    fragment->destination_region_offset.Set(
        destination_region_offset_fragment.is_null() ? nullptr : destination_region_offset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->destination_region_offset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null destination_region_offset in BlitRequest struct");

    
    mojo::internal::Serialize<::viz::mojom::LetterboxingBehavior>(
      Traits::letterboxing_behavior(input),
      &fragment->letterboxing_behavior);

    decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
      in_shared_image,
      shared_image_fragment);

    fragment->shared_image.Set(
        shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_image in BlitRequest struct");

    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
      in_sync_token,
      sync_token_fragment);

    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sync_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sync_token in BlitRequest struct");

    fragment->populates_gpu_memory_buffer = Traits::populates_gpu_memory_buffer(input);
  }

  static bool Deserialize(::viz::mojom::internal::BlitRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BlitRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void BlitRequestDataView::GetDestinationRegionOffsetDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->destination_region_offset.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void BlitRequestDataView::GetSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void BlitRequestDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::LetterboxingBehavior> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::LetterboxingBehavior value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_SHARED_H_