// services/viz/public/mojom/compositing/blit_request.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/viz/public/mojom/compositing/blit_request.mojom-shared-internal.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace viz::mojom {
class BlitRequestDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BlitRequestDataView> {
  using Data = ::viz::mojom::internal::BlitRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class LetterboxingBehavior : int32_t {
  
  kDoNotLetterbox = 0,
  
  kLetterbox = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, LetterboxingBehavior value);
inline bool IsKnownEnumValue(LetterboxingBehavior value) {
  return internal::LetterboxingBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BlitRequestDataView {
 public:
  BlitRequestDataView() = default;

  BlitRequestDataView(
      internal::BlitRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDestinationRegionOffsetDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinationRegionOffset(UserType* output) {
    
    auto* pointer = data_->destination_region_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLetterboxingBehavior(UserType* output) const {
    auto data_value = data_->letterboxing_behavior;
    return mojo::internal::Deserialize<::viz::mojom::LetterboxingBehavior>(
        data_value, output);
  }
  LetterboxingBehavior letterboxing_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::LetterboxingBehavior>(data_->letterboxing_behavior));
  }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
  bool populates_gpu_memory_buffer() const {
    return data_->populates_gpu_memory_buffer;
  }
 private:
  internal::BlitRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BLIT_REQUEST_MOJOM_DATA_VIEW_H_