// services/viz/public/mojom/compositing/begin_frame_args.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::BeginFrameArgsType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BeginFrameIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->source_id = Traits::source_id(input);

      fragment->sequence_number = Traits::sequence_number(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BeginFrameArgsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameArgsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameArgs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_time(input)) in_frame_time = Traits::frame_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_time)::BaseType> frame_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_frame_time,
        frame_time_fragment);

      fragment->frame_time.Set(
          frame_time_fragment.is_null() ? nullptr : frame_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_time in BeginFrameArgs struct");

      decltype(Traits::deadline(input)) in_deadline = Traits::deadline(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->deadline)::BaseType> deadline_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_deadline,
        deadline_fragment);

      fragment->deadline.Set(
          deadline_fragment.is_null() ? nullptr : deadline_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->deadline.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deadline in BeginFrameArgs struct");

      decltype(Traits::interval(input)) in_interval = Traits::interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interval)::BaseType> interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_interval,
        interval_fragment);

      fragment->interval.Set(
          interval_fragment.is_null() ? nullptr : interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interval in BeginFrameArgs struct");

      decltype(Traits::frame_id(input)) in_frame_id = Traits::frame_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_id)::BaseType> frame_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::BeginFrameIdDataView, send_validation>(
        in_frame_id,
        frame_id_fragment);

      fragment->frame_id.Set(
          frame_id_fragment.is_null() ? nullptr : frame_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_id in BeginFrameArgs struct");

      fragment->frames_throttled_since_last = Traits::frames_throttled_since_last(input);

      fragment->trace_id = Traits::trace_id(input);

      decltype(Traits::dispatch_time(input)) in_dispatch_time = Traits::dispatch_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dispatch_time)::BaseType> dispatch_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_dispatch_time,
        dispatch_time_fragment);

      fragment->dispatch_time.Set(
          dispatch_time_fragment.is_null() ? nullptr : dispatch_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dispatch_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dispatch_time in BeginFrameArgs struct");

      decltype(Traits::client_arrival_time(input)) in_client_arrival_time = Traits::client_arrival_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_arrival_time)::BaseType> client_arrival_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_client_arrival_time,
        client_arrival_time_fragment);

      fragment->client_arrival_time.Set(
          client_arrival_time_fragment.is_null() ? nullptr : client_arrival_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->client_arrival_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_arrival_time in BeginFrameArgs struct");

      
      mojo::internal::Serialize<::viz::mojom::BeginFrameArgsType>(
        Traits::type(input),
        &fragment->type);

      fragment->on_critical_path = Traits::on_critical_path(input);

      fragment->animate_only = Traits::animate_only(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::BeginFrameAckDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BeginFrameAckDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::BeginFrameAck_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->source_id = Traits::source_id(input);

      fragment->sequence_number = Traits::sequence_number(input);

      fragment->trace_id = Traits::trace_id(input);

      fragment->has_damage = Traits::has_damage(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_SEND_VALIDATION_H_